/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.spirit_instiller;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.MultiblockCrafter;
import de.dafuqs.spectrum.blocks.memory.MemoryItem;
import de.dafuqs.spectrum.blocks.spirit_instiller.SpiritInstillerBlockEntity;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.interfaces.PlayerOwned;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;

public class SpiritInstillerRecipe
extends GatedSpectrumRecipe {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("midgame/build_spirit_instiller_structure");
    public static final int CENTER_INGREDIENT = 0;
    public static final int FIRST_INGREDIENT = 1;
    public static final int SECOND_INGREDIENT = 2;
    protected final IngredientStack centerIngredient;
    protected final IngredientStack bowlIngredient1;
    protected final IngredientStack bowlIngredient2;
    protected final class_1799 outputItemStack;
    protected final int craftingTime;
    protected final float experience;
    protected final boolean noBenefitsFromYieldAndEfficiencyUpgrades;

    public SpiritInstillerRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, IngredientStack centerIngredient, IngredientStack bowlIngredient1, IngredientStack bowlIngredient2, class_1799 outputItemStack, int craftingTime, float experience, boolean noBenefitsFromYieldAndEfficiencyUpgrades) {
        super(id, group, secret, requiredAdvancementIdentifier);
        this.centerIngredient = centerIngredient;
        this.bowlIngredient1 = bowlIngredient1;
        this.bowlIngredient2 = bowlIngredient2;
        this.outputItemStack = outputItemStack;
        this.craftingTime = craftingTime;
        this.experience = experience;
        this.noBenefitsFromYieldAndEfficiencyUpgrades = noBenefitsFromYieldAndEfficiencyUpgrades;
        this.registerInToastManager(this.method_17716(), this);
    }

    public boolean method_8115(class_1263 inv, class_1937 world) {
        List<IngredientStack> ingredientStacks = this.getIngredientStacks();
        if (inv.method_5439() > 2 && ingredientStacks.get(0).test(inv.method_5438(0))) {
            if (ingredientStacks.get(1).test(inv.method_5438(1))) {
                return ingredientStacks.get(2).test(inv.method_5438(2));
            }
            if (ingredientStacks.get(1).test(inv.method_5438(2))) {
                return ingredientStacks.get(2).test(inv.method_5438(1));
            }
        }
        return false;
    }

    public class_1799 method_8110() {
        return this.outputItemStack.method_7972();
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeTypes.SPIRIT_INSTILLING_SERIALIZER;
    }

    @Deprecated
    public class_2371<class_1856> method_8117() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)this.centerIngredient.getIngredient());
        defaultedList.add((Object)this.bowlIngredient1.getIngredient());
        defaultedList.add((Object)this.bowlIngredient2.getIngredient());
        return defaultedList;
    }

    public List<IngredientStack> getIngredientStacks() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)this.centerIngredient);
        defaultedList.add((Object)this.bowlIngredient1);
        defaultedList.add((Object)this.bowlIngredient2);
        return defaultedList;
    }

    public class_1799 method_8116(class_1263 inv) {
        class_1799 resultStack = class_1799.field_8037;
        if (inv instanceof SpiritInstillerBlockEntity) {
            boolean makeUnrecognizable;
            SpiritInstillerBlockEntity spiritInstillerBlockEntity = (SpiritInstillerBlockEntity)inv;
            Map<Upgradeable.UpgradeType, Float> upgrades = spiritInstillerBlockEntity.getUpgrades();
            class_1937 world = spiritInstillerBlockEntity.method_10997();
            class_2338 pos = spiritInstillerBlockEntity.method_11016();
            resultStack = this.method_8110().method_7972();
            if (!this.areYieldAndEfficiencyUpgradesDisabled() && (double)upgrades.get((Object)Upgradeable.UpgradeType.YIELD).floatValue() != 1.0) {
                int resultCountMod = Support.getIntFromDecimalWithChance((float)resultStack.method_7947() * upgrades.get((Object)Upgradeable.UpgradeType.YIELD).floatValue(), world.field_9229);
                resultStack.method_7939(resultCountMod);
            }
            if (resultStack.method_31574(SpectrumBlocks.MEMORY.method_8389()) && (makeUnrecognizable = spiritInstillerBlockEntity.method_5438(0).method_31573(SpectrumItemTags.MEMORY_BONDING_AGENTS_CONCEALABLE))) {
                MemoryItem.makeUnrecognizable(resultStack);
            }
            int awardedExperience = 0;
            if (this.getExperience() > 0.0f) {
                double experienceModifier = upgrades.get((Object)Upgradeable.UpgradeType.EXPERIENCE).floatValue();
                float recipeExperienceBeforeMod = this.getExperience();
                awardedExperience = Support.getIntFromDecimalWithChance((double)recipeExperienceBeforeMod * experienceModifier, world.field_9229);
                MultiblockCrafter.spawnExperience(world, pos.method_10084(), awardedExperience);
            }
            SpiritInstillerRecipe.grantPlayerSpiritInstillingAdvancementCriterion(spiritInstillerBlockEntity.getOwnerUUID(), resultStack, awardedExperience);
        }
        return resultStack;
    }

    protected static void grantPlayerSpiritInstillingAdvancementCriterion(UUID playerUUID, class_1799 resultStack, int experience) {
        class_3222 serverPlayerEntity = (class_3222)PlayerOwned.getPlayerEntityIfOnline(playerUUID);
        if (serverPlayerEntity != null) {
            SpectrumAdvancementCriteria.SPIRIT_INSTILLER_CRAFTING.trigger(serverPlayerEntity, resultStack, experience);
        }
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public boolean areYieldAndEfficiencyUpgradesDisabled() {
        return this.noBenefitsFromYieldAndEfficiencyUpgrades;
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public boolean canPlayerCraft(class_1657 playerEntity) {
        return AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)UNLOCK_IDENTIFIER) && AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)this.requiredAdvancementIdentifier);
    }

    @Override
    public String getRecipeTypeShortID() {
        return "spirit_instiller";
    }

    public boolean canCraftWithStacks(class_1799 instillerStack, class_1799 leftBowlStack, class_1799 rightBowlStack) {
        return true;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)SpectrumBlocks.SPIRIT_INSTILLER);
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.SPIRIT_INSTILLING;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 3;
    }
}

