/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.spirit_instiller;

import com.google.gson.JsonObject;
import de.dafuqs.spectrum.recipe.GatedRecipeSerializer;
import de.dafuqs.spectrum.recipe.RecipeUtils;
import de.dafuqs.spectrum.recipe.spirit_instiller.SpiritInstillerRecipe;
import net.id.incubus_core.recipe.IngredientStack;
import net.id.incubus_core.recipe.RecipeParser;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class SpiritInstillerRecipeSerializer
implements GatedRecipeSerializer<SpiritInstillerRecipe> {
    public final RecipeFactory<SpiritInstillerRecipe> recipeFactory;

    public SpiritInstillerRecipeSerializer(RecipeFactory<SpiritInstillerRecipe> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public SpiritInstillerRecipe read(class_2960 identifier, JsonObject jsonObject) {
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        IngredientStack centerIngredient = RecipeParser.ingredientStackFromJson((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"center_ingredient"));
        IngredientStack bowlIngredient1 = RecipeParser.ingredientStackFromJson((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"ingredient1"));
        IngredientStack bowlIngredient2 = RecipeParser.ingredientStackFromJson((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"ingredient2"));
        class_1799 outputItemStack = RecipeUtils.itemStackWithNbtFromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
        int craftingTime = class_3518.method_15282((JsonObject)jsonObject, (String)"time", (int)200);
        float experience = class_3518.method_15277((JsonObject)jsonObject, (String)"experience", (float)1.0f);
        boolean noBenefitsFromYieldAndEfficiencyUpgrades = false;
        if (class_3518.method_15278((JsonObject)jsonObject, (String)"disable_yield_and_efficiency_upgrades")) {
            noBenefitsFromYieldAndEfficiencyUpgrades = class_3518.method_15258((JsonObject)jsonObject, (String)"disable_yield_and_efficiency_upgrades", (boolean)false);
        }
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, centerIngredient, bowlIngredient1, bowlIngredient2, outputItemStack, craftingTime, experience, noBenefitsFromYieldAndEfficiencyUpgrades);
    }

    public void write(class_2540 packetByteBuf, SpiritInstillerRecipe recipe) {
        packetByteBuf.method_10814(recipe.group);
        packetByteBuf.writeBoolean(recipe.secret);
        this.writeNullableIdentifier(packetByteBuf, recipe.requiredAdvancementIdentifier);
        recipe.centerIngredient.write(packetByteBuf);
        recipe.bowlIngredient1.write(packetByteBuf);
        recipe.bowlIngredient2.write(packetByteBuf);
        packetByteBuf.method_10793(recipe.outputItemStack);
        packetByteBuf.writeInt(recipe.craftingTime);
        packetByteBuf.writeFloat(recipe.experience);
        packetByteBuf.writeBoolean(recipe.noBenefitsFromYieldAndEfficiencyUpgrades);
    }

    public SpiritInstillerRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        boolean secret = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(packetByteBuf);
        IngredientStack centerIngredient = IngredientStack.fromByteBuf((class_2540)packetByteBuf);
        IngredientStack bowlIngredient1 = IngredientStack.fromByteBuf((class_2540)packetByteBuf);
        IngredientStack bowlIngredient2 = IngredientStack.fromByteBuf((class_2540)packetByteBuf);
        class_1799 outputItemStack = packetByteBuf.method_10819();
        int craftingTime = packetByteBuf.readInt();
        float experience = packetByteBuf.readFloat();
        boolean noBenefitsFromYieldAndEfficiencyUpgrades = packetByteBuf.readBoolean();
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, centerIngredient, bowlIngredient1, bowlIngredient2, outputItemStack, craftingTime, experience, noBenefitsFromYieldAndEfficiencyUpgrades);
    }

    public static interface RecipeFactory<SpiritInstillerRecipe> {
        public SpiritInstillerRecipe create(class_2960 var1, String var2, boolean var3, class_2960 var4, IngredientStack var5, IngredientStack var6, IngredientStack var7, class_1799 var8, int var9, float var10, boolean var11);
    }
}

