/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.titration_barrel;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.helpers.TimeHelper;
import de.dafuqs.spectrum.items.food.beverages.BeverageItem;
import de.dafuqs.spectrum.items.food.beverages.properties.BeverageProperties;
import de.dafuqs.spectrum.items.food.beverages.properties.VariantBeverageProperties;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.titration_barrel.ITitrationBarrelRecipe;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.ArrayList;
import java.util.List;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_5250;

public class TitrationBarrelRecipe
extends GatedSpectrumRecipe
implements ITitrationBarrelRecipe {
    public static final class_1799 NOT_FERMENTED_LONG_ENOUGH_OUTPUT_STACK = class_1802.field_8574.method_7854();
    public static final class_1799 PURE_ALCOHOL_STACK = SpectrumItems.PURE_ALCOHOL.method_7854();
    protected final List<IngredientStack> inputStacks;
    protected final class_1799 outputItemStack;
    protected final class_1792 tappingItem;
    protected final class_3611 fluid;
    protected final int minFermentationTimeHours;
    protected final FermentationData fermentationData;

    public TitrationBarrelRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, List<IngredientStack> inputStacks, class_3611 fluid, class_1799 outputItemStack, class_1792 tappingItem, int minFermentationTimeHours, FermentationData fermentationData) {
        super(id, group, secret, requiredAdvancementIdentifier);
        this.inputStacks = inputStacks;
        this.fluid = fluid;
        this.minFermentationTimeHours = minFermentationTimeHours;
        this.outputItemStack = outputItemStack;
        this.tappingItem = tappingItem;
        this.fermentationData = fermentationData;
        this.registerInToastManager(this.method_17716(), this);
    }

    public boolean method_8115(class_1263 inventory, class_1937 world) {
        return TitrationBarrelRecipe.matchIngredientStacksExclusively(inventory, this.getIngredientStacks());
    }

    @Deprecated
    public class_2371<class_1856> method_8117() {
        return IngredientStack.listIngredients(this.inputStacks);
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        return this.inputStacks;
    }

    @Override
    public class_1792 getTappingItem() {
        return this.tappingItem;
    }

    @Override
    public int getMinFermentationTimeHours() {
        return this.minFermentationTimeHours;
    }

    @Override
    public FermentationData getFermentationData() {
        return this.fermentationData;
    }

    public class_1799 method_8116(class_1263 inventory) {
        return class_1799.field_8037;
    }

    public class_1799 method_8110() {
        class_1799 stack = this.tapWith(1.0f, (long)this.minFermentationTimeHours * 60L * 60L, 0.4f, 0.8f);
        stack.method_7939(this.outputItemStack.method_7947());
        return stack;
    }

    @Override
    public class_3611 getFluid() {
        return this.fluid;
    }

    @Override
    public float getAngelsSharePerMcDay() {
        if (this.fermentationData == null) {
            return 0.0f;
        }
        return this.fermentationData.angelsSharePercentPerMcDay;
    }

    @Override
    public class_1799 tap(class_1263 inventory, long secondsFermented, float downfall, float temperature) {
        int contentCount = InventoryHelper.countItemsInInventory(inventory);
        float thickness = this.getThickness(contentCount);
        return this.tapWith(thickness, secondsFermented, downfall, temperature);
    }

    private class_1799 tapWith(float thickness, long secondsFermented, float downfall, float temperature) {
        BeverageProperties properties;
        if (secondsFermented / 60L / 60L < (long)this.minFermentationTimeHours) {
            return NOT_FERMENTED_LONG_ENOUGH_OUTPUT_STACK;
        }
        class_1799 stack = this.outputItemStack.method_7972();
        stack.method_7939(1);
        if (this.fermentationData == null) {
            return stack;
        }
        float ageIngameDays = TimeHelper.minecraftDaysFromSeconds(secondsFermented);
        double alcPercent = 0.0;
        if (this.fermentationData.fermentationSpeedMod > 0.0f) {
            alcPercent = this.getAlcPercent(thickness, downfall, ageIngameDays);
            alcPercent = Math.max(0.0, alcPercent);
        }
        if (alcPercent >= 100.0) {
            return PURE_ALCOHOL_STACK;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof BeverageItem) {
            BeverageItem beverageItem = (BeverageItem)class_17922;
            properties = beverageItem.getBeverageProperties(stack);
        } else {
            properties = VariantBeverageProperties.getFromStack(stack);
        }
        if (properties instanceof VariantBeverageProperties) {
            BeverageProperties variantBeverageProperties = properties;
            float durationMultiplier = 1.5f - thickness / 2.0f;
            ArrayList<class_1293> effects = new ArrayList<class_1293>();
            for (StatusEffectEntry entry : this.fermentationData.statusEffectEntries) {
                int potency = -1;
                int durationTicks = entry.baseDuration;
                for (StatusEffectPotencyEntry potencyEntry : entry.potencyEntries) {
                    if (!(thickness >= (float)potencyEntry.minThickness) || !(alcPercent >= (double)potencyEntry.minAlcPercent)) continue;
                    potency = potencyEntry.potency;
                }
                if (potency <= -1) continue;
                effects.add(new class_1293(entry.statusEffect, (int)((float)durationTicks * durationMultiplier), potency));
            }
            ((VariantBeverageProperties)variantBeverageProperties).statusEffects = effects;
        }
        properties.alcPercent = (int)alcPercent;
        properties.ageDays = (long)ageIngameDays;
        properties.thickness = thickness;
        return properties.getStack(stack);
    }

    protected double getAlcPercent(float thickness, float downfall, float ageIngameDays) {
        return Support.logBase(1.0f + this.fermentationData.fermentationSpeedMod, (double)ageIngameDays * (0.5 + (double)thickness / 2.0) * (0.5 + (double)downfall / 2.0));
    }

    protected float getThickness(int contentCount) {
        int inputStacksCount = 0;
        for (IngredientStack stack : this.inputStacks) {
            inputStacksCount += stack.getCount();
        }
        return (float)contentCount / (float)inputStacksCount;
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeTypes.TITRATION_BARREL_RECIPE_SERIALIZER;
    }

    public static class_5250 getDurationText(int minFermentationTimeHours, FermentationData fermentationData) {
        class_5250 text = fermentationData == null ? (minFermentationTimeHours == 1 ? class_2561.method_43471((String)"container.spectrum.rei.titration_barrel.time_hour") : (minFermentationTimeHours == 24 ? class_2561.method_43471((String)"container.spectrum.rei.titration_barrel.time_day") : (minFermentationTimeHours > 72 ? class_2561.method_43469((String)"container.spectrum.rei.titration_barrel.time_days", (Object[])new Object[]{Support.getWithOneDecimalAfterComma((float)minFermentationTimeHours / 24.0f)}) : class_2561.method_43469((String)"container.spectrum.rei.titration_barrel.time_hours", (Object[])new Object[]{minFermentationTimeHours})))) : (minFermentationTimeHours == 1 ? class_2561.method_43471((String)"container.spectrum.rei.titration_barrel.at_least_time_hour") : (minFermentationTimeHours == 24 ? class_2561.method_43471((String)"container.spectrum.rei.titration_barrel.at_least_time_day") : (minFermentationTimeHours > 72 ? class_2561.method_43469((String)"container.spectrum.rei.titration_barrel.at_least_time_days", (Object[])new Object[]{Support.getWithOneDecimalAfterComma((float)minFermentationTimeHours / 24.0f)}) : class_2561.method_43469((String)"container.spectrum.rei.titration_barrel.at_least_time_hours", (Object[])new Object[]{minFermentationTimeHours}))));
        return text;
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return ITitrationBarrelRecipe.UNLOCK_ADVANCEMENT_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "titration_barrel";
    }

    public record FermentationData(float fermentationSpeedMod, float angelsSharePercentPerMcDay, List<StatusEffectEntry> statusEffectEntries) {
        public static FermentationData fromJson(JsonObject jsonObject) {
            float fermentationSpeedMod = class_3518.method_15277((JsonObject)jsonObject, (String)"fermentation_speed_mod", (float)1.0f);
            float angelsSharePerMcDay = class_3518.method_15277((JsonObject)jsonObject, (String)"angels_share_percent_per_mc_day", (float)0.1f);
            ArrayList<StatusEffectEntry> statusEffectEntries = new ArrayList<StatusEffectEntry>();
            if (class_3518.method_15264((JsonObject)jsonObject, (String)"effects")) {
                JsonArray effectsArray = class_3518.method_15261((JsonObject)jsonObject, (String)"effects");
                for (int i = 0; i < effectsArray.size(); ++i) {
                    JsonObject object = effectsArray.get(i).getAsJsonObject();
                    statusEffectEntries.add(StatusEffectEntry.fromJson(object));
                }
            }
            return new FermentationData(fermentationSpeedMod, angelsSharePerMcDay, statusEffectEntries);
        }

        public void write(class_2540 packetByteBuf) {
            packetByteBuf.writeFloat(this.fermentationSpeedMod);
            packetByteBuf.writeFloat(this.angelsSharePercentPerMcDay);
            packetByteBuf.writeInt(this.statusEffectEntries.size());
            for (StatusEffectEntry statusEffectEntry : this.statusEffectEntries) {
                statusEffectEntry.write(packetByteBuf);
            }
        }

        public static FermentationData read(class_2540 packetByteBuf) {
            float fermentationSpeedMod = packetByteBuf.readFloat();
            float angelsSharePerMcDay = packetByteBuf.readFloat();
            int statusEffectEntryCount = packetByteBuf.readInt();
            ArrayList<StatusEffectEntry> statusEffectEntries = new ArrayList<StatusEffectEntry>(statusEffectEntryCount);
            for (int i = 0; i < statusEffectEntryCount; ++i) {
                statusEffectEntries.add(StatusEffectEntry.read(packetByteBuf));
            }
            return new FermentationData(fermentationSpeedMod, angelsSharePerMcDay, statusEffectEntries);
        }
    }

    public record StatusEffectEntry(class_1291 statusEffect, int baseDuration, List<StatusEffectPotencyEntry> potencyEntries) {
        public static StatusEffectEntry fromJson(JsonObject jsonObject) {
            class_2960 statusEffectIdentifier = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"id"));
            class_1291 statusEffect = (class_1291)class_2378.field_11159.method_10223(statusEffectIdentifier);
            if (statusEffect == null) {
                SpectrumCommon.logError("Status effect " + statusEffectIdentifier + " does not exist in the status effect registry. Falling back to WEAKNESS");
                statusEffect = class_1294.field_5911;
            }
            int baseDuration = class_3518.method_15282((JsonObject)jsonObject, (String)"base_duration", (int)1200);
            ArrayList<StatusEffectPotencyEntry> potencyEntries = new ArrayList<StatusEffectPotencyEntry>();
            if (class_3518.method_15264((JsonObject)jsonObject, (String)"potency")) {
                JsonArray potencyArray = class_3518.method_15261((JsonObject)jsonObject, (String)"potency");
                for (int i = 0; i < potencyArray.size(); ++i) {
                    JsonObject object = potencyArray.get(i).getAsJsonObject();
                    potencyEntries.add(StatusEffectPotencyEntry.fromJson(object));
                }
            } else {
                potencyEntries.add(new StatusEffectPotencyEntry(0, 0, 0));
            }
            return new StatusEffectEntry(statusEffect, baseDuration, potencyEntries);
        }

        public void write(class_2540 packetByteBuf) {
            packetByteBuf.method_10814(class_2378.field_11159.method_10221((Object)this.statusEffect).toString());
            packetByteBuf.writeInt(this.baseDuration);
            packetByteBuf.writeInt(this.potencyEntries.size());
            for (StatusEffectPotencyEntry potencyEntry : this.potencyEntries) {
                potencyEntry.write(packetByteBuf);
            }
        }

        public static StatusEffectEntry read(class_2540 packetByteBuf) {
            class_2960 statusEffectIdentifier = class_2960.method_12829((String)packetByteBuf.method_19772());
            class_1291 statusEffect = (class_1291)class_2378.field_11159.method_10223(statusEffectIdentifier);
            int baseDuration = packetByteBuf.readInt();
            int potencyEntryCount = packetByteBuf.readInt();
            ArrayList<StatusEffectPotencyEntry> potencyEntries = new ArrayList<StatusEffectPotencyEntry>(potencyEntryCount);
            for (int i = 0; i < potencyEntryCount; ++i) {
                potencyEntries.add(StatusEffectPotencyEntry.read(packetByteBuf));
            }
            return new StatusEffectEntry(statusEffect, baseDuration, potencyEntries);
        }
    }

    public record StatusEffectPotencyEntry(int minAlcPercent, int minThickness, int potency) {
        public static StatusEffectPotencyEntry fromJson(JsonObject jsonObject) {
            int minAlcPercent = class_3518.method_15282((JsonObject)jsonObject, (String)"min_alc", (int)0);
            int minThickness = class_3518.method_15282((JsonObject)jsonObject, (String)"min_thickness", (int)0);
            int potency = class_3518.method_15282((JsonObject)jsonObject, (String)"potency", (int)0);
            return new StatusEffectPotencyEntry(minAlcPercent, minThickness, potency);
        }

        public void write(class_2540 packetByteBuf) {
            packetByteBuf.writeInt(this.minAlcPercent);
            packetByteBuf.writeInt(this.minThickness);
            packetByteBuf.writeInt(this.potency);
        }

        public static StatusEffectPotencyEntry read(class_2540 packetByteBuf) {
            return new StatusEffectPotencyEntry(packetByteBuf.readInt(), packetByteBuf.readInt(), packetByteBuf.readInt());
        }
    }
}

