/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.titration_barrel;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.recipe.GatedRecipeSerializer;
import de.dafuqs.spectrum.recipe.RecipeUtils;
import de.dafuqs.spectrum.recipe.titration_barrel.TitrationBarrelRecipe;
import java.util.List;
import net.id.incubus_core.recipe.IngredientStack;
import net.id.incubus_core.recipe.RecipeParser;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class TitrationBarrelRecipeSerializer
implements GatedRecipeSerializer<TitrationBarrelRecipe> {
    public final RecipeFactory<TitrationBarrelRecipe> recipeFactory;

    public TitrationBarrelRecipeSerializer(RecipeFactory<TitrationBarrelRecipe> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public TitrationBarrelRecipe read(class_2960 identifier, JsonObject jsonObject) {
        class_2960 fluidIdentifier;
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        JsonArray ingredientArray = class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients");
        List ingredients = RecipeParser.ingredientStacksFromJson((JsonArray)ingredientArray, (int)ingredientArray.size());
        class_3611 fluid = class_3612.field_15906;
        if (class_3518.method_15289((JsonObject)jsonObject, (String)"fluid") && (fluid = (class_3611)class_2378.field_11154.method_10223(fluidIdentifier = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"fluid")))).method_15785().method_15769()) {
            SpectrumCommon.logError("Fusion Shrine Recipe " + identifier + " specifies fluid " + fluidIdentifier + " that does not exist! This recipe will not be craftable.");
        }
        class_1799 outputItemStack = RecipeUtils.itemStackWithNbtFromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
        int minTimeDays = class_3518.method_15282((JsonObject)jsonObject, (String)"min_fermentation_time_hours", (int)24);
        class_1792 tappingItem = class_1802.field_8162;
        if (class_3518.method_15289((JsonObject)jsonObject, (String)"tapping_item")) {
            tappingItem = (class_1792)class_2378.field_11142.method_10223(class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"tapping_item")));
        }
        TitrationBarrelRecipe.FermentationData fermentationData = null;
        if (class_3518.method_34923((JsonObject)jsonObject, (String)"fermentation_data")) {
            fermentationData = TitrationBarrelRecipe.FermentationData.fromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"fermentation_data"));
        }
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, ingredients, fluid, outputItemStack, tappingItem, minTimeDays, fermentationData);
    }

    public void write(class_2540 packetByteBuf, TitrationBarrelRecipe recipe) {
        packetByteBuf.method_10814(recipe.group);
        packetByteBuf.writeBoolean(recipe.secret);
        this.writeNullableIdentifier(packetByteBuf, recipe.requiredAdvancementIdentifier);
        packetByteBuf.writeShort(recipe.inputStacks.size());
        for (IngredientStack ingredientStack : recipe.inputStacks) {
            ingredientStack.write(packetByteBuf);
        }
        this.writeNullableIdentifier(packetByteBuf, class_2378.field_11154.method_10221((Object)recipe.fluid));
        packetByteBuf.method_10793(recipe.outputItemStack);
        packetByteBuf.method_10814(class_2378.field_11142.method_10221((Object)recipe.tappingItem).toString());
        packetByteBuf.writeInt(recipe.minFermentationTimeHours);
        if (recipe.fermentationData == null) {
            packetByteBuf.writeBoolean(false);
        } else {
            packetByteBuf.writeBoolean(true);
            recipe.fermentationData.write(packetByteBuf);
        }
    }

    public TitrationBarrelRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        boolean secret = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(packetByteBuf);
        short craftingInputCount = packetByteBuf.readShort();
        List ingredients = IngredientStack.decodeByteBuf((class_2540)packetByteBuf, (int)craftingInputCount);
        class_3611 fluid = class_3612.field_15906;
        class_2960 fluidId = this.readNullableIdentifier(packetByteBuf);
        if (fluidId != null) {
            fluid = (class_3611)class_2378.field_11154.method_10223(fluidId);
        }
        class_1799 outputItemStack = packetByteBuf.method_10819();
        class_1792 tappingItem = (class_1792)class_2378.field_11142.method_10223(class_2960.method_12829((String)packetByteBuf.method_19772()));
        int minTimeDays = packetByteBuf.readInt();
        TitrationBarrelRecipe.FermentationData fermentationData = null;
        if (packetByteBuf.readBoolean()) {
            fermentationData = TitrationBarrelRecipe.FermentationData.read(packetByteBuf);
        }
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, ingredients, fluid, outputItemStack, tappingItem, minTimeDays, fermentationData);
    }

    public static interface RecipeFactory<TitrationBarrelRecipe> {
        public TitrationBarrelRecipe create(class_2960 var1, String var2, boolean var3, class_2960 var4, List<IngredientStack> var5, class_3611 var6, class_1799 var7, class_1792 var8, int var9, TitrationBarrelRecipe.FermentationData var10);
    }
}

