/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.titration_barrel.dynamic;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.helpers.TimeHelper;
import de.dafuqs.spectrum.items.food.beverages.BeverageItem;
import de.dafuqs.spectrum.items.food.beverages.properties.StatusEffectBeverageProperties;
import de.dafuqs.spectrum.recipe.titration_barrel.TitrationBarrelRecipe;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2356;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6862;
import org.apache.commons.lang3.tuple.Pair;

public class SuspiciousBrewRecipe
extends TitrationBarrelRecipe {
    public static final class_1865<SuspiciousBrewRecipe> SERIALIZER = new class_1866(SuspiciousBrewRecipe::new);
    public static final class_1792 TAPPING_ITEM = class_1802.field_8469;
    public static final int MIN_FERMENTATION_TIME_HOURS = 4;
    public static final class_1799 OUTPUT_STACK = SuspiciousBrewRecipe.getDefaultStackWithCount(SpectrumItems.SUSPICIOUS_BREW, 4);
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("progression/unlock_suspicious_brew");
    public static final List<IngredientStack> INGREDIENT_STACKS = new ArrayList<IngredientStack>(){
        {
            this.add(IngredientStack.of((class_1856)class_1856.method_8106((class_6862)class_3489.field_15543)));
            this.add(IngredientStack.of((class_1856)class_1856.method_8106((class_6862)class_3489.field_15543)));
            this.add(IngredientStack.of((class_1856)class_1856.method_8106((class_6862)class_3489.field_15543)));
            this.add(IngredientStack.of((class_1856)class_1856.method_8106((class_6862)class_3489.field_15543)));
        }
    };

    public SuspiciousBrewRecipe(class_2960 identifier) {
        super(identifier, "", false, UNLOCK_IDENTIFIER, INGREDIENT_STACKS, (class_3611)class_3612.field_15910, OUTPUT_STACK, TAPPING_ITEM, 4, new TitrationBarrelRecipe.FermentationData(1.0f, 0.1f, List.of()));
    }

    @Override
    public class_1799 method_8110() {
        class_1799 flowerStack = class_1802.field_8880.method_7854();
        flowerStack.method_7939(4);
        class_1799 tappedStack = this.tapWith(List.of(flowerStack), 1.0f, (long)this.minFermentationTimeHours * 60L * 60L, 0.4f, 0.8f);
        BeverageItem.setPreviewStack(tappedStack);
        tappedStack.method_7939(OUTPUT_STACK.method_7947());
        return tappedStack;
    }

    @Override
    public class_1799 tap(class_1263 inventory, long secondsFermented, float downfall, float temperature) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        int itemCount = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            stacks.add(stack);
            itemCount += stack.method_7947();
        }
        float thickness = this.getThickness(itemCount);
        return this.tapWith(stacks, thickness, secondsFermented, downfall, temperature);
    }

    public class_1799 tapWith(List<class_1799> stacks, float thickness, long secondsFermented, float downfall, float temperature) {
        if (secondsFermented / 60L / 60L < (long)this.minFermentationTimeHours) {
            return NOT_FERMENTED_LONG_ENOUGH_OUTPUT_STACK;
        }
        float ageIngameDays = TimeHelper.minecraftDaysFromSeconds(secondsFermented);
        double alcPercent = this.getAlcPercent(thickness, downfall, ageIngameDays);
        if (alcPercent >= 100.0) {
            return PURE_ALCOHOL_STACK;
        }
        HashMap<class_1291, Integer> stewEffects = new HashMap<class_1291, Integer>();
        for (class_1799 stack : stacks) {
            Optional<Pair<class_1291, Integer>> stewEffect = this.getStewEffectFrom(stack);
            if (!stewEffect.isPresent()) continue;
            class_1291 effect = (class_1291)stewEffect.get().getLeft();
            int n = (Integer)stewEffect.get().getRight() * stack.method_7947();
            if (stewEffects.containsKey(effect)) {
                stewEffects.put(effect, (Integer)stewEffects.get(effect) + n);
                continue;
            }
            stewEffects.put(effect, n);
        }
        ArrayList<class_1293> finalStatusEffects = new ArrayList<class_1293>();
        double cappedAlcPercent = Math.min(alcPercent, 20.0);
        for (Map.Entry entry : stewEffects.entrySet()) {
            int finalDurationTicks = (int)Math.pow(((Integer)entry.getValue()).intValue(), 1.0 + cappedAlcPercent * 0.075);
            finalStatusEffects.add(new class_1293((class_1291)entry.getKey(), finalDurationTicks, 0));
        }
        class_1799 outputStack = OUTPUT_STACK.method_7972();
        outputStack.method_7939(1);
        return new StatusEffectBeverageProperties((long)ageIngameDays, (int)alcPercent, thickness, finalStatusEffects).getStack(outputStack);
    }

    private Optional<Pair<class_1291, Integer>> getStewEffectFrom(class_1799 stack) {
        class_1747 blockItem;
        class_2248 block;
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747 && (block = (blockItem = (class_1747)item).method_7711()) instanceof class_2356) {
            class_2356 flowerBlock = (class_2356)block;
            return Optional.of(Pair.of((Object)flowerBlock.method_10188(), (Object)flowerBlock.method_10187()));
        }
        return Optional.empty();
    }

    @Override
    public boolean method_8115(class_1263 inventory, class_1937 world) {
        boolean flowerFound = false;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            if (stack.method_31573(class_3489.field_15543)) {
                flowerFound = true;
                continue;
            }
            return false;
        }
        return flowerFound;
    }

    @Override
    public class_1799 method_8116(class_1263 inventory) {
        return class_1799.field_8037;
    }

    @Override
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }
}

