/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.fluid.LiquidCrystalFluid;
import de.dafuqs.spectrum.blocks.fluid.MidnightSolutionFluid;
import de.dafuqs.spectrum.blocks.fluid.MudFluid;
import de.dafuqs.spectrum.registries.color.ItemColors;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1160;
import net.minecraft.class_1767;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;

public class SpectrumFluids {
    public static final class_3609 LIQUID_CRYSTAL = new LiquidCrystalFluid.StillLiquidCrystal();
    public static final class_3609 FLOWING_LIQUID_CRYSTAL = new LiquidCrystalFluid.FlowingLiquidCrystal();
    public static final class_1160 LIQUID_CRYSTAL_COLOR = new class_1160(0.7f, 0.67f, 0.81f);
    public static final class_3609 MUD = new MudFluid.StillMud();
    public static final class_3609 FLOWING_MUD = new MudFluid.FlowingMud();
    public static final class_1160 MUD_COLOR = new class_1160(0.26f, 0.14f, 0.01f);
    public static final class_3609 MIDNIGHT_SOLUTION = new MidnightSolutionFluid.StillMidnightSolution();
    public static final class_3609 FLOWING_MIDNIGHT_SOLUTION = new MidnightSolutionFluid.FlowingMidnightSolution();
    public static final class_1160 MIDNIGHT_SOLUTION_COLOR = new class_1160(0.07f, 0.07f, 0.2f);

    private static void registerFluid(String name, class_3611 fluid, class_1767 dyeColor) {
        class_2378.method_10230((class_2378)class_2378.field_11154, (class_2960)SpectrumCommon.locate(name), (Object)fluid);
        ItemColors.FLUID_COLORS.registerColorMapping(fluid, dyeColor);
    }

    public static void register() {
        SpectrumFluids.registerFluid("liquid_crystal", (class_3611)LIQUID_CRYSTAL, class_1767.field_7967);
        SpectrumFluids.registerFluid("flowing_liquid_crystal", (class_3611)FLOWING_LIQUID_CRYSTAL, class_1767.field_7967);
        SpectrumFluids.registerFluid("mud", (class_3611)MUD, class_1767.field_7957);
        SpectrumFluids.registerFluid("flowing_mud", (class_3611)FLOWING_MUD, class_1767.field_7957);
        SpectrumFluids.registerFluid("midnight_solution", (class_3611)MIDNIGHT_SOLUTION, class_1767.field_7944);
        SpectrumFluids.registerFluid("flowing_midnight_solution", (class_3611)FLOWING_MIDNIGHT_SOLUTION, class_1767.field_7944);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClient() {
        SpectrumFluids.setupFluidRendering((class_3611)LIQUID_CRYSTAL, (class_3611)FLOWING_LIQUID_CRYSTAL, "liquid_crystal", 0xCBBBCB);
        BlockRenderLayerMap.INSTANCE.putFluids(class_1921.method_23583(), new class_3611[]{LIQUID_CRYSTAL, FLOWING_LIQUID_CRYSTAL});
        SpectrumFluids.setupFluidRendering((class_3611)MUD, (class_3611)FLOWING_MUD, "mud", 5123594);
        BlockRenderLayerMap.INSTANCE.putFluids(class_1921.method_23583(), new class_3611[]{MUD, FLOWING_MUD});
        SpectrumFluids.setupFluidRendering((class_3611)MIDNIGHT_SOLUTION, (class_3611)FLOWING_MIDNIGHT_SOLUTION, "midnight_solution", 1120315);
        BlockRenderLayerMap.INSTANCE.putFluids(class_1921.method_23583(), new class_3611[]{MIDNIGHT_SOLUTION, FLOWING_MIDNIGHT_SOLUTION});
    }

    @Environment(value=EnvType.CLIENT)
    private static void setupFluidRendering(class_3611 still, class_3611 flowing, String textureFluidId, final int color) {
        final class_2960 stillSpriteId = SpectrumCommon.locate("block/" + textureFluidId + "_still");
        final class_2960 flowingSpriteId = SpectrumCommon.locate("block/" + textureFluidId + "_flow");
        ClientSpriteRegistryCallback.event((class_2960)class_1059.field_5275).register((atlasTexture, registry) -> {
            registry.register(stillSpriteId);
            registry.register(flowingSpriteId);
        });
        class_2960 fluidId = class_2378.field_11154.method_10221((Object)still);
        final class_2960 listenerId = new class_2960(fluidId.method_12836(), fluidId.method_12832() + "_reload_listener");
        final class_1058[] fluidSprites = new class_1058[]{null, null};
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public void method_14491(class_3300 manager) {
                Function atlas = class_310.method_1551().method_1549(class_1059.field_5275);
                fluidSprites[0] = (class_1058)atlas.apply(stillSpriteId);
                fluidSprites[1] = (class_1058)atlas.apply(flowingSpriteId);
            }

            public class_2960 getFabricId() {
                return listenerId;
            }
        });
        FluidRenderHandler renderHandler = new FluidRenderHandler(){

            public class_1058[] getFluidSprites(class_1920 view, class_2338 pos, class_3610 state) {
                return fluidSprites;
            }

            public int getFluidColor(class_1920 view, class_2338 pos, class_3610 state) {
                return color;
            }
        };
        FluidRenderHandlerRegistry.INSTANCE.register(still, renderHandler);
        FluidRenderHandlerRegistry.INSTANCE.register(flowing, renderHandler);
    }
}

