/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries.client;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.conditional.ColoredLeavesBlock;
import de.dafuqs.spectrum.blocks.memory.MemoryBlockEntity;
import de.dafuqs.spectrum.blocks.memory.MemoryItem;
import de.dafuqs.spectrum.energy.storage.SingleInkStorage;
import de.dafuqs.spectrum.helpers.ColorHelper;
import de.dafuqs.spectrum.items.energy.InkFlaskItem;
import de.dafuqs.spectrum.progression.ToggleableBlockColorProvider;
import de.dafuqs.spectrum.progression.ToggleableItemColorProvider;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1293;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_322;
import net.minecraft.class_326;

public class SpectrumColorProviders {
    public static ToggleableBlockColorProvider coloredLeavesBlockColorProvider;
    public static ToggleableItemColorProvider coloredLeavesItemColorProvider;
    public static ToggleableBlockColorProvider amaranthBushelBlockColorProvider;
    public static ToggleableItemColorProvider amaranthBushelItemColorProvider;
    public static ToggleableBlockColorProvider amaranthCropBlockColorProvider;
    public static ToggleableItemColorProvider amaranthCropItemColorProvider;

    public static void registerClient() {
        SpectrumCommon.logInfo("Registering Block and Item Color Providers...");
        SpectrumColorProviders.registerColoredLeaves();
        SpectrumColorProviders.registerAmaranth();
        SpectrumColorProviders.registerClover();
        SpectrumColorProviders.registerMemories();
        SpectrumColorProviders.registerPotionPentants();
        SpectrumColorProviders.registerInkFlask();
        SpectrumColorProviders.registerBrewColors();
    }

    private static void registerColoredLeaves() {
        class_322 leavesBlockColorProvider = (class_322)ColorProviderRegistry.BLOCK.get((Object)class_2246.field_10503);
        class_326 leavesItemColorProvider = (class_326)ColorProviderRegistry.ITEM.get((Object)class_2246.field_10503);
        if (leavesBlockColorProvider != null && leavesItemColorProvider != null) {
            coloredLeavesBlockColorProvider = new ToggleableBlockColorProvider(leavesBlockColorProvider);
            coloredLeavesItemColorProvider = new ToggleableItemColorProvider(leavesItemColorProvider);
            for (class_1767 dyeColor : class_1767.values()) {
                ColoredLeavesBlock block = ColoredLeavesBlock.byColor(dyeColor);
                ColorProviderRegistry.BLOCK.register((Object)coloredLeavesBlockColorProvider, (Object[])new class_2248[]{block});
                ColorProviderRegistry.ITEM.register((Object)coloredLeavesItemColorProvider, (Object[])new class_1935[]{block});
            }
        }
    }

    private static void registerAmaranth() {
        class_322 fernBlockColorProvider = (class_322)ColorProviderRegistry.BLOCK.get((Object)class_2246.field_10112);
        class_326 fernItemColorProvider = (class_326)ColorProviderRegistry.ITEM.get((Object)class_2246.field_10112);
        if (fernBlockColorProvider != null && fernItemColorProvider != null) {
            amaranthBushelBlockColorProvider = new ToggleableBlockColorProvider(fernBlockColorProvider);
            amaranthBushelItemColorProvider = new ToggleableItemColorProvider(fernItemColorProvider);
            ColorProviderRegistry.BLOCK.register((Object)amaranthBushelBlockColorProvider, (Object[])new class_2248[]{SpectrumBlocks.AMARANTH_BUSHEL});
            ColorProviderRegistry.ITEM.register((Object)amaranthBushelItemColorProvider, (Object[])new class_1935[]{SpectrumBlocks.AMARANTH_BUSHEL});
            ColorProviderRegistry.BLOCK.register((Object)amaranthBushelBlockColorProvider, (Object[])new class_2248[]{SpectrumBlocks.POTTED_AMARANTH_BUSHEL});
        }
        class_322 largeFernBlockColorProvider = (class_322)ColorProviderRegistry.BLOCK.get((Object)class_2246.field_10313);
        class_326 largeFernItemColorProvider = (class_326)ColorProviderRegistry.ITEM.get((Object)class_2246.field_10313);
        if (largeFernBlockColorProvider != null && largeFernItemColorProvider != null) {
            amaranthCropBlockColorProvider = new ToggleableBlockColorProvider(largeFernBlockColorProvider);
            amaranthCropItemColorProvider = new ToggleableItemColorProvider(largeFernItemColorProvider);
            ColorProviderRegistry.BLOCK.register((Object)amaranthCropBlockColorProvider, (Object[])new class_2248[]{SpectrumBlocks.AMARANTH});
            ColorProviderRegistry.ITEM.register((Object)amaranthCropItemColorProvider, (Object[])new class_1935[]{SpectrumBlocks.AMARANTH});
        }
    }

    private static void registerClover() {
        class_322 grassBlockColorProvider = (class_322)ColorProviderRegistry.BLOCK.get((Object)class_2246.field_10479);
        class_326 grassItemColorProvider = (class_326)ColorProviderRegistry.ITEM.get((Object)class_2246.field_10479.method_8389());
        if (grassBlockColorProvider != null && grassItemColorProvider != null) {
            ColorProviderRegistry.BLOCK.register((Object)grassBlockColorProvider, (Object[])new class_2248[]{SpectrumBlocks.CLOVER});
            ColorProviderRegistry.BLOCK.register((Object)grassBlockColorProvider, (Object[])new class_2248[]{SpectrumBlocks.FOUR_LEAF_CLOVER});
        }
    }

    private static void registerInkFlask() {
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if (tintIndex == 1) {
                InkFlaskItem i = (InkFlaskItem)stack.method_7909();
                SingleInkStorage storage = i.getEnergyStorage(stack);
                return ColorHelper.getInt(storage.getStoredColor().getDyeColor());
            }
            return -1;
        }, (Object[])new class_1935[]{SpectrumItems.INK_FLASK});
    }

    private static void registerPotionPentants() {
        ColorProviderRegistry.ITEM.register(SpectrumColorProviders::potionColor, (Object[])new class_1935[]{SpectrumItems.LESSER_POTION_PENDANT});
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if (tintIndex != 0 && tintIndex < 4) {
                List effects = class_1844.method_8067((class_1799)stack);
                if (tintIndex == 1) {
                    if (effects.size() > 0) {
                        return ((class_1293)effects.get(0)).method_5579().method_5556();
                    }
                } else if (tintIndex == 2) {
                    if (effects.size() > 1) {
                        return ((class_1293)effects.get(1)).method_5579().method_5556();
                    }
                } else if (effects.size() > 2) {
                    return ((class_1293)effects.get(2)).method_5579().method_5556();
                }
            }
            return -1;
        }, (Object[])new class_1935[]{SpectrumItems.GREATER_POTION_PENDANT});
    }

    private static void registerMemories() {
        ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> {
            if (world == null) {
                return 0;
            }
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof MemoryBlockEntity) {
                MemoryBlockEntity memoryBlockEntity = (MemoryBlockEntity)blockEntity;
                return memoryBlockEntity.getEggColor(tintIndex);
            }
            return 0;
        }, (Object[])new class_2248[]{SpectrumBlocks.MEMORY});
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> MemoryItem.getEggColor(stack.method_7969(), tintIndex), (Object[])new class_1935[]{SpectrumBlocks.MEMORY.method_8389()});
    }

    public static void registerBrewColors() {
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                class_2487 nbt = stack.method_7948();
                return nbt.method_10545("Color") ? nbt.method_10550("Color") : 16041675;
            }
            return -1;
        }, (Object[])new class_1935[]{SpectrumItems.INFUSED_BEVERAGE});
    }

    public static int potionColor(class_1799 stack, int tintIndex) {
        if (tintIndex == 1) {
            class_2487 nbtCompound = stack.method_7969();
            if (nbtCompound != null && nbtCompound.method_10573("CustomPotionColor", 3)) {
                return nbtCompound.method_10550("CustomPotionColor");
            }
            List effects = class_1844.method_8067((class_1799)stack);
            if (effects.size() > 0) {
                return class_1844.method_8055((Collection)effects);
            }
        }
        return -1;
    }
}

