/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries.client;

import de.dafuqs.spectrum.blocks.present.PresentBlock;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.energy.storage.SingleInkStorage;
import de.dafuqs.spectrum.interfaces.PlayerEntityAccessor;
import de.dafuqs.spectrum.items.ActivatableItem;
import de.dafuqs.spectrum.items.ExperienceStorageItem;
import de.dafuqs.spectrum.items.energy.InkFlaskItem;
import de.dafuqs.spectrum.items.magic_items.EnderSpliceItem;
import de.dafuqs.spectrum.items.magic_items.PaintbrushItem;
import de.dafuqs.spectrum.items.tools.SpectrumFishingRodItem;
import de.dafuqs.spectrum.items.trinkets.AshenCircletItem;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_638;
import net.minecraft.class_809;

public class SpectrumItemPredicates {
    public static class_809.class_811 currentItemRenderMode;

    public static void registerClient() {
        SpectrumItemPredicates.registerBowPredicates(SpectrumItems.BEDROCK_BOW);
        SpectrumItemPredicates.registerCrossbowPredicates(SpectrumItems.BEDROCK_CROSSBOW);
        SpectrumItemPredicates.registerSpectrumFishingRodItemPredicates(SpectrumItems.LAGOON_ROD);
        SpectrumItemPredicates.registerSpectrumFishingRodItemPredicates(SpectrumItems.MOLTEN_ROD);
        SpectrumItemPredicates.registerSpectrumFishingRodItemPredicates(SpectrumItems.BEDROCK_FISHING_ROD);
        SpectrumItemPredicates.registerEnderSplicePredicates(SpectrumItems.ENDER_SPLICE);
        SpectrumItemPredicates.registerAnimatedWandPredicates(SpectrumItems.NATURES_STAFF);
        SpectrumItemPredicates.registerAnimatedWandPredicates(SpectrumItems.RADIANCE_STAFF);
        SpectrumItemPredicates.registerKnowledgeDropPredicates(SpectrumItems.KNOWLEDGE_GEM);
        SpectrumItemPredicates.registerAshenCircletPredicates(SpectrumItems.ASHEN_CIRCLET);
        SpectrumItemPredicates.registerColorPredicate(SpectrumItems.PAINTBRUSH);
        SpectrumItemPredicates.registerInkColorPredicate(SpectrumItems.INK_FLASK);
        SpectrumItemPredicates.registerInkFillStateItemPredicate(SpectrumItems.INK_FLASK);
        SpectrumItemPredicates.registerMoonPhasePredicates(SpectrumItems.CRESCENT_CLOCK);
        SpectrumItemPredicates.registerDreamFlayerPredicates((class_1792)SpectrumItems.DREAMFLAYER);
        SpectrumItemPredicates.registerBottomlessBundlePredicates(SpectrumItems.BOTTOMLESS_BUNDLE);
        SpectrumItemPredicates.registerEnchantmentCanvasPrediates(SpectrumItems.ENCHANTMENT_CANVAS);
        SpectrumItemPredicates.registerPresentPredicates(SpectrumBlocks.PRESENT.method_8389());
    }

    private static void registerColorPredicate(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("color"), (itemStack, clientWorld, livingEntity, i) -> {
            Optional<InkColor> color = PaintbrushItem.getColor(itemStack);
            if (color.isEmpty()) {
                return 0.0f;
            }
            return (1.0f + (float)color.get().getDyeColor().method_7789()) / 100.0f;
        });
    }

    private static void registerPresentPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("variant"), (itemStack, clientWorld, livingEntity, i) -> {
            class_2487 compound = itemStack.method_7969();
            if (compound == null || !compound.method_10573("Variant", 8)) {
                return 0.0f;
            }
            PresentBlock.Variant variant = PresentBlock.Variant.valueOf(compound.method_10558("Variant").toUpperCase(Locale.ROOT));
            return (float)variant.ordinal() / 10.0f;
        });
    }

    private static void registerBottomlessBundlePredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("locked"), (itemStack, clientWorld, livingEntity, i) -> {
            class_2487 compound = itemStack.method_7969();
            if (compound == null) {
                return 0.0f;
            }
            return compound.method_10545("Locked") ? 1.0f : 0.0f;
        });
        class_5272.method_27879((class_1792)SpectrumItems.BOTTOMLESS_BUNDLE, (class_2960)new class_2960("filled"), (itemStack, clientWorld, livingEntity, i) -> {
            class_2487 compound = itemStack.method_7969();
            if (compound == null) {
                return 0.0f;
            }
            return compound.method_10545("StoredStack") ? 1.0f : 0.0f;
        });
    }

    private static void registerMoonPhasePredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("phase"), (itemStack, clientWorld, livingEntity, i) -> {
            class_1937 patt4648$temp;
            class_1309 entity;
            Object object = entity = livingEntity != null ? livingEntity : itemStack.method_27319();
            if (entity == null) {
                return 0.0f;
            }
            if (clientWorld == null && (patt4648$temp = entity.field_6002) instanceof class_638) {
                class_638 clientWorld1;
                clientWorld = clientWorld1 = (class_638)patt4648$temp;
            }
            if (clientWorld == null) {
                return 0.0f;
            }
            if (!clientWorld.method_8597().comp_645()) {
                return 1.0f;
            }
            return (float)clientWorld.method_30273() / 8.0f;
        });
    }

    private static void registerDreamFlayerPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("in_inventory"), (itemStack, world, livingEntity, i) -> currentItemRenderMode == class_809.class_811.field_4317 ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("activated"), (itemStack, clientWorld, livingEntity, i) -> {
            if (ActivatableItem.isActivated(itemStack)) {
                return 1.0f;
            }
            return 0.0f;
        });
    }

    private static void registerBowPredicates(class_1753 bowItem) {
        class_5272.method_27879((class_1792)bowItem, (class_2960)new class_2960("pull"), (itemStack, world, livingEntity, i) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.method_6030() != itemStack ? 0.0f : (float)(itemStack.method_7935() - livingEntity.method_6014()) / 20.0f;
        });
        class_5272.method_27879((class_1792)bowItem, (class_2960)new class_2960("pulling"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
    }

    private static void registerCrossbowPredicates(class_1764 crossbowItem) {
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)new class_2960("pull"), (itemStack, clientWorld, livingEntity, i) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return class_1764.method_7781((class_1799)itemStack) ? 0.0f : (float)(itemStack.method_7935() - livingEntity.method_6014()) / (float)class_1764.method_7775((class_1799)itemStack);
        });
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)new class_2960("pulling"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack && !class_1764.method_7781((class_1799)itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)new class_2960("charged"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && class_1764.method_7781((class_1799)itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)new class_2960("firework"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && class_1764.method_7781((class_1799)itemStack) && class_1764.method_7772((class_1799)itemStack, (class_1792)class_1802.field_8639) ? 1.0f : 0.0f);
    }

    private static void registerSpectrumFishingRodItemPredicates(SpectrumFishingRodItem fishingRodItem) {
        class_5272.method_27879((class_1792)fishingRodItem, (class_2960)new class_2960("cast"), (itemStack, clientWorld, livingEntity, i) -> {
            boolean isInOffhand;
            if (livingEntity == null) {
                return 0.0f;
            }
            boolean isInMainHand = livingEntity.method_6047() == itemStack;
            boolean bl = isInOffhand = livingEntity.method_6079() == itemStack;
            if (livingEntity.method_6047().method_7909() instanceof SpectrumFishingRodItem) {
                isInOffhand = false;
            }
            return (isInMainHand || isInOffhand) && livingEntity instanceof class_1657 && ((PlayerEntityAccessor)livingEntity).getSpectrumBobber() != null ? 1.0f : 0.0f;
        });
    }

    private static void registerEnderSplicePredicates(EnderSpliceItem enderSpliceItem) {
        class_5272.method_27879((class_1792)enderSpliceItem, (class_2960)new class_2960("bound"), (itemStack, clientWorld, livingEntity, i) -> {
            class_2487 compoundTag = itemStack.method_7969();
            if (compoundTag != null && (compoundTag.method_10545("PosX") || compoundTag.method_10545("TargetPlayerUUID"))) {
                return 1.0f;
            }
            return 0.0f;
        });
    }

    private static void registerAshenCircletPredicates(class_1792 ashenCircletItem) {
        class_5272.method_27879((class_1792)ashenCircletItem, (class_2960)new class_2960("cooldown"), (itemStack, clientWorld, livingEntity, i) -> {
            if (livingEntity != null && AshenCircletItem.getCooldownTicks(itemStack, livingEntity.field_6002) == 0L) {
                return 0.0f;
            }
            return 1.0f;
        });
    }

    private static void registerAnimatedWandPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("in_use"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
    }

    private static void registerKnowledgeDropPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("stored_experience_10000"), (itemStack, clientWorld, livingEntity, i) -> {
            if (SpectrumItems.KNOWLEDGE_GEM instanceof ExperienceStorageItem) {
                return (float)ExperienceStorageItem.getStoredExperience(itemStack) / 10000.0f;
            }
            return 0.0f;
        });
    }

    private static void registerInkColorPredicate(InkFlaskItem item) {
        class_5272.method_27879((class_1792)SpectrumItems.INK_FLASK, (class_2960)new class_2960("color"), (itemStack, clientWorld, livingEntity, i) -> {
            SingleInkStorage storage = SpectrumItems.INK_FLASK.getEnergyStorage(itemStack);
            InkColor color = storage.getStoredColor();
            return (1.0f + (float)color.getDyeColor().method_7789()) / 100.0f;
        });
    }

    private static void registerInkFillStateItemPredicate(InkFlaskItem item) {
        class_5272.method_27879((class_1792)SpectrumItems.INK_FLASK, (class_2960)new class_2960("fill_state"), (itemStack, world, livingEntity, i) -> {
            SingleInkStorage storage = SpectrumItems.INK_FLASK.getEnergyStorage(itemStack);
            long current = storage.getCurrentTotal();
            if (current == 0L) {
                return 0.0f;
            }
            long max = storage.getMaxTotal();
            return (float)Math.max(0.01, (double)current / (double)max);
        });
    }

    private static void registerEnchantmentCanvasPrediates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("bound"), (itemStack, world, livingEntity, i) -> {
            class_2487 nbt = itemStack.method_7969();
            if (nbt != null && nbt.method_10573("BoundItem", 8)) {
                return 1.0f;
            }
            return 0.0f;
        });
    }
}

