/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.status_effects;

import de.dafuqs.spectrum.cca.LastKillComponent;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import de.dafuqs.spectrum.status_effects.SpectrumStatusEffect;
import de.dafuqs.spectrum.status_effects.StackableStatusEffect;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_4081;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;

public class FrenzyStatusEffect
extends SpectrumStatusEffect
implements StackableStatusEffect {
    public static final String ATTACK_SPEED_UUID_STRING = "7ee7c082-1134-4dc5-b0f9-dab92723f560";
    public static final double ATTACK_SPEED_PER_STAGE = (double)0.1f;
    public static final String MOVEMENT_SPEED_UUID_STRING = "a215d081-48a9-4d6c-bdff-a153d4838324";
    public static final double MOVEMENT_SPEED_PER_STAGE = (double)0.1f;
    public static final String ATTACK_DAMAGE_UUID_STRING = "061a2c27-eae8-4643-a0c0-0f0d195bc9b1";
    public static final double ATTACK_DAMAGE_PER_STAGE = 0.5;
    public static final String KNOCKBACK_RESISTANCE_UUID_STRING = "b9d38c3a-75b5-462f-a624-eec9b987a5e2";
    public static final double KNOCKBACK_RESISTANCE_PER_STAGE = 0.25;
    public static final long REQUIRE_KILL_EVERY_X_TICKS = 300L;

    public FrenzyStatusEffect(class_4081 category, int color) {
        super(category, color);
    }

    @Override
    public void method_5572(class_1309 entity, int amplifier) {
        class_1324 instance = entity.method_5996(class_5134.field_23716);
        if (instance != null) {
            long lastKillTickForEntityID = LastKillComponent.getLastKillTick(entity);
            boolean scoredKillInTime = lastKillTickForEntityID >= 0L && entity.method_37908().method_8510() - lastKillTickForEntityID < 300L;
            this.tick(entity, amplifier, scoredKillInTime);
        }
    }

    @Override
    public boolean method_5552(int duration, int amplifier) {
        return (long)duration % 300L == 0L;
    }

    public void method_5555(class_1309 entity, class_5131 attributes, int amplifier) {
        if (!SpectrumStatusEffects.effectsAreGettingStacked && !entity.method_6059((class_1291)this)) {
            super.method_5555(entity, attributes, amplifier);
        }
    }

    public void method_5562(class_1309 entity, class_5131 attributes, int amplifier) {
        if (!SpectrumStatusEffects.effectsAreGettingStacked) {
            super.method_5562(entity, attributes, amplifier);
        }
    }

    public void tick(@NotNull class_1309 entity, int amplifier, boolean scoredKillInTimeFrame) {
        class_5131 attributes = entity.method_6127();
        if (attributes != null) {
            for (Map.Entry attributeEntry : this.method_5565().entrySet()) {
                class_1324 entityInstance = attributes.method_26842((class_1320)attributeEntry.getKey());
                if (entityInstance == null) continue;
                class_1322 baseAttributeValue = (class_1322)attributeEntry.getValue();
                class_1322 appliedModifier = entityInstance.method_6199(baseAttributeValue.method_6189());
                double newBaseValue = appliedModifier == null ? baseAttributeValue.method_6186() : appliedModifier.method_6186();
                double newValue = this.adjustModifierAmount(newBaseValue, ((class_1322)attributeEntry.getValue()).method_6186(), amplifier, scoredKillInTimeFrame);
                entityInstance.method_6202(baseAttributeValue);
                entityInstance.method_26837(new class_1322(baseAttributeValue.method_6189(), baseAttributeValue.method_6185(), newValue, baseAttributeValue.method_6182()));
                entityInstance.method_6194();
            }
        }
    }

    public double adjustModifierAmount(double existingValue, double additionalValue, int amplifier, boolean scoredKillInTimeFrame) {
        return scoredKillInTimeFrame ? existingValue + additionalValue * (double)(amplifier + 1) : existingValue - additionalValue * (double)(amplifier + 1);
    }
}

