/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.loot;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LootConfig {
    public HashMap<String, ItemGroup> item_groups = new HashMap();
    public HashMap<String, List<String>> loot_tables = new HashMap();

    public static LootConfig constrainValues(LootConfig config) {
        if (config.item_groups != null) {
            for (Map.Entry<String, ItemGroup> entry : config.item_groups.entrySet()) {
                ItemGroup group = entry.getValue();
                if (group.weight >= 1) continue;
                group.weight = 1;
            }
        }
        return config;
    }

    public static class ItemGroup {
        public List<String> ids = List.of();
        public float chance = 1.0f;
        public float bonus_roll_chance = 1.2f;
        public int weight = 1;
        public Enchant enchant = null;

        public ItemGroup() {
        }

        public ItemGroup(List<String> ids, int weight) {
            this.ids = ids;
            this.weight = weight;
        }

        public ItemGroup(List<String> ids, float chance, float bonus_roll_chance, int weight) {
            this.ids = ids;
            this.chance = chance;
            this.bonus_roll_chance = bonus_roll_chance;
            this.weight = weight;
        }

        public ItemGroup chance(float chance_multiplier) {
            this.chance = chance_multiplier;
            return this;
        }

        public ItemGroup enchant() {
            this.enchant = new Enchant();
            return this;
        }

        public ItemGroup enchant(int min, int max) {
            this.enchant = new Enchant(min, max);
            return this;
        }

        public static class Enchant {
            public float min_power = 1.0f;
            public float max_power = 30.0f;
            public boolean allow_treasure = true;

            public Enchant() {
            }

            public Enchant(float min_power, float max_power) {
                this.min_power = min_power;
                this.max_power = max_power;
            }

            public boolean isValid() {
                return this.min_power > 0.0f && this.max_power > this.min_power;
            }
        }
    }
}

