/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.spell;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.spell_engine.api.spell.Spell;
import net.spell_power.api.MagicSchool;
import org.jetbrains.annotations.Nullable;

public record SpellPool(List<class_2960> spellIds, List<MagicSchool> schools) {
    public static final SpellPool empty = new SpellPool(List.of(), List.of());

    public boolean isEmpty() {
        return this.spellIds.isEmpty();
    }

    @Nullable
    public MagicSchool firstSchool() {
        return this.schools().stream().findFirst().orElse(null);
    }

    public static SpellPool fromData(DataFormat json, Map<class_2960, Spell> spells) {
        Spell spell;
        class_2960 id;
        LinkedHashSet<class_2960> spellsIds = new LinkedHashSet<class_2960>();
        LinkedHashSet<MagicSchool> schools = new LinkedHashSet<MagicSchool>();
        if (json.spell_ids != null) {
            for (String string : json.spell_ids) {
                id = new class_2960(string);
                spell = spells.get(id);
                if (spell == null) continue;
                spellsIds.add(id);
                schools.add(spell.school);
            }
        }
        if (json.all_of_schools != null && !json.all_of_schools.isEmpty()) {
            for (Map.Entry entry : spells.entrySet()) {
                id = (class_2960)entry.getKey();
                spell = (Spell)entry.getValue();
                if (!json.all_of_schools.contains(spell.school)) continue;
                spellsIds.add(id);
                schools.add(spell.school);
            }
        }
        return new SpellPool(spellsIds.stream().toList(), schools.stream().toList());
    }

    public SyncFormat toSync() {
        SyncFormat formatted = new SyncFormat();
        formatted.spell_ids = this.spellIds.stream().map(class_2960::toString).toList();
        formatted.schools = this.schools.stream().map(Enum::toString).toList();
        return formatted;
    }

    public static SpellPool fromSync(SyncFormat json) {
        return new SpellPool(json.spell_ids.stream().map(class_2960::new).toList(), json.schools.stream().map(MagicSchool::valueOf).toList());
    }

    public static class DataFormat {
        public List<String> spell_ids = List.of();
        public List<MagicSchool> all_of_schools = List.of();
    }

    public static class SyncFormat {
        public List<String> spell_ids = List.of();
        public List<String> schools = List.of();
    }
}

