/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1074;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.gui.HudRenderHelper;
import net.spell_engine.config.HudConfig;

public class HudConfigScreen
extends class_437 {
    private class_437 previous;
    private boolean partConfigVisible = false;
    private final ArrayList<class_339> partButtons = new ArrayList();
    private final Map<Part, class_4286> checkBoxes = new HashMap<Part, class_4286>();
    private Dragged dragged;
    private int lastSelectedPreset = 0;

    public HudConfigScreen(class_437 previous) {
        super((class_2561)class_2561.method_43471((String)"gui.spell_engine.hud"));
        this.previous = previous;
    }

    private HudConfig config() {
        return (HudConfig)SpellEngineClient.hudConfig.value;
    }

    protected void method_25426() {
        int buttonWidth = 60;
        int padding = 5;
        int buttonHeight = 20;
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        this.method_37063((class_364)new class_4185(5, 5, buttonHeight, buttonHeight, (class_2561)class_2561.method_43471((String)"x"), button -> this.method_25419()));
        int y = centerY - 50;
        this.method_37063((class_364)new class_4185(centerX - padding - buttonWidth - buttonWidth / 2, y, buttonWidth, buttonHeight, (class_2561)class_2561.method_43471((String)"gui.spell_engine.parts"), button -> this.toggleParts()));
        this.method_37063((class_364)new class_4185(centerX - buttonWidth / 2, y, buttonWidth, buttonHeight, (class_2561)class_2561.method_43471((String)"gui.spell_engine.preset"), button -> this.nextPreset()));
        this.method_37063((class_364)new class_4185(centerX + padding + buttonWidth - buttonWidth / 2, y, buttonWidth, buttonHeight, (class_2561)class_2561.method_43471((String)"gui.spell_engine.reset"), button -> this.reset()));
        this.setupPartButtons();
    }

    private void setupPartButtons() {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int buttonWidth = 60;
        int y = centerY - 20;
        int x = centerX - buttonWidth / 2;
        List<class_339> targetButtons = this.createPartAdjustmentButtons(Part.TARGET, x, y);
        targetButtons.forEach(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.partButtons.addAll(targetButtons);
        List<class_339> iconButtons = this.createPartAdjustmentButtons(Part.ICON, x, y += 28);
        iconButtons.forEach(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.partButtons.addAll(iconButtons);
        List<class_4185> sizeButtons = this.createBarSizeButtons(x, y += 28);
        sizeButtons.forEach(x$0 -> {
            class_4185 cfr_ignored_0 = (class_4185)this.method_37063((class_364)x$0);
        });
        this.partButtons.addAll(sizeButtons);
        this.setPartsVisibility(this.partConfigVisible);
    }

    private List<class_339> createPartAdjustmentButtons(Part part, int x, int y) {
        ArrayList<class_339> buttons = new ArrayList<class_339>();
        int buttonSize = 20;
        int spacing = 8;
        boolean checked = this.partData((Part)part).visible;
        class_4286 checkBox = new class_4286(x, y, buttonSize, buttonSize, class_2561.method_30163((String)""), checked);
        buttons.add((class_339)checkBox);
        this.checkBoxes.put(part, checkBox);
        buttons.add((class_339)new class_4185(x += buttonSize + spacing, y, buttonSize, buttonSize, class_2561.method_30163((String)"\u2190"), button -> this.move(part, Direction.LEFT)));
        buttons.add((class_339)new class_4185(x += buttonSize + spacing, y, buttonSize, buttonSize, class_2561.method_30163((String)"\u2191"), button -> this.move(part, Direction.UP)));
        buttons.add((class_339)new class_4185(x += buttonSize + spacing, y, buttonSize, buttonSize, class_2561.method_30163((String)"\u2193"), button -> this.move(part, Direction.DOWN)));
        buttons.add((class_339)new class_4185(x += buttonSize + spacing, y, buttonSize, buttonSize, class_2561.method_30163((String)"\u2192"), button -> this.move(part, Direction.RIGHT)));
        return buttons;
    }

    private List<class_4185> createBarSizeButtons(int x, int y) {
        ArrayList<class_4185> buttons = new ArrayList<class_4185>();
        int buttonSize = 20;
        int spacing = 8;
        buttons.add(new class_4185(x, y, buttonSize, buttonSize, (class_2561)class_2561.method_43471((String)"-"), button -> this.changeBarWidth(false)));
        buttons.add(new class_4185(x += buttonSize + spacing, y, buttonSize, buttonSize, (class_2561)class_2561.method_43471((String)"+"), button -> this.changeBarWidth(true)));
        return buttons;
    }

    private void move(Part partType, Direction direction) {
        HudConfig.Part part = this.partData(partType);
        if (part != null) {
            class_241 diff = class_241.field_1340;
            switch (direction) {
                case LEFT: {
                    diff = new class_241(-1.0f, 0.0f);
                    break;
                }
                case RIGHT: {
                    diff = new class_241(1.0f, 0.0f);
                    break;
                }
                case UP: {
                    diff = new class_241(0.0f, -1.0f);
                    break;
                }
                case DOWN: {
                    diff = new class_241(0.0f, 1.0f);
                }
            }
            part.offset = part.offset.method_35586(diff);
        }
    }

    private HudConfig.Part partData(Part partType) {
        switch (partType) {
            case TARGET: {
                return this.config().castbar.target;
            }
            case ICON: {
                return this.config().castbar.icon;
            }
        }
        return null;
    }

    private void changeBarWidth(boolean increase) {
        int diff = increase ? 1 : -1;
        HudConfig config = (HudConfig)SpellEngineClient.hudConfig.value;
        if (!increase && config.castbar.width <= 0) {
            return;
        }
        config.castbar.width += diff;
    }

    private boolean partsVisible() {
        return this.partConfigVisible;
    }

    private void toggleParts() {
        this.setPartsVisibility(!this.partConfigVisible);
    }

    private void setPartsVisibility(boolean visibility) {
        this.partConfigVisible = visibility;
        for (class_339 button : this.partButtons) {
            button.field_22764 = this.partConfigVisible;
        }
    }

    public void method_25419() {
        this.save();
        this.field_22787.method_1507(this.previous);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        HudRenderHelper.render(matrices, delta, true);
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (this.partsVisible()) {
            int bigButtonWidth = 60;
            int centerX = this.field_22789 / 2;
            int centerY = this.field_22790 / 2;
            int lineSpacing = 28;
            int x = centerX - bigButtonWidth / 2 - 8;
            int y = centerY - 20 + 6;
            this.rightAlignedText(matrices, x, y, "gui.spell_engine.target");
            this.rightAlignedText(matrices, x, y += lineSpacing, "gui.spell_engine.icon");
            this.rightAlignedText(matrices, x, y += lineSpacing, "gui.spell_engine.bar_width");
        }
        for (Map.Entry<Part, class_4286> entry : this.checkBoxes.entrySet()) {
            this.partData((Part)entry.getKey()).visible = entry.getValue().method_20372();
        }
    }

    private void rightAlignedText(class_4587 matrices, int x, int y, String text) {
        String translated = class_1074.method_4662((String)text, (Object[])new Object[0]);
        int width = this.field_22793.method_1727(translated);
        this.field_22793.method_1729(matrices, translated, (float)(x - width), (float)y, 0xFFFFFF);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (HudRenderHelper.CastBarWidget.lastRendered != null && HudRenderHelper.CastBarWidget.lastRendered.contains(mouseX, mouseY)) {
            this.dragged = Dragged.CAST_BAR;
            return true;
        }
        if (HudRenderHelper.SpellHotBarWidget.lastRendered != null && HudRenderHelper.SpellHotBarWidget.lastRendered.contains(mouseX, mouseY)) {
            this.dragged = Dragged.HOT_BAR;
            return true;
        }
        if (HudRenderHelper.ErrorMessageWidget.lastRendered != null && HudRenderHelper.ErrorMessageWidget.lastRendered.contains(mouseX, mouseY)) {
            this.dragged = Dragged.ERROR_MESSAGE;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.dragged = null;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        boolean result = super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        if (!this.method_25397() && button == 0 && this.dragged != null) {
            HudConfig config = (HudConfig)SpellEngineClient.hudConfig.value;
            switch (this.dragged) {
                case CAST_BAR: {
                    config.castbar.base.offset = new class_241((float)((double)config.castbar.base.offset.field_1343 + deltaX), (float)((double)config.castbar.base.offset.field_1342 + deltaY));
                    break;
                }
                case HOT_BAR: {
                    config.hotbar.offset = new class_241((float)((double)config.hotbar.offset.field_1343 + deltaX), (float)((double)config.hotbar.offset.field_1342 + deltaY));
                    break;
                }
                case ERROR_MESSAGE: {
                    config.error_message.offset = new class_241((float)((double)config.error_message.offset.field_1343 + deltaX), (float)((double)config.error_message.offset.field_1342 + deltaY));
                }
            }
        }
        return result;
    }

    public void nextPreset() {
        ++this.lastSelectedPreset;
        try {
            SpellEngineClient.hudConfig.value = HudConfig.presets.get(this.lastSelectedPreset).copy();
        }
        catch (Exception e) {
            this.lastSelectedPreset = 0;
            SpellEngineClient.hudConfig.value = HudConfig.presets.get(0).copy();
        }
        this.refreshPartButtons();
    }

    public void save() {
        SpellEngineClient.hudConfig.save();
    }

    public void reset() {
        SpellEngineClient.hudConfig.value = HudConfig.createDefault();
        this.refreshPartButtons();
    }

    private void refreshPartButtons() {
        for (class_339 partButton : this.partButtons) {
            this.method_37066((class_364)partButton);
        }
        this.partButtons.clear();
        this.setupPartButtons();
    }

    static enum Part {
        TARGET,
        ICON;

    }

    static enum Direction {
        LEFT,
        RIGHT,
        UP,
        DOWN;

    }

    private static enum Dragged {
        CAST_BAR,
        HOT_BAR,
        ERROR_MESSAGE;

    }
}

