/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.entity;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.render.FlyingSpellEntity;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.particle.ParticleHelper;
import net.spell_engine.utils.RecordsWithGson;
import net.spell_engine.utils.TargetHelper;
import net.spell_engine.utils.VectorHelper;

public class SpellProjectile
extends class_1676
implements FlyingSpellEntity {
    public float range = 128.0f;
    private Spell spell;
    private SpellHelper.ImpactContext context;
    private class_1297 followedTarget;
    public class_243 previousVelocity;
    private Spell.ProjectileData clientSyncedData;
    private static String NBT_SPELL_DATA = "Spell.Data";
    private static String NBT_IMPACT_CONTEXT = "Impact.Context";
    private static final class_2940<String> BEHAVIOUR;
    private static final class_2940<String> CLIENT_DATA;
    private static final class_2940<Integer> TARGET_ID;

    public SpellProjectile(class_1299<? extends class_1676> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected SpellProjectile(class_1937 world, class_1309 owner) {
        super(SpellEngineMod.SPELL_PROJECTILE, world);
        this.method_7432((class_1297)owner);
    }

    public SpellProjectile(class_1937 world, class_1309 caster, double x, double y, double z, Behaviour behaviour, Spell spell, class_1297 target, SpellHelper.ImpactContext context) {
        this(world, caster);
        this.method_5814(x, y, z);
        this.spell = spell;
        Spell.ProjectileData projectileData = this.projectileData();
        Gson gson = new Gson();
        this.context = context;
        this.method_5841().method_12778(CLIENT_DATA, (Object)gson.toJson((Object)projectileData));
        this.method_5841().method_12778(BEHAVIOUR, (Object)behaviour.toString());
        this.setFollowedTarget(target);
    }

    private Spell.ProjectileData projectileData() {
        if (this.field_6002.field_9236) {
            return this.clientSyncedData;
        }
        return this.spell.release.target.projectile;
    }

    private void updateClientSideData() {
        if (this.clientSyncedData != null) {
            return;
        }
        try {
            Spell.ProjectileData data;
            Gson gson = new Gson();
            String json = (String)this.method_5841().method_12789(CLIENT_DATA);
            this.clientSyncedData = data = (Spell.ProjectileData)gson.fromJson(json, Spell.ProjectileData.class);
        }
        catch (Exception e) {
            System.err.println("Spell Projectile - Failed to read clientSyncedData");
        }
    }

    private void setFollowedTarget(class_1297 target) {
        this.followedTarget = target;
        int id = 0;
        if (!this.field_6002.field_9236) {
            if (target != null) {
                id = target.method_5628();
            }
            this.method_5841().method_12778(TARGET_ID, (Object)id);
        }
    }

    public class_1297 getFollowedTarget() {
        class_1297 entityReference = null;
        if (this.field_6002.field_9236) {
            Integer id = (Integer)this.method_5841().method_12789(TARGET_ID);
            if (id != null && id != 0) {
                entityReference = this.field_6002.method_8469(id.intValue());
            }
        } else {
            entityReference = this.followedTarget;
        }
        if (entityReference != null && entityReference.method_5732() && entityReference.method_5805()) {
            return entityReference;
        }
        return entityReference;
    }

    public boolean method_5640(double distance) {
        double d0 = this.method_5829().method_995() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        boolean result = distance < (d0 *= 128.0) * d0;
        return result;
    }

    public Behaviour behaviour() {
        String string = (String)this.method_5841().method_12789(BEHAVIOUR);
        if (string == null || string.isEmpty()) {
            return Behaviour.FLY;
        }
        return Behaviour.valueOf(string);
    }

    public void method_5773() {
        class_1297 entity = this.method_24921();
        Behaviour behaviour = this.behaviour();
        if (this.field_6002.field_9236) {
            this.updateClientSideData();
        }
        if (!this.field_6002.field_9236) {
            switch (behaviour) {
                case FLY: {
                    if (!(this.field_5994 >= this.range) && this.field_6012 <= 1200) break;
                    this.method_5768();
                    return;
                }
                case FALL: {
                    if ((double)this.field_5994 >= (double)this.range * 0.98) {
                        this.finishFalling();
                        this.method_5768();
                        return;
                    }
                    if (this.field_6012 <= 1200) break;
                    this.method_5768();
                    return;
                }
            }
            if (this.field_5994 >= this.range || this.field_6012 > 1200) {
                this.method_5768();
                return;
            }
        }
        this.previousVelocity = new class_243(this.method_18798().field_1352, this.method_18798().field_1351, this.method_18798().field_1350);
        if (this.field_6002.field_9236 || (entity == null || !entity.method_31481()) && this.field_6002.method_22340(this.method_24515())) {
            class_239 hitResult;
            super.method_5773();
            if (!this.field_6002.field_9236 && (hitResult = class_1675.method_18074((class_1297)this, x$0 -> this.method_26958((class_1297)x$0))).method_17783() != class_239.class_240.field_1333) {
                switch (behaviour) {
                    case FLY: {
                        boolean shouldCollideWithEntity = true;
                        if (hitResult.method_17783() == class_239.class_240.field_1331) {
                            class_1297 class_12972;
                            class_1297 target = ((class_3966)hitResult).method_17782();
                            if (SpellEngineMod.config.projectiles_pass_thru_irrelevant_targets && this.spell != null && this.spell.impact.length > 0 && (class_12972 = this.method_24921()) instanceof class_1309) {
                                class_1309 owner = (class_1309)class_12972;
                                EnumSet<TargetHelper.Intent> intents = SpellHelper.intents(this.spell);
                                boolean intentAllows = false;
                                for (TargetHelper.Intent intent : intents) {
                                    intentAllows = intentAllows || TargetHelper.actionAllowed(TargetHelper.TargetingMode.DIRECT, intent, owner, target);
                                }
                                shouldCollideWithEntity = intentAllows;
                            }
                        }
                        if (shouldCollideWithEntity) {
                            this.method_7488(hitResult);
                            break;
                        }
                        this.setFollowedTarget(null);
                        break;
                    }
                }
            }
            this.followTarget();
            this.method_5852();
            class_243 velocity = this.method_18798();
            double d = this.method_23317() + velocity.field_1352;
            double e = this.method_23318() + velocity.field_1351;
            double f = this.method_23321() + velocity.field_1350;
            class_1675.method_7484((class_1297)this, (float)0.2f);
            float g = this.getDrag();
            if (this.method_5799()) {
                for (int i = 0; i < 4; ++i) {
                    float h = 0.25f;
                    this.field_6002.method_8406((class_2394)class_2398.field_11247, d - velocity.field_1352 * 0.25, e - velocity.field_1351 * 0.25, f - velocity.field_1350 * 0.25, velocity.field_1352, velocity.field_1351, velocity.field_1350);
                }
                g = 0.8f;
            }
            if (this.field_6002.field_9236 && this.projectileData() != null) {
                for (ParticleBatch travel_particles : this.projectileData().client_data.travel_particles) {
                    ParticleHelper.play(this.field_6002, (class_1297)this, this.method_36454(), this.method_36455(), travel_particles);
                }
            }
            this.method_5814(d, e, f);
            this.field_5994 = (float)((double)this.field_5994 + velocity.method_1033());
        } else {
            this.method_31472();
        }
    }

    private void finishFalling() {
        class_1297 owner = this.method_24921();
        if (owner == null || owner.method_31481()) {
            return;
        }
        if (owner instanceof class_1309) {
            class_1309 livingEntity = (class_1309)owner;
            SpellHelper.fallImpact(livingEntity, (class_1297)this, this.spell, this.method_19538(), this.context);
        }
    }

    private void followTarget() {
        class_1297 target = this.getFollowedTarget();
        if (target != null && this.projectileData().homing_angle > 0.0f) {
            class_243 distanceVector = target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0).method_1020(this.method_19538().method_1031(0.0, (double)(this.method_17682() / 2.0f), 0.0));
            class_243 newVelocity = VectorHelper.rotateTowards(this.method_18798(), distanceVector, this.projectileData().homing_angle);
            if (newVelocity.method_1027() > 0.0) {
                this.method_18799(newVelocity);
                this.field_6007 = true;
            }
        }
    }

    protected float getDrag() {
        return 0.95f;
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 class_12972;
        class_1297 target;
        if (!this.field_6002.field_9236 && (target = entityHitResult.method_17782()) != null && this.method_24921() != null && (class_12972 = this.method_24921()) instanceof class_1309) {
            boolean performed;
            class_1309 caster = (class_1309)class_12972;
            this.setFollowedTarget(null);
            SpellHelper.ImpactContext context = this.context;
            if (context == null) {
                context = new SpellHelper.ImpactContext();
            }
            if (performed = SpellHelper.performImpacts(this.field_6002, caster, target, this.spell, context.position(new class_243(this.field_6014, this.field_6036, this.field_5969)))) {
                this.method_5768();
            }
        }
    }

    public Spell getSpell() {
        return this.spell;
    }

    public SpellHelper.ImpactContext getImpactContext() {
        return this.context;
    }

    @Override
    public Spell.ProjectileData.Client renderData() {
        Spell.ProjectileData data = this.projectileData();
        if (data != null) {
            return this.projectileData().client_data;
        }
        return null;
    }

    public class_1799 method_7495() {
        if (this.projectileData() != null && this.projectileData().client_data != null) {
            return ((class_1792)class_2378.field_11142.method_10223(new class_2960(this.projectileData().client_data.model_id))).method_7854();
        }
        return class_1799.field_8037;
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        this.method_5768();
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        Gson gson = new Gson();
        nbt.method_10582(NBT_SPELL_DATA, gson.toJson((Object)this.spell));
        nbt.method_10582(NBT_IMPACT_CONTEXT, gson.toJson((Object)this.context));
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573(NBT_SPELL_DATA, 8)) {
            try {
                Gson gson = new Gson();
                this.spell = (Spell)gson.fromJson(nbt.method_10558(NBT_SPELL_DATA), Spell.class);
                Gson recordReader = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new RecordsWithGson.RecordTypeAdapterFactory()).create();
                this.context = (SpellHelper.ImpactContext)recordReader.fromJson(nbt.method_10558(NBT_IMPACT_CONTEXT), SpellHelper.ImpactContext.class);
            }
            catch (Exception e) {
                System.err.println("SpellProjectile - Failed to read spell data from NBT");
            }
        }
    }

    protected void method_5693() {
        Gson gson = new Gson();
        this.method_5841().method_12784(CLIENT_DATA, (Object)"");
        this.method_5841().method_12784(TARGET_ID, (Object)0);
        this.method_5841().method_12784(BEHAVIOUR, (Object)Behaviour.FLY.toString());
    }

    static {
        CLIENT_DATA = class_2945.method_12791(SpellProjectile.class, (class_2941)class_2943.field_13326);
        TARGET_ID = class_2945.method_12791(SpellProjectile.class, (class_2941)class_2943.field_13327);
        BEHAVIOUR = class_2945.method_12791(SpellProjectile.class, (class_2941)class_2943.field_13326);
    }

    public static enum Behaviour {
        FLY,
        FALL;

    }
}

