/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.fabric.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.minecraft.class_1723;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.gui.HudRenderHelper;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.input.Keybindings;
import net.spell_engine.client.particle.GenericSpellParticle;
import net.spell_engine.client.particle.SpellFlameParticle;
import net.spell_engine.client.particle.SpellHitParticle;
import net.spell_engine.client.particle.SpellSnowflakeParticle;
import net.spell_engine.client.render.CustomModelRegistry;
import net.spell_engine.client.render.SpellProjectileRenderer;
import net.spell_engine.particle.Particles;

public class FabricClientMod
implements ClientModInitializer {
    public void onInitializeClient() {
        SpellEngineClient.initialize();
        this.registerKeyBindings();
        HudRenderCallback.EVENT.register((matrixStack, tickDelta) -> HudRenderHelper.render(matrixStack, tickDelta));
        ItemTooltipCallback.EVENT.register((itemStack, context, lines) -> SpellTooltip.addSpellInfo(itemStack, lines));
        EntityRendererRegistry.register(SpellEngineMod.SPELL_PROJECTILE, context -> new SpellProjectileRenderer(context));
        this.registerParticleAppearances();
    }

    private void registerParticleAppearances() {
        ClientSpriteRegistryCallback.event((class_2960)class_1723.field_21668).register((atlasTexture, registry) -> {
            for (Particles.ParticleEntry entry : Particles.all()) {
                if (!entry.usesCustomTexture) continue;
                registry.register(entry.id);
            }
        });
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.arcane_hit.particleType, SpellHitParticle.ArcaneFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.arcane_spell.particleType, GenericSpellParticle.ArcaneSpellFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.healing_ascend.particleType, SpellFlameParticle.HealingFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.holy_hit.particleType, SpellHitParticle.HolyFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.holy_ascend.particleType, SpellFlameParticle.HolyFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.holy_spark_mini.particleType, SpellFlameParticle.HolyFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.holy_spark.particleType, SpellSnowflakeParticle.HolyFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.holy_spell.particleType, GenericSpellParticle.HolySpellFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.flame.particleType, SpellFlameParticle.FlameFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.snowflake.particleType, SpellSnowflakeParticle.FrostFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.frost_hit.particleType, SpellHitParticle.FrostFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Particles.frost_shard.particleType, SpellFlameParticle.FrostShard::new);
        ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> {
            for (class_2960 entry : CustomModelRegistry.modelIds) {
                out.accept(entry);
            }
        });
    }

    private void registerKeyBindings() {
        for (class_304 keybinding : Keybindings.all) {
            KeyBindingHelper.registerKeyBinding((class_304)keybinding);
        }
    }
}

