/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import net.minecraft.class_1792;
import org.jetbrains.annotations.Nullable;

public class SpellCast {

    public static enum Animation {
        CASTING,
        RELEASE;

    }

    public static enum Action {
        START,
        CHANNEL,
        RELEASE;

    }

    public record Attempt(Result result, @Nullable MissingItemInfo missingItem, @Nullable OnCooldownInfo onCooldown) {
        public static Attempt none() {
            return new Attempt(Result.NONE, null, null);
        }

        public static Attempt success() {
            return new Attempt(Result.SUCCESS, null, null);
        }

        public static Attempt failMissingItem(MissingItemInfo missingItem) {
            return new Attempt(Result.MISSING_ITEM, missingItem, null);
        }

        public static Attempt failOnCooldown(OnCooldownInfo onCooldown) {
            return new Attempt(Result.ON_COOLDOWN, null, onCooldown);
        }

        public boolean isSuccess() {
            return this.result == Result.SUCCESS;
        }

        public boolean isFail() {
            return this.result != Result.SUCCESS && this.result != Result.NONE;
        }

        public static enum Result {
            SUCCESS,
            MISSING_ITEM,
            ON_COOLDOWN,
            NONE;

        }

        public record MissingItemInfo(class_1792 item) {
        }

        public record OnCooldownInfo() {
        }
    }
}

