/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.api.item.trinket.SpellBookItem;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.internals.SpellCast;
import net.spell_engine.internals.SpellCasterClient;
import net.spell_engine.internals.SpellCasterEntity;
import net.spell_engine.internals.SpellCasterItemStack;
import net.spell_engine.internals.SpellContainerHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1799.class})
public abstract class ItemStackMixin
implements SpellCasterItemStack {
    @Shadow
    public abstract class_1792 method_7909();

    private class_1799 itemStack() {
        return (class_1799)this;
    }

    @Nullable
    private SpellContainer spellContainer() {
        SpellContainer nbtContainer = this.spellContainerFromNBT();
        if (nbtContainer != null) {
            return nbtContainer;
        }
        return this.spellContainerDefault();
    }

    @Nullable
    private SpellContainer spellContainerFromNBT() {
        class_1799 itemStack = this.itemStack();
        if (!itemStack.method_7985()) {
            return null;
        }
        return SpellContainerHelper.fromNBT(itemStack.method_7969());
    }

    @Nullable
    private SpellContainer spellContainerDefault() {
        class_1792 item = this.method_7909();
        class_2960 id = class_2378.field_11142.method_10221((Object)item);
        return SpellRegistry.containerForItem(id);
    }

    @Override
    @Nullable
    public SpellContainer getSpellContainer() {
        return this.spellContainer();
    }

    @Inject(method={"isUsedOnRelease"}, at={@At(value="HEAD")}, cancellable=true)
    private void isUsedOnRelease_HEAD_SpellEngine(CallbackInfoReturnable<Boolean> cir) {
        SpellContainer container = this.spellContainer();
        if (container == null || !container.isValid()) {
            return;
        }
        cir.setReturnValue((Object)false);
        cir.cancel();
    }

    @Inject(method={"getMaxUseTime"}, at={@At(value="HEAD")}, cancellable=true)
    private void getMaxUseTime_HEAD_SpellEngine(CallbackInfoReturnable<Integer> cir) {
        SpellContainer container = this.spellContainer();
        if (container == null || !container.isValid()) {
            return;
        }
        cir.setReturnValue((Object)SpellHelper.maximumUseTicks);
        cir.cancel();
    }

    @Inject(method={"getUseAction"}, at={@At(value="HEAD")}, cancellable=true)
    private void getUseAction_HEAD_SpellEngine(CallbackInfoReturnable<class_1839> cir) {
        SpellContainer container = this.spellContainer();
        if (container == null || !container.isValid()) {
            return;
        }
        cir.setReturnValue((Object)class_1839.field_8952);
        cir.cancel();
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void use_HEAD_SpellEngine(class_1937 world, class_1657 user, class_1268 hand, CallbackInfoReturnable<class_1271<class_1799>> cir) {
        if (hand == class_1268.field_5810 && !SpellEngineMod.config.offhand_casting_allowed) {
            return;
        }
        class_1799 itemStack = this.itemStack();
        SpellContainer container = SpellContainerHelper.containerWithProxy(this.spellContainer(), user);
        if (container == null || !container.isUsable() || itemStack.method_7909() instanceof SpellBookItem) {
            SpellCasterEntity caster;
            if (user instanceof SpellCasterEntity && (caster = (SpellCasterEntity)user).getCurrentSpellId() != null) {
                caster.clearCasting();
            }
            return;
        }
        if (EntityActionsAllowed.isImpaired((class_1309)user, EntityActionsAllowed.Player.CAST_SPELL, true)) {
            cir.setReturnValue((Object)class_1271.method_22431((Object)this.itemStack()));
            cir.cancel();
            return;
        }
        SpellCast.Attempt attempt = SpellCast.Attempt.none();
        if (world.field_9236) {
            if (user instanceof SpellCasterClient) {
                SpellCasterClient caster = (SpellCasterClient)user;
                if (hand == class_1268.field_5808 && !user.method_6079().method_7960() && caster.isHotbarModifierPressed()) {
                    return;
                }
                class_2960 spellId = caster.getSelectedSpellId(container);
                attempt = SpellHelper.attemptCasting(user, itemStack, spellId);
                caster.castAttempt(attempt);
                if (attempt.isSuccess()) {
                    caster.castStart(container, hand, itemStack, SpellHelper.maximumUseTicks);
                }
            }
        } else {
            class_2960 spellId = ((SpellCasterEntity)user).getCurrentSpellId();
            if (spellId != null) {
                attempt = SpellHelper.attemptCasting(user, itemStack, spellId);
            }
        }
        if (attempt.isSuccess()) {
            cir.setReturnValue((Object)class_1271.method_22428((Object)this.itemStack()));
            user.method_6019(hand);
        } else if (attempt.isFail()) {
            cir.setReturnValue((Object)class_1271.method_22431((Object)this.itemStack()));
        } else {
            cir.setReturnValue((Object)class_1271.method_22430((Object)this.itemStack()));
        }
        cir.cancel();
    }

    @Inject(method={"usageTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void usageTick_HEAD_SpellEngine(class_1937 world, class_1309 user, int remainingUseTicks, CallbackInfo ci) {
        SpellContainer container = this.spellContainer();
        if (container == null || !container.isValid()) {
            return;
        }
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            SpellCasterEntity caster = (SpellCasterEntity)player;
            boolean checkAmmo = world.field_9236;
            SpellCast.Attempt attempt = SpellHelper.attemptCasting(player, this.itemStack(), caster.getCurrentSpellId(), checkAmmo);
            if (attempt.isSuccess()) {
                if (world.field_9236 && user instanceof SpellCasterClient) {
                    SpellCasterClient casterClient = (SpellCasterClient)user;
                    casterClient.castTick(this.itemStack(), user.method_6058(), remainingUseTicks);
                }
            } else {
                player.method_6075();
            }
        }
        ci.cancel();
    }

    @Inject(method={"onStoppedUsing"}, at={@At(value="HEAD")}, cancellable=true)
    private void onStoppedUsing_HEAD_SpellEngine(class_1937 world, class_1309 user, int remainingUseTicks, CallbackInfo ci) {
        SpellContainer container = this.spellContainer();
        if (container == null || !container.isValid()) {
            return;
        }
        if (world.field_9236 && user instanceof SpellCasterClient) {
            SpellCasterClient caster = (SpellCasterClient)user;
            caster.castRelease(this.itemStack(), user.method_6058(), remainingUseTicks);
        }
        ci.cancel();
    }
}

