/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin;

import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.animation.AnimatablePlayer;
import net.spell_engine.internals.SpellCastSyncHelper;
import net.spell_engine.internals.SpellCasterEntity;
import net.spell_engine.internals.SpellContainerHelper;
import net.spell_engine.internals.SpellCooldownManager;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin
implements SpellCasterEntity {
    private final SpellCooldownManager spellCooldownManager = new SpellCooldownManager(this.player());
    private static final class_2940<Integer> SPELL_ENGINE_SELECTED_SPELL = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13327);

    private class_1657 player() {
        return (class_1657)this;
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    private void initDataTracker_TAIL_SpellEngine_SyncEffects(CallbackInfo ci) {
        this.player().method_5841().method_12784(SPELL_ENGINE_SELECTED_SPELL, (Object)0);
    }

    @Override
    public void setCurrentSpellId(class_2960 spellId) {
        this.player().method_5841().method_12778(SPELL_ENGINE_SELECTED_SPELL, (Object)(spellId != null ? SpellRegistry.rawSpellId(spellId) : 0));
    }

    @Override
    public class_2960 getCurrentSpellId() {
        Integer value;
        class_1657 player = this.player();
        if (player.method_6115() && (value = (Integer)player.method_5841().method_12789(SPELL_ENGINE_SELECTED_SPELL)) != 0) {
            return SpellRegistry.fromRawSpellId(value).orElse(null);
        }
        return null;
    }

    @Override
    public Spell getCurrentSpell() {
        class_2960 id = this.getCurrentSpellId();
        if (id != null) {
            return SpellRegistry.getSpell(id);
        }
        return null;
    }

    @Override
    public float getCurrentCastProgress() {
        Spell spell = this.getCurrentSpell();
        if (spell != null) {
            return SpellHelper.getCastProgress((class_1309)this.player(), this.player().method_6014(), spell);
        }
        return 0.0f;
    }

    @Override
    public void clearCasting() {
        class_1657 player = this.player();
        if (!player.field_6002.field_9236) {
            SpellCastSyncHelper.clearCasting(player);
        }
    }

    @Override
    public SpellCooldownManager getCooldownManager() {
        return this.spellCooldownManager;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick_TAIL_SpellEngine(CallbackInfo ci) {
        class_1657 player = this.player();
        if (player.field_6002.field_9236) {
            ((AnimatablePlayer)this.player()).updateSpellCastAnimationsOnTick();
        } else if (!player.method_6115() || SpellContainerHelper.containerWithProxy(player.method_6030(), player) == null) {
            SpellCastSyncHelper.clearCasting(player);
        }
        this.spellCooldownManager.update();
    }

    @Override
    public boolean isBeaming() {
        return this.getBeam() != null;
    }

    @Override
    @Nullable
    public Spell.Release.Target.Beam getBeam() {
        Spell spell = this.getCurrentSpell();
        if (spell != null && spell.release != null && spell.release.target.type == Spell.Release.Target.Type.BEAM) {
            return spell.release.target.beam;
        }
        return null;
    }
}

