/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.client;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2828;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_372;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.gui.HudMessages;
import net.spell_engine.client.input.InputHelper;
import net.spell_engine.client.input.Keybindings;
import net.spell_engine.config.Tutorial;
import net.spell_engine.internals.SpellCast;
import net.spell_engine.internals.SpellCasterClient;
import net.spell_engine.internals.SpellContainerHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.network.Packets;
import net.spell_engine.utils.TargetHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_746.class})
public abstract class ClientPlayerEntityMixin
implements SpellCasterClient {
    @Shadow
    @Final
    public class_634 field_3944;
    @Shadow
    @Final
    protected class_310 field_3937;
    private int selectedSpellIndex = 0;
    private List<class_1297> targets = List.of();
    private class_2960 currentSpell;
    private int tutorialToastTicks = 0;
    private class_372 tutorialToast;

    private class_746 player() {
        return (class_746)this;
    }

    private class_1297 firstTarget() {
        return this.targets.stream().findFirst().orElse(null);
    }

    @Override
    public void setCurrentSpellId(class_2960 spellId) {
        this.currentSpell = spellId;
    }

    @Override
    public class_2960 getCurrentSpellId() {
        if (this.player().method_6115()) {
            return this.currentSpell;
        }
        return null;
    }

    @Override
    public boolean isHotbarModifierPressed() {
        return Keybindings.hotbarModifier.method_1434();
    }

    @Override
    public void changeSelectedSpellIndex(int delta) {
        this.selectedSpellIndex += delta;
    }

    @Override
    public void setSelectedSpellIndex(int index) {
        this.selectedSpellIndex = index;
    }

    @Override
    public int getSelectedSpellIndex(SpellContainer container) {
        return container.cappedIndex(this.selectedSpellIndex);
    }

    @Override
    public SpellContainer.Hosted getCurrentContainerWithHost() {
        class_746 player = this.player();
        class_1799 casterStack = player.method_6047();
        SpellContainer container = this.containerFromItemStack(casterStack);
        if (container == null && SpellEngineMod.config.offhand_casting_allowed) {
            casterStack = this.player().method_6079();
            container = this.containerFromItemStack(casterStack);
        }
        SpellContainer combinedContainer = SpellContainerHelper.containerWithProxy(container, (class_1657)player);
        return new SpellContainer.Hosted(casterStack, combinedContainer);
    }

    @Override
    public SpellContainer getCurrentContainer() {
        class_746 player = this.player();
        class_1799 casterStack = player.method_6047();
        SpellContainer container = this.containerFromItemStack(casterStack);
        if (container == null && SpellEngineMod.config.offhand_casting_allowed) {
            container = this.containerFromItemStack(this.player().method_6079());
        }
        return SpellContainerHelper.containerWithProxy(container, (class_1657)player);
    }

    private SpellContainer containerFromItemStack(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return null;
        }
        return SpellContainerHelper.containerFromItemStack(itemStack);
    }

    @Nullable
    private class_2960 spellIdFromItemStack(class_1799 itemStack) {
        class_746 player = this.player();
        SpellContainer container = SpellContainerHelper.containerWithProxy(itemStack, (class_1657)player);
        return SpellContainerHelper.spellId(container, this.selectedSpellIndex);
    }

    @Override
    public List<class_1297> getCurrentTargets() {
        if (this.targets == null) {
            return List.of();
        }
        return this.targets;
    }

    @Override
    public class_1297 getCurrentFirstTarget() {
        return this.firstTarget();
    }

    @Override
    @Nullable
    public class_2960 getSelectedSpellId(SpellContainer container) {
        return SpellContainerHelper.spellId(container, this.selectedSpellIndex);
    }

    @Override
    public void castAttempt(SpellCast.Attempt result) {
        HudMessages.INSTANCE.castAttemptError(result);
    }

    @Override
    public void castStart(SpellContainer container, class_1268 hand, class_1799 itemStack, int remainingUseTicks) {
        class_2960 spellId = SpellContainerHelper.spellId(container, this.selectedSpellIndex);
        this.selectSpell(spellId, hand, itemStack, remainingUseTicks);
    }

    private void selectSpell(class_2960 spellId, class_1268 hand, class_1799 itemStack, int remainingUseTicks) {
        class_746 caster = this.player();
        int slot = this.findSlot((class_1657)caster, itemStack);
        ClientPlayNetworking.send((class_2960)Packets.SpellRequest.ID, (class_2540)new Packets.SpellRequest(hand, SpellCast.Action.START, spellId, slot, remainingUseTicks, new int[0]).write());
        this.setCurrentSpellId(spellId);
    }

    @Override
    public void castTick(class_1799 itemStack, class_1268 hand, int remainingUseTicks) {
        class_746 caster = this.player();
        class_2960 currentSpellId = this.getCurrentSpellId();
        Spell currentSpell = this.getCurrentSpell();
        if (currentSpell == null || SpellEngineClient.config.restartCastingWhenSwitchingSpell && !currentSpellId.equals((Object)this.spellIdFromItemStack(itemStack))) {
            this.stopItemUsage();
            return;
        }
        this.updateTargets();
        float progress = SpellHelper.getCastProgress((class_1309)caster, remainingUseTicks, currentSpell);
        if (SpellHelper.isChanneled(currentSpell)) {
            this.cast(currentSpell, SpellCast.Action.CHANNEL, hand, itemStack, remainingUseTicks);
            if (progress >= 1.0f) {
                this.stopItemUsage();
            }
        } else if (SpellEngineClient.config.autoRelease && SpellHelper.getCastProgress((class_1309)caster, remainingUseTicks, currentSpell) >= 1.0f) {
            this.stopItemUsage();
        }
    }

    @Override
    public void castRelease(class_1799 itemStack, class_1268 hand, int remainingUseTicks) {
        this.updateTargets();
        this.cast(this.getCurrentSpell(), SpellCast.Action.RELEASE, hand, itemStack, remainingUseTicks);
    }

    private void cast(Spell spell, SpellCast.Action action, class_1268 hand, class_1799 itemStack, int remainingUseTicks) {
        if (spell == null) {
            return;
        }
        class_746 caster = this.player();
        float progress = SpellHelper.getCastProgress((class_1309)caster, remainingUseTicks, spell);
        boolean isChannelled = SpellHelper.isChanneled(spell);
        boolean shouldEndCasting = false;
        switch (action) {
            case CHANNEL: {
                if (isChannelled && SpellHelper.isChannelTickDue(spell, remainingUseTicks)) break;
                return;
            }
            case RELEASE: {
                shouldEndCasting = true;
            }
        }
        int slot = this.findSlot((class_1657)caster, itemStack);
        Spell.Release.Target release = spell.release.target;
        int[] targetIDs = new int[]{};
        switch (release.type) {
            case PROJECTILE: 
            case CURSOR: 
            case METEOR: {
                class_1297 firstTarget = this.firstTarget();
                if (firstTarget == null) break;
                targetIDs = new int[]{firstTarget.method_5628()};
                break;
            }
            case AREA: 
            case BEAM: {
                targetIDs = new int[this.targets.size()];
                int i = 0;
                for (class_1297 target : this.targets) {
                    targetIDs[i] = target.method_5628();
                    ++i;
                }
                break;
            }
        }
        class_2960 spellId = this.getCurrentSpellId();
        ClientPlayNetworking.send((class_2960)Packets.SpellRequest.ID, (class_2540)new Packets.SpellRequest(hand, action, spellId, slot, remainingUseTicks, targetIDs).write());
        if (shouldEndCasting) {
            this.clearCasting();
        }
    }

    private void stopItemUsage() {
        class_310 client = class_310.method_1551();
        client.field_1761.method_2897((class_1657)client.field_1724);
    }

    private void endCasting() {
        this.clearCasting();
        this.player().method_6021();
    }

    @Override
    public void clearCasting() {
        this.setCurrentSpellId(null);
    }

    private int findSlot(class_1657 player, class_1799 stack) {
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 itemStack = player.method_31548().method_5438(i);
            if (stack != itemStack) continue;
            return i;
        }
        return -1;
    }

    private void updateTargets() {
        this.targets = this.findTargets(this.getCurrentSpell());
    }

    private List<class_1297> findTargets(Spell currentSpell) {
        Spell.Release.Target.Cursor cursor;
        class_746 caster = this.player();
        List<class_1297> previousTargets = this.targets;
        List<Object> targets = List.of();
        if (currentSpell == null) {
            return targets;
        }
        boolean fallbackToPreviousTargets = false;
        TargetHelper.TargetingMode targetingMode = SpellHelper.selectionTargetingMode(currentSpell);
        Spell.Release.Target.Type targetType = currentSpell.release.target.type;
        EnumSet<TargetHelper.Intent> intents = SpellHelper.intents(currentSpell);
        Predicate<class_1297> selectionPredicate = target -> {
            boolean intentAllows = false;
            for (TargetHelper.Intent intent : intents) {
                intentAllows = intentAllows || TargetHelper.actionAllowed(targetingMode, intent, (class_1309)caster, target);
            }
            return !SpellEngineClient.config.filterInvalidTargets || intentAllows;
        };
        switch (targetType) {
            case AREA: {
                targets = TargetHelper.targetsFromArea((class_1297)caster, currentSpell.range, currentSpell.release.target.area, selectionPredicate);
                Spell.Release.Target.Area area = currentSpell.release.target.area;
                if (area == null || !area.include_caster) break;
                targets.add((class_1297)caster);
                break;
            }
            case BEAM: {
                targets = TargetHelper.targetsFromRaycast((class_1297)caster, currentSpell.range, selectionPredicate);
                break;
            }
            case PROJECTILE: 
            case CURSOR: 
            case METEOR: {
                fallbackToPreviousTargets = targetType != Spell.Release.Target.Type.PROJECTILE;
                class_1297 target2 = TargetHelper.targetFromRaycast((class_1297)caster, currentSpell.range, selectionPredicate);
                if (target2 != null) {
                    targets = List.of(target2);
                    break;
                }
                targets = List.of();
                break;
            }
        }
        if (fallbackToPreviousTargets && SpellEngineClient.config.stickyTarget && targets.isEmpty()) {
            targets = previousTargets.stream().filter(entity -> TargetHelper.isInLineOfSight((class_1297)caster, entity)).toList();
        }
        if ((cursor = currentSpell.release.target.cursor) != null && cursor.use_caster_as_fallback && targets.isEmpty()) {
            targets = List.of(caster);
        }
        return targets;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick_TAIL_SpellEngine(CallbackInfo ci) {
        SpellContainer container;
        class_746 player = this.player();
        class_2960 spellIdFromActiveStack = this.spellIdFromItemStack(player.method_6030());
        boolean usingItem = player.method_6115();
        if (!usingItem || spellIdFromActiveStack == null) {
            this.targets = List.of();
        }
        if (spellIdFromActiveStack == null) {
            this.clearCasting();
        }
        if (this.isBeaming()) {
            this.field_3944.method_2883((class_2596)new class_2828.class_2830(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455(), player.method_24828()));
        }
        if (!((Tutorial)SpellEngineClient.tutorial.value).spell_hotbar_shown && InputHelper.canLockOnContainer(container = SpellContainerHelper.containerWithProxy(player.method_6047(), (class_1657)player))) {
            class_304 keybinding = Keybindings.hotbarLock;
            class_5250 description = class_2561.method_43471((String)"tutorial.spell_hotbar.unbound");
            if (!keybinding.method_1415()) {
                class_5250 key = class_2561.method_30163((String)keybinding.method_16007().getString().toUpperCase()).method_27661().method_27692(class_124.field_1067);
                description = class_2561.method_43469((String)"tutorial.spell_hotbar.description", (Object[])new Object[]{key});
            }
            this.tutorialToast = new class_372(class_372.class_373.field_2230, (class_2561)class_2561.method_43471((String)"tutorial.spell_hotbar.title"), (class_2561)description, false);
            this.tutorialToastTicks = 140;
            this.field_3937.method_1566().method_1999((class_368)this.tutorialToast);
            ((Tutorial)SpellEngineClient.tutorial.value).spell_hotbar_shown = true;
            SpellEngineClient.tutorial.save();
        }
        if (this.tutorialToastTicks > 0) {
            --this.tutorialToastTicks;
            if (this.tutorialToastTicks == 0 && this.tutorialToast != null) {
                this.tutorialToast.method_1993();
                this.tutorialToast = null;
            }
        }
    }
}

