/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power;

import java.util.Map;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.spell_power.api.attributes.SpellAttributeEntry;
import net.spell_power.api.attributes.SpellAttributes;
import net.spell_power.api.enchantment.Enchantments_SpellPower;
import net.spell_power.config.AttributesConfig;
import net.spell_power.config.EnchantmentsConfig;
import net.spell_power.config.StatusEffectConfig;
import net.spell_power.internals.SpellStatusEffect;
import net.spell_power.tinyconfig.ConfigManager;

public class SpellPowerMod {
    public static final String ID = "spell_power";
    public static final ConfigManager<EnchantmentsConfig> enchantmentConfig = new ConfigManager<EnchantmentsConfig>("enchantments", new EnchantmentsConfig()).builder().setDirectory("spell_power").sanitize(true).schemaVersion(3).build();
    public static final ConfigManager<AttributesConfig> attributesConfig = new ConfigManager<AttributesConfig>("attributes", new AttributesConfig()).builder().setDirectory("spell_power").sanitize(true).build();
    public static final ConfigManager<StatusEffectConfig> effectsConfig = new ConfigManager<StatusEffectConfig>("status_effects", new StatusEffectConfig()).builder().setDirectory("spell_power").sanitize(true).validate(StatusEffectConfig::isValid).build();
    private static boolean registeredAttributes = false;

    public static void init() {
        SpellPowerMod.loadConfig();
        SpellPowerMod.configureStatusEffects();
    }

    public static void loadConfig() {
        enchantmentConfig.refresh();
        attributesConfig.refresh();
        effectsConfig.refresh();
    }

    public static void registerAttributes() {
        if (registeredAttributes) {
            return;
        }
        attributesConfig.refresh();
        for (Map.Entry<String, SpellAttributeEntry> entry : SpellAttributes.all.entrySet()) {
            class_2378.method_10230((class_2378)class_2378.field_23781, (class_2960)entry.getValue().id, (Object)((Object)entry.getValue().attribute));
        }
        registeredAttributes = true;
    }

    public static void registerEnchantments() {
        for (Map.Entry<class_2960, class_1887> entry : Enchantments_SpellPower.all.entrySet()) {
            class_2378.method_10230((class_2378)class_2378.field_11160, (class_2960)entry.getKey(), (Object)entry.getValue());
        }
    }

    public static void configureEnchantments() {
        ((EnchantmentsConfig)SpellPowerMod.enchantmentConfig.value).apply();
    }

    public static void registerStatusEffects() {
        for (Map.Entry<String, SpellAttributeEntry> entry : SpellAttributes.all.entrySet()) {
            int rawId = entry.getValue().statusEffect.preferredRawId;
            class_2960 id = entry.getValue().id;
            SpellStatusEffect effect = entry.getValue().statusEffect;
            if (rawId > 0) {
                class_2378.method_10231((class_2378)class_2378.field_11159, (int)rawId, (String)id.toString(), (Object)((Object)effect));
                continue;
            }
            class_2378.method_10230((class_2378)class_2378.field_11159, (class_2960)id, (Object)((Object)effect));
        }
    }

    public static void configureStatusEffects() {
        for (Map.Entry<String, SpellAttributeEntry> entry : SpellAttributes.all.entrySet()) {
            SpellStatusEffect.Config config = ((StatusEffectConfig)SpellPowerMod.effectsConfig.value).effects.get(entry.getKey());
            SpellAttributeEntry attribute = entry.getValue();
            attribute.setupStatusEffect(config);
        }
    }
}

