/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.spell_power.SpellPowerMod;
import net.spell_power.api.MagicSchool;
import net.spell_power.api.attributes.EntityAttributes_SpellPower;
import net.spell_power.api.enchantment.Enchantments_SpellPower;
import net.spell_power.api.enchantment.SpellPowerEnchanting;
import net.spell_power.api.statuseffects.VulnerabilityEffect;
import net.spell_power.config.AttributesConfig;
import net.spell_power.config.EnchantmentsConfig;
import net.spell_power.internals.AmplifierEnchantment;

public class SpellPower {
    public static final ArrayList<Function<VulnerabilityQuery, List<Vulnerability>>> vulnerabilitySources = new ArrayList<Function>(Arrays.asList(query -> {
        ArrayList<Vulnerability> vulnerabilities = new ArrayList<Vulnerability>();
        for (class_1293 effect : query.entity.method_6026()) {
            class_1291 patt2716$temp = effect.method_5579();
            if (!(patt2716$temp instanceof VulnerabilityEffect)) continue;
            VulnerabilityEffect vulnerabilityEffect = (VulnerabilityEffect)patt2716$temp;
            vulnerabilities.add(vulnerabilityEffect.getVulnerability(query.school, effect.method_5578()));
        }
        return vulnerabilities;
    }));

    public static Vulnerability getVulnerability(class_1309 livingEntity, MagicSchool school) {
        VulnerabilityQuery query = new VulnerabilityQuery(livingEntity, school);
        ArrayList<Vulnerability> elements = new ArrayList<Vulnerability>();
        for (Function<VulnerabilityQuery, List<Vulnerability>> source : vulnerabilitySources) {
            elements.addAll((Collection<Vulnerability>)source.apply(query));
        }
        return Vulnerability.sum(elements);
    }

    public static Result getSpellPower(MagicSchool school, class_1309 entity) {
        return SpellPower.getSpellPower(school, entity, null);
    }

    public static Result getSpellPower(MagicSchool school, class_1309 entity, class_1799 provisionedWeapon) {
        class_1320 attribute = school.isExternalAttribute() ? (class_1320)class_2378.field_23781.method_10223(school.attributeId()) : (class_1320)EntityAttributes_SpellPower.POWER.get((Object)school);
        double value = entity.method_26825(attribute);
        for (SpellPowerEnchanting.AttributeBoost booster : SpellPowerEnchanting.boostersFor(school)) {
            int level = SpellPower.getEnchantmentLevel(booster.enchantment(), entity, provisionedWeapon);
            value = booster.amplifier().apply(value, level);
        }
        return new Result(school, value, SpellPower.getCriticalChance(entity, provisionedWeapon), SpellPower.getCriticalMultiplier(entity, provisionedWeapon));
    }

    public static double getCriticalChance(class_1309 entity) {
        return SpellPower.getCriticalChance(entity, null);
    }

    public static double getCriticalChance(class_1309 entity, class_1799 provisionedWeapon) {
        double base = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_chance_percentage;
        double value = entity.method_26825((class_1320)EntityAttributes_SpellPower.CRITICAL_CHANCE);
        AmplifierEnchantment enchantment = Enchantments_SpellPower.CRITICAL_CHANCE;
        int level = SpellPower.getEnchantmentLevel(enchantment, entity, provisionedWeapon);
        value += enchantment.amplify(0.0, level) * 100.0;
        return ((value += base) - 100.0) / 100.0;
    }

    public static double getCriticalMultiplier(class_1309 entity) {
        return SpellPower.getCriticalMultiplier(entity, null);
    }

    public static double getCriticalMultiplier(class_1309 entity, class_1799 provisionedWeapon) {
        double value = entity.method_26825((class_1320)EntityAttributes_SpellPower.CRITICAL_DAMAGE);
        AmplifierEnchantment enchantment = Enchantments_SpellPower.CRITICAL_DAMAGE;
        int level = SpellPower.getEnchantmentLevel(enchantment, entity, provisionedWeapon);
        value += enchantment.amplify(0.0, level) * 100.0;
        return (value += ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_damage_percentage) / 100.0;
    }

    public static double getHaste(class_1309 entity) {
        return SpellPower.getHaste(entity, null);
    }

    public static double getHaste(class_1309 entity, class_1799 provisionedWeapon) {
        double value = entity.method_26825((class_1320)EntityAttributes_SpellPower.HASTE);
        AmplifierEnchantment enchantment = Enchantments_SpellPower.HASTE;
        int level = SpellPower.getEnchantmentLevel(enchantment, entity, provisionedWeapon);
        return (value += enchantment.amplify(0.0, level) * 100.0) / 100.0;
    }

    private static int getEnchantmentLevel(class_1887 enchantment, class_1309 entity, class_1799 provisionedWeapon) {
        int level = ((EnchantmentsConfig)SpellPowerMod.enchantmentConfig.value).allow_stacking ? SpellPower.getEnchantmentLevelEquipmentSum(enchantment, entity) : class_1890.method_8203((class_1887)enchantment, (class_1309)entity);
        if (provisionedWeapon != null && !provisionedWeapon.method_7960()) {
            class_1799 mainHandStack = entity.method_6047();
            if (mainHandStack != null && !mainHandStack.method_7960()) {
                level -= class_1890.method_8225((class_1887)enchantment, (class_1799)mainHandStack);
            }
            level += class_1890.method_8225((class_1887)enchantment, (class_1799)provisionedWeapon);
        }
        return level;
    }

    private static int getEnchantmentLevelEquipmentSum(class_1887 enchantment, class_1309 entity) {
        class_1799 offHandStack;
        int level = 0;
        for (class_1799 itemStack : entity.method_5661()) {
            level += class_1890.method_8225((class_1887)enchantment, (class_1799)itemStack);
        }
        class_1799 mainHandStack = entity.method_6047();
        if (mainHandStack != null) {
            level += class_1890.method_8225((class_1887)enchantment, (class_1799)mainHandStack);
        }
        if ((offHandStack = entity.method_6079()) != null) {
            level += class_1890.method_8225((class_1887)enchantment, (class_1799)offHandStack);
        }
        return level;
    }

    public record VulnerabilityQuery(class_1309 entity, MagicSchool school) {
    }

    public record Vulnerability(float powerBaseMultiplier, float criticalChanceBonus, float criticalDamageBonus) {
        public static final Vulnerability none = new Vulnerability(0.0f, 0.0f, 0.0f);

        public static Vulnerability sum(List<Vulnerability> elements) {
            Vulnerability value = none;
            for (Vulnerability element : elements) {
                value = new Vulnerability(value.powerBaseMultiplier + element.powerBaseMultiplier, value.criticalChanceBonus + element.criticalChanceBonus, value.criticalDamageBonus + element.criticalDamageBonus);
            }
            return value;
        }

        public Vulnerability multiply(float value) {
            return new Vulnerability(this.powerBaseMultiplier * value, this.criticalChanceBonus * value, this.criticalDamageBonus * value);
        }
    }

    public record Result(MagicSchool school, double baseValue, double criticalChance, double criticalDamage) {
        private static Random rng = new Random();

        public double randomValue() {
            return this.value(CriticalStrikeMode.ALLOWED, Vulnerability.none);
        }

        public double randomValue(Vulnerability vulnerability) {
            return this.value(CriticalStrikeMode.ALLOWED, vulnerability);
        }

        public double nonCriticalValue() {
            return this.value(CriticalStrikeMode.DISABLED, Vulnerability.none);
        }

        public double forcedCriticalValue() {
            return this.value(CriticalStrikeMode.FORCED, Vulnerability.none);
        }

        private double value(CriticalStrikeMode mode, Vulnerability vulnerability) {
            double value = this.baseValue * (double)(1.0f + vulnerability.powerBaseMultiplier);
            if (mode != CriticalStrikeMode.DISABLED) {
                boolean isCritical;
                boolean bl = isCritical = mode == CriticalStrikeMode.FORCED || (double)rng.nextFloat() < this.criticalChance + (double)vulnerability.criticalChanceBonus;
                if (isCritical) {
                    value *= this.criticalDamage + (double)vulnerability.criticalDamageBonus;
                }
            }
            return value;
        }

        private static enum CriticalStrikeMode {
            DISABLED,
            ALLOWED,
            FORCED;

        }
    }
}

