/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api.enchantment;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.spell_power.api.MagicSchool;
import net.spell_power.api.attributes.SpellAttributeEntry;
import net.spell_power.api.attributes.SpellAttributes;
import net.spell_power.api.enchantment.Enchantments_SpellPower;
import net.spell_power.internals.SchoolFilteredEnchantment;

public class SpellPowerEnchanting {
    private static final ArrayList<class_1738> armor = new ArrayList();
    private static final ArrayList<Function<class_1799, Boolean>> weaponConditions = new ArrayList();
    private static final Multimap<MagicSchool, AttributeBoost> powerMap = HashMultimap.create();

    public static void registerArmor(class_1738 ... items) {
        for (class_1738 item : items) {
            SpellPowerEnchanting.registerArmor(item);
        }
    }

    public static void registerArmor(List<class_1738> items) {
        for (class_1738 item : items) {
            SpellPowerEnchanting.registerArmor(item);
        }
    }

    public static void registerArmor(class_1738 item) {
        armor.add(item);
    }

    public static boolean isArmorRegistered(class_1792 item) {
        return armor.contains(item);
    }

    public static void allowForWeapon(Function<class_1799, Boolean> condition) {
        weaponConditions.add(condition);
    }

    public static boolean isAllowedForWeapon(class_1799 stack) {
        for (Function<class_1799, Boolean> condition : weaponConditions) {
            if (!condition.apply(stack).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static void boostSchool(MagicSchool school, class_1887 enchantment, BiFunction<Double, Integer, Double> amplifier) {
        powerMap.put((Object)school, (Object)new AttributeBoost(enchantment, amplifier));
    }

    public static Collection<AttributeBoost> boostersFor(MagicSchool school) {
        return powerMap.get((Object)school);
    }

    public static EnumSet<MagicSchool> relevantSchools(class_1799 stack, class_1304 slot) {
        EnumSet<MagicSchool> schools = EnumSet.noneOf(MagicSchool.class);
        Multimap attributes = stack.method_7926(slot);
        for (Map.Entry entry : attributes.entries()) {
            class_2960 attributeId = class_2378.field_23781.method_10221((Object)((class_1320)entry.getKey()));
            for (Map.Entry<MagicSchool, SpellAttributeEntry> powerEntry : SpellAttributes.POWER.entrySet()) {
                if (!powerEntry.getValue().id.equals((Object)attributeId)) continue;
                schools.add(powerEntry.getKey());
            }
        }
        return schools;
    }

    static {
        for (Map.Entry<class_2960, SchoolFilteredEnchantment> entry : Enchantments_SpellPower.damageEnchants.entrySet()) {
            SchoolFilteredEnchantment enchantment = entry.getValue();
            for (MagicSchool school : enchantment.poweredSchools()) {
                SpellPowerEnchanting.boostSchool(school, enchantment, enchantment::amplify);
            }
        }
        SpellPowerEnchanting.boostSchool(MagicSchool.PHYSICAL_MELEE, class_1893.field_9118, (value, level) -> value * (1.0 + 0.05 * (double)level.intValue()));
    }

    public record AttributeBoost(class_1887 enchantment, BiFunction<Double, Integer, Double> amplifier) {
    }
}

