/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.siphalor.capsaicin.api.food.FoodContext;
import de.siphalor.capsaicin.api.food.FoodEvents;
import de.siphalor.capsaicin.api.food.FoodModifications;
import de.siphalor.capsaicin.api.food.FoodProperties;
import de.siphalor.capsaicin.api.food.PlayerFoodModifier;
import de.siphalor.capsaicin.api.modifier.Modifier;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.item.FoodContainerItem;
import de.siphalor.spiceoffabric.networking.SOFCommonNetworking;
import de.siphalor.spiceoffabric.polymer.SOFPolymer;
import de.siphalor.spiceoffabric.recipe.FoodJournalRecipeSerializer;
import de.siphalor.spiceoffabric.server.SOFCommands;
import de.siphalor.spiceoffabric.util.FoodUtils;
import de.siphalor.spiceoffabric.util.IHungerManager;
import de.siphalor.tweed4.Tweed;
import de.siphalor.tweed4.config.ConfigEnvironment;
import de.siphalor.tweed4.config.ConfigFile;
import de.siphalor.tweed4.config.ConfigLoader;
import de.siphalor.tweed4.config.TweedRegistry;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2749;
import net.minecraft.class_2781;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3518;
import net.minecraft.class_3917;
import net.minecraft.class_4174;
import net.minecraft.class_5134;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiceOfFabric
implements ModInitializer {
    public static final String MOD_ID = "spiceoffabric";
    public static final String NBT_FOOD_HISTORY_ID = "spiceOfFabric_history";
    public static final String NBT_VERSION_ID = "spiceOfFabric_version";
    public static final int NBT_VERSION = 1;
    public static final String FOOD_JOURNAL_FLAG = "spiceoffabric:food_journal";
    public static final UUID PLAYER_HEALTH_MODIFIER_UUID = UUID.nameUUIDFromBytes("spiceoffabric".getBytes(StandardCharsets.UTF_8));
    public static final Logger LOGGER = LoggerFactory.getLogger(SpiceOfFabric.class);
    private static final class_4174 EMPTY_FOOD_COMPONENT = new class_4174.class_4175().method_19242();
    public static class_1792[] foodContainerItems;

    public void onInitialize() {
        SpiceOfFabric.initConfig();
        SOFCommonNetworking.init();
        SOFCommands.register();
        SpiceOfFabric.initResourceConditions();
        SpiceOfFabric.initRecipes();
        SpiceOfFabric.initFoodEvents();
        if (SOFConfig.items.usePolymer) {
            if (!FabricLoader.getInstance().isModLoaded("polymer")) {
                LOGGER.error("Polymer is not installed, but Polymer usage is enabled in the Spice of Fabric config!");
                System.exit(1);
            }
            SOFPolymer.init();
        } else {
            SpiceOfFabric.initNativeFoodContainerItems();
        }
    }

    private static void initConfig() {
        Tweed.runEntryPoints();
        ConfigLoader.initialReload((ConfigFile)TweedRegistry.getConfigFile((String)MOD_ID), (ConfigEnvironment)(FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER ? ConfigEnvironment.SERVER : ConfigEnvironment.UNIVERSAL));
    }

    private static void initResourceConditions() {
        ResourceConditions.register((class_2960)new class_2960(MOD_ID, "registry_populated"), optionsJson -> {
            class_2960 id = new class_2960(class_3518.method_15265((JsonObject)optionsJson, (String)"registry"));
            class_2378 registry = (class_2378)class_2378.field_11144.method_10223(id);
            if (registry == null) {
                throw new JsonSyntaxException(id + " is not a valid registry!");
            }
            for (JsonElement elementJson : class_3518.method_15261((JsonObject)optionsJson, (String)"ids")) {
                class_2960 elementId = new class_2960(class_3518.method_15287((JsonElement)elementJson, (String)"id"));
                if (registry.method_10250(elementId)) continue;
                return false;
            }
            return true;
        });
    }

    private static void initRecipes() {
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)new class_2960(MOD_ID, "food_journal"), (Object)new FoodJournalRecipeSerializer());
    }

    private static void initNativeFoodContainerItems() {
        ArrayList<class_1792> foodContainerItems = new ArrayList<class_1792>(4);
        if (SOFConfig.items.enablePaperBag) {
            foodContainerItems.add((class_1792)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960(MOD_ID, "paper_bag"), (Object)((Object)new FoodContainerItem(new class_1792.class_1793().method_7889(1).method_19265(EMPTY_FOOD_COMPONENT).method_7892(class_1761.field_7922), 5, class_3917.field_17337))));
        }
        if (SOFConfig.items.enableLunchBox) {
            foodContainerItems.add((class_1792)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960(MOD_ID, "lunch_box"), (Object)((Object)new FoodContainerItem(new class_1792.class_1793().method_7889(1).method_19265(EMPTY_FOOD_COMPONENT).method_7892(class_1761.field_7922), 9, class_3917.field_17328))));
        }
        if (SOFConfig.items.enablePicnicBasket) {
            foodContainerItems.add((class_1792)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960(MOD_ID, "picnic_basket"), (Object)((Object)new FoodContainerItem(new class_1792.class_1793().method_7889(1).method_19265(EMPTY_FOOD_COMPONENT).method_7892(class_1761.field_7922), 9, class_3917.field_17328))));
        }
        SpiceOfFabric.foodContainerItems = foodContainerItems.toArray(new class_1792[0]);
    }

    private static void initFoodEvents() {
        FoodEvents.EATEN.on(SpiceOfFabric::onFoodEaten);
        FoodModifications.EATING_TIME_MODIFIERS.register((Modifier)((PlayerFoodModifier)SpiceOfFabric::modifyEatingTime), new class_2960(MOD_ID, "config_expression"));
        FoodModifications.PROPERTIES_MODIFIERS.register(SpiceOfFabric::modifyFoodProperties, new class_2960(MOD_ID, "config_expression"));
    }

    private static void onFoodEaten(FoodEvents.Eaten event) {
        FoodContext context = event.context();
        class_1309 class_13092 = context.user();
        if (class_13092 instanceof class_3222) {
            class_3222 player = (class_3222)class_13092;
            FoodHistory foodHistory = FoodHistory.get((class_1657)player);
            class_1799 foodStack = FoodUtils.getFoodStack(context);
            foodHistory.addFood(foodStack, player);
            if (SOFConfig.carrot.enable && (player.method_6063() < (float)SOFConfig.carrot.maxHealth || SOFConfig.carrot.maxHealth == -1)) {
                SpiceOfFabric.updateMaxHealth(player, true, true);
            }
        }
    }

    private static Integer modifyEatingTime(Integer eatingTime, FoodContext context, class_1657 player) {
        FoodHistory foodHistory = FoodHistory.get(player);
        if (foodHistory == null) {
            return eatingTime;
        }
        SOFConfig.setConsumeDurationValues(foodHistory.getTimesRecentlyEaten(FoodUtils.getFoodStack(context)), context.originalFoodHunger(), context.originalFoodSaturationModifier(), eatingTime);
        return (int)SOFConfig.consumeDurationExpression.evaluate();
    }

    private static FoodProperties modifyFoodProperties(FoodProperties foodProperties, FoodContext context) {
        class_1657 player;
        FoodHistory foodHistory;
        class_1309 class_13092 = context.user();
        int timesEaten = class_13092 instanceof class_1657 ? ((foodHistory = FoodHistory.get(player = (class_1657)class_13092)) != null ? foodHistory.getTimesRecentlyEaten(FoodUtils.getFoodStack(context)) : 0) : 0;
        SOFConfig.setHungerExpressionValues(timesEaten, foodProperties.getHunger(), foodProperties.getSaturationModifier(), 0);
        foodProperties.setHunger(SOFConfig.getHungerValue());
        foodProperties.setSaturationModifier(SOFConfig.getSaturationValue());
        return foodProperties;
    }

    public static boolean hasClientMod(class_3222 player) {
        return SOFCommonNetworking.hasClientMod(player);
    }

    public static class_1322 createHealthModifier(double amount) {
        return new class_1322(PLAYER_HEALTH_MODIFIER_UUID, MOD_ID, amount, class_1322.class_1323.field_6328);
    }

    public static void updateMaxHealth(class_3222 player, boolean sync, boolean announce) {
        class_1324 maxHealthAttr = player.method_5996(class_5134.field_23716);
        double oldValue = maxHealthAttr.method_6194();
        maxHealthAttr.method_6200(PLAYER_HEALTH_MODIFIER_UUID);
        if (SOFConfig.carrot.enable) {
            FoodHistory foodHistory = ((IHungerManager)player.method_7344()).spiceOfFabric_getFoodHistory();
            maxHealthAttr.method_26837(SpiceOfFabric.createHealthModifier(foodHistory.getCarrotHealthOffset((class_1657)player)));
        }
        if (sync) {
            player.field_13987.method_14364((class_2596)new class_2781(player.method_5628(), Collections.singleton(maxHealthAttr)));
            player.field_13987.method_14364((class_2596)new class_2749(player.method_6032(), player.method_7344().method_7586(), player.method_7344().method_7589()));
        }
        if (announce && maxHealthAttr.method_6194() > oldValue) {
            player.field_6002.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14709, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    public static boolean isFoodJournal(class_1799 stack) {
        if (stack == null) {
            return false;
        }
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10573(FOOD_JOURNAL_FLAG, 1) && nbt.method_10577(FOOD_JOURNAL_FLAG);
    }

    public static class_1799 createFoodJournalStack() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8360);
        class_2487 compound = stack.method_7948();
        compound.method_10582("title", "");
        compound.method_10582("author", "Me");
        compound.method_10556(FOOD_JOURNAL_FLAG, true);
        stack.method_7911("display").method_10582("Name", "{\"translate\":\"Diet Journal\",\"bold\":true}");
        return stack;
    }
}

