/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.container;

import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.container.ClickableSlot;
import de.siphalor.spiceoffabric.container.FoodJournalView;
import de.siphalor.spiceoffabric.container.PaginatedReadOnlyInventory;
import de.siphalor.spiceoffabric.container.ReadOnlySlot;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.foodhistory.FoodHistoryEntry;
import de.siphalor.spiceoffabric.util.FoodUtils;
import de.siphalor.spiceoffabric.util.IHungerManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_4174;
import org.jetbrains.annotations.Nullable;

public class FoodJournalScreenHandler
extends class_1703 {
    private static final String PAGE_INDICATOR_TEXT_KEY = "book.pageIndicator";
    private static final class_1792 PAGE_INDICATOR_ITEM = class_1802.field_8600;
    private static final class_1799 PREV_STACK = new class_1799((class_1935)class_1802.field_8153);
    private static final class_1799 NEXT_STACK;
    private static final int JOURNAL_SLOT_COUNT = 45;
    private final class_3222 player;
    private final boolean clientHasMod;
    private final FoodJournalView currentView;
    private final PaginatedReadOnlyInventory foodJournalInventory;
    private final class_1263 infoInventory;

    public FoodJournalScreenHandler(@Nullable class_3917<?> type, int syncId, FoodJournalView currentView, class_3222 player, FoodHistory foodHistory) {
        super(type, syncId);
        int i;
        this.currentView = currentView;
        this.player = player;
        this.clientHasMod = SpiceOfFabric.hasClientMod(player);
        this.foodJournalInventory = this.createFoodJournalInventory(foodHistory, currentView);
        for (int i2 = 0; i2 < 45; ++i2) {
            this.method_7621(new ReadOnlySlot(this.foodJournalInventory, i2, 0, 0));
        }
        this.infoInventory = new class_1277(new class_1799[]{class_1799.field_8037, class_1799.field_8037, class_1799.field_8037, PREV_STACK, this.createPageIndicatorStack(), NEXT_STACK, this.getViewStack(FoodJournalView.HISTORY, class_1802.field_8529), this.getViewStack(FoodJournalView.CARROT, class_1802.field_8695), this.getViewStack(FoodJournalView.CARROT_UNEATEN, class_1802.field_27022)});
        this.method_7621(new ReadOnlySlot(this.infoInventory, 0, 0, 0));
        this.method_7621(new ReadOnlySlot(this.infoInventory, 1, 0, 0));
        this.method_7621(new ReadOnlySlot(this.infoInventory, 2, 0, 0));
        this.method_7621(new ClickableSlot(this.infoInventory, 3, 0, 0, this::previousPage));
        this.method_7621(new ReadOnlySlot(this.infoInventory, 4, 0, 0));
        this.method_7621(new ClickableSlot(this.infoInventory, 5, 0, 0, this::nextPage));
        this.method_7621(new ClickableSlot(this.infoInventory, 6, 0, 0, this.getViewCallback(FoodJournalView.HISTORY)));
        this.method_7621(new ClickableSlot(this.infoInventory, 7, 0, 0, this.getViewCallback(FoodJournalView.CARROT)));
        this.method_7621(new ClickableSlot(this.infoInventory, 8, 0, 0, this.getViewCallback(FoodJournalView.CARROT_UNEATEN)));
        class_1661 playerInventory = player.method_31548();
        for (i = 9; i < 36; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 0, 0));
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 0, 0));
        }
    }

    private PaginatedReadOnlyInventory createFoodJournalInventory(FoodHistory foodHistory, FoodJournalView view) {
        if (view == FoodJournalView.HISTORY) {
            int historySize = foodHistory.getRecentlyEatenCount();
            ArrayList<class_1799> stacks = new ArrayList<class_1799>(historySize);
            for (int i = 0; i < historySize; ++i) {
                stacks.add(foodHistory.getStackFromRecentlyEaten(i));
            }
            return new PaginatedReadOnlyInventory(45, stacks);
        }
        if (view == FoodJournalView.CARROT) {
            List<class_1799> stacks = foodHistory.getUniqueFoodsEaten().stream().map(FoodHistoryEntry::getStack).sorted(Comparator.comparingInt(stack -> {
                class_4174 foodComponent = stack.method_7909().method_19264();
                if (foodComponent == null) {
                    return 0;
                }
                return foodComponent.method_19230();
            })).toList();
            return new PaginatedReadOnlyInventory(45, stacks);
        }
        if (view == FoodJournalView.CARROT_UNEATEN) {
            Set eatenItems = foodHistory.getUniqueFoodsEaten().stream().map(entry -> entry.getStack().method_7909()).collect(Collectors.toUnmodifiableSet());
            List<class_1799> stacks = ((Stream)class_2378.field_11142.method_10220().parallel()).filter(FoodUtils::isFood).filter(item -> !eatenItems.contains(item)).sorted(Comparator.comparingInt(item -> {
                class_4174 foodComponent = item.method_19264();
                if (foodComponent == null) {
                    return 0;
                }
                return foodComponent.method_19230();
            })).map(class_1799::new).toList();
            return new PaginatedReadOnlyInventory(45, stacks);
        }
        throw new IllegalStateException("Unrecognized view " + view + " during journal screen creation");
    }

    private class_1799 createPageIndicatorStack() {
        class_1799 stack = new class_1799((class_1935)PAGE_INDICATOR_ITEM);
        stack.method_7977((class_2561)class_2561.method_43469((String)PAGE_INDICATOR_TEXT_KEY, (Object[])new Object[]{this.foodJournalInventory.getPage() + 1, this.foodJournalInventory.getPageCount()}).method_27694(style -> style.method_10978(Boolean.valueOf(false))));
        return stack;
    }

    private class_1799 getViewStack(FoodJournalView view, class_1792 itemRepresentation) {
        if (this.currentView == view || !view.isAvailable()) {
            return class_1799.field_8037;
        }
        return new class_1799((class_1935)itemRepresentation).method_7977((class_2561)(this.clientHasMod ? view.getTranslatableName() : class_2561.method_43470((String)view.getLiteralName()).method_27694(style -> style.method_10978(Boolean.valueOf(false)))));
    }

    private Runnable getViewCallback(FoodJournalView view) {
        if (!view.isAvailable()) {
            return () -> {};
        }
        return () -> this.player.method_17355((class_3908)new Factory(this.player, view));
    }

    private void previousPage() {
        int page = this.foodJournalInventory.getPage();
        if (page > 0) {
            this.foodJournalInventory.setPage(--page);
            this.infoInventory.method_5447(4, this.createPageIndicatorStack());
            this.method_34252();
        }
    }

    private void nextPage() {
        int page = this.foodJournalInventory.getPage();
        if (page < this.foodJournalInventory.getPageCount() - 1) {
            this.foodJournalInventory.setPage(++page);
            this.infoInventory.method_5447(4, this.createPageIndicatorStack());
            this.method_34252();
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    static {
        PREV_STACK.method_7977((class_2561)class_2561.method_43471((String)"createWorld.customize.custom.prev").method_27694(style -> style.method_10978(Boolean.valueOf(false))));
        NEXT_STACK = new class_1799((class_1935)class_1802.field_8145);
        NEXT_STACK.method_7977((class_2561)class_2561.method_43471((String)"createWorld.customize.custom.next").method_27694(style -> style.method_10978(Boolean.valueOf(false))));
    }

    public static class Factory
    implements class_3908 {
        private final class_3222 player;
        private final FoodJournalView view;

        public Factory(class_3222 player, FoodJournalView view) {
            this.player = player;
            this.view = view;
        }

        public class_2561 method_5476() {
            if (SpiceOfFabric.hasClientMod(this.player)) {
                return this.view.getTranslatableName();
            }
            return class_2561.method_43470((String)this.view.getLiteralName());
        }

        @Nullable
        public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
            return new FoodJournalScreenHandler(class_3917.field_17327, syncId, this.view, this.player, ((IHungerManager)player.method_7344()).spiceOfFabric_getFoodHistory());
        }
    }
}

