/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.util;

import de.siphalor.capsaicin.api.food.FoodContext;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.item.FoodContainerItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2272;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class FoodUtils {
    private static final String LAST_EATEN_BASE_TRANSLATION_KEY = "spiceoffabric.item.tooltip.last_eaten";
    private static final class_2561 NEVER_EATEN_TOOLTIP = class_2561.method_43471((String)"spiceoffabric.item.tooltip.never_eaten");

    private FoodUtils() {
    }

    public static boolean isFood(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item instanceof FoodContainerItem) {
            return false;
        }
        if (stack.method_19267()) {
            return true;
        }
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            return blockItem.method_7711() instanceof class_2272;
        }
        return false;
    }

    public static boolean isFood(class_1792 item) {
        if (item instanceof FoodContainerItem) {
            return false;
        }
        if (item.method_19263()) {
            return true;
        }
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            return blockItem.method_7711() instanceof class_2272;
        }
        return false;
    }

    @Nullable
    public static class_1799 getFoodStack(FoodContext context) {
        class_1792 item;
        class_1799 stack = context.stack();
        if (stack != null) {
            return stack;
        }
        class_2680 blockState = context.blockState();
        if (blockState != null && (item = blockState.method_26204().method_8389()) != null) {
            return new class_1799((class_1935)item);
        }
        return null;
    }

    public static void appendServerTooltips(class_1657 player, class_1799 stack) {
        class_2499 loreNbt;
        if (!FoodUtils.isFood(stack)) {
            return;
        }
        FoodHistory foodHistory = FoodHistory.get(player);
        if (foodHistory == null) {
            return;
        }
        ArrayList<class_2561> additions = new ArrayList<class_2561>();
        FoodUtils.appendCarrotTooltip(additions, stack, foodHistory);
        if (additions.isEmpty()) {
            return;
        }
        class_2487 displayNbt = stack.method_7911("display");
        if (displayNbt.method_10573("Lore", 9)) {
            loreNbt = displayNbt.method_10554("Lore", 8);
        } else {
            loreNbt = new class_2499();
            displayNbt.method_10566("Lore", (class_2520)loreNbt);
        }
        for (class_2561 addition : additions) {
            loreNbt.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)addition)));
        }
    }

    public static List<class_2561> getClientTooltipAdditions(class_1657 player, class_1799 stack) {
        if (!FoodUtils.isFood(stack)) {
            return Collections.emptyList();
        }
        FoodHistory foodHistory = FoodHistory.get(player);
        if (foodHistory == null) {
            return Collections.emptyList();
        }
        ArrayList<class_2561> additions = new ArrayList<class_2561>();
        FoodUtils.appendCarrotTooltip(additions, stack, foodHistory);
        FoodUtils.appendLastEatenTooltip(additions, stack, foodHistory);
        return additions;
    }

    private static void appendCarrotTooltip(List<class_2561> base, class_1799 stack, FoodHistory foodHistory) {
        if (SOFConfig.carrot.enable && !foodHistory.isInUniqueEaten(stack)) {
            base.add(NEVER_EATEN_TOOLTIP);
        }
    }

    private static void appendLastEatenTooltip(List<class_2561> base, class_1799 stack, FoodHistory foodHistory) {
        if (SOFConfig.showLastEatenTips == SOFConfig.ItemTipDisplayStyle.NONE || SOFConfig.food.historyLength <= 0) {
            return;
        }
        int lastEaten = foodHistory.getFoodCountSinceLastEaten(stack);
        if (lastEaten < 0) {
            return;
        }
        class_5250 text = lastEaten == 0 ? class_2561.method_43469((String)"spiceoffabric.item.tooltip.last_eaten.simple.last", (Object[])new Object[]{lastEaten}) : (lastEaten == 1 ? class_2561.method_43469((String)"spiceoffabric.item.tooltip.last_eaten.simple.one", (Object[])new Object[]{lastEaten}) : class_2561.method_43469((String)"spiceoffabric.item.tooltip.last_eaten.simple", (Object[])new Object[]{lastEaten}));
        if (SOFConfig.showLastEatenTips == SOFConfig.ItemTipDisplayStyle.EXTENDED) {
            int left = SOFConfig.food.historyLength - lastEaten;
            text = left == 1 ? class_2561.method_43469((String)"spiceoffabric.item.tooltip.last_eaten.extended.one", (Object[])new Object[]{text, SOFConfig.food.historyLength - lastEaten}) : class_2561.method_43469((String)"spiceoffabric.item.tooltip.last_eaten.extended", (Object[])new Object[]{text, SOFConfig.food.historyLength - lastEaten});
        }
        for (String line : StringUtils.split((String)text.getString(), (char)'\n')) {
            base.add((class_2561)class_2561.method_43470((String)line).method_27694(style -> style.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true))));
        }
    }
}

