/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.screen.MaterialListGUI;
import com.direwolf20.buildinggadgets.client.screen.components.EntryList;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.util.lang.ITranslationProvider;
import com.direwolf20.buildinggadgets.common.util.lang.MaterialListTranslation;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_746;

class ScrollingMaterialList
extends EntryList<Entry> {
    private static final int UPDATE_MILLIS = 1000;
    static final int TOP = 16;
    static final int BOTTOM = 32;
    private static final int SLOT_SIZE = 18;
    private static final int MARGIN = 2;
    private static final int ENTRY_HEIGHT;
    private static final int LINE_SIDE_MARGIN = 8;
    private final MaterialListGUI gui;
    private SortingModes sortingMode;
    private long lastUpdate;
    private Iterator<ImmutableMultiset<ItemVariant>> multisetIterator;

    public ScrollingMaterialList(MaterialListGUI gui) {
        super(gui.getWindowLeftX(), gui.getWindowTopY() + 16, gui.getWindowWidth(), gui.getWindowHeight() - 16 - 32, ENTRY_HEIGHT);
        this.gui = gui;
        this.setSortingMode(SortingModes.NAME);
        this.updateEntries();
    }

    private void updateEntries() {
        MatchResult result;
        class_746 player;
        this.lastUpdate = System.currentTimeMillis();
        this.method_25339();
        if (this.multisetIterator == null || !this.multisetIterator.hasNext()) {
            MaterialList list = this.gui.getHeader().getRequiredItems();
            UnmodifiableIterator unmodifiableIterator = this.multisetIterator = list != null ? list.iterator() : Iterators.singletonIterator((Object)ImmutableMultiset.of());
        }
        if ((player = class_310.method_1551().field_1724) == null) {
            return;
        }
        IItemIndex index = InventoryHelper.index(this.gui.getTemplateItem(), (class_1657)player);
        try (Transaction transaction = Transaction.openOuter();){
            result = index.match(MaterialList.of((Iterable)this.multisetIterator.next()), (TransactionContext)transaction);
        }
        for (Multiset.Entry entry : result.getChosenOption().entrySet()) {
            ItemVariant item = (ItemVariant)entry.getElement();
            this.method_25321((class_350.class_351)new Entry(this, item, entry.getCount(), result.getFoundItems().count(entry.getElement())));
        }
        this.sort();
    }

    protected int method_25329() {
        return this.field_19087 - 2 - 6;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 69) {
            assert (class_310.method_1551().field_1724 != null);
            class_310.method_1551().field_1724.method_7346();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float partialTicks) {
        if (this.lastUpdate + 1000L < System.currentTimeMillis()) {
            this.updateEntries();
        }
        super.method_25394(matrices, mouseX, mouseY, partialTicks);
    }

    public void reset() {
        this.multisetIterator = null;
    }

    public SortingModes getSortingMode() {
        return this.sortingMode;
    }

    public void setSortingMode(SortingModes sortingMode) {
        this.sortingMode = sortingMode;
        this.sort();
    }

    private void sort() {
        this.method_25396().sort(this.sortingMode.getComparator());
    }

    static {
        Objects.requireNonNull(class_310.method_1551().field_1772);
        ENTRY_HEIGHT = Math.max(22, 9 * 2 + 6);
    }

    static enum SortingModes {
        NAME(Comparator.comparing(Entry::getItemName), MaterialListTranslation.BUTTON_SORTING_NAMEAZ),
        NAME_REVERSED(NAME.getComparator().reversed(), MaterialListTranslation.BUTTON_SORTING_NAMEZA),
        REQUIRED(Comparator.comparingInt(Entry::getRequired), MaterialListTranslation.BUTTON_SORTING_REQUIREDACSE),
        REQUIRED_REVERSED(REQUIRED.getComparator().reversed(), MaterialListTranslation.BUTTON_SORTING_MISSINGDESC),
        MISSING(Comparator.comparingInt(Entry::getMissing), MaterialListTranslation.BUTTON_SORTING_MISSINGACSE),
        MISSING_REVERSED(MISSING.getComparator().reversed(), MaterialListTranslation.BUTTON_SORTING_MISSINGDESC);

        private final Comparator<Entry> comparator;
        private final ITranslationProvider translationProvider;
        public static final SortingModes[] VALUES;

        private SortingModes(Comparator<Entry> comparator, ITranslationProvider provider) {
            this.comparator = comparator;
            this.translationProvider = provider;
        }

        public Comparator<Entry> getComparator() {
            return this.comparator;
        }

        public String getLocalizedName() {
            return this.translationProvider.format(new Object[0]);
        }

        public ITranslationProvider getTranslationProvider() {
            return this.translationProvider;
        }

        public SortingModes next() {
            int nextIndex = this.ordinal() + 1;
            return VALUES[nextIndex >= VALUES.length ? 0 : nextIndex];
        }

        static {
            VALUES = SortingModes.values();
        }
    }

    static class Entry
    extends class_4280.class_4281<Entry> {
        private final ScrollingMaterialList parent;
        private final int required;
        private final int available;
        private final class_1799 stack;
        private final String itemName;
        private final String amount;
        private final int widthItemName;
        private final int widthAmount;

        public Entry(ScrollingMaterialList parent, ItemVariant item, int required, int available) {
            this.parent = parent;
            this.required = required;
            this.available = class_3532.method_15340((int)available, (int)0, (int)required);
            this.stack = item.toStack();
            this.itemName = this.stack.method_7964().getString();
            this.amount = this.available + "/" + required;
            this.widthItemName = class_310.method_1551().field_1772.method_1727(this.itemName);
            this.widthAmount = class_310.method_1551().field_1772.method_1727(this.amount);
        }

        public void method_25343(class_4587 matrices, int index, int topY, int leftX, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float particleTicks) {
            int right = leftX + entryWidth - 4;
            int bottom = topY + entryHeight;
            int slotX = leftX + 2;
            int slotY = topY + 2;
            this.drawIcon(matrices, this.stack, slotX, slotY);
            this.drawTextOverlay(matrices, right, topY, bottom, slotX);
            this.drawHoveringText(this.stack, slotX, slotY, mouseX, mouseY);
        }

        private void drawTextOverlay(class_4587 matrices, int right, int top, int bottom, int slotX) {
            int itemNameX = slotX + 18 + 2;
            MaterialListGUI.renderTextVerticalCenter(matrices, this.itemName, itemNameX, top, bottom, Color.WHITE.getRGB());
            Objects.requireNonNull(class_310.method_1551().field_1772);
            MaterialListGUI.renderTextHorizontalRight(matrices, this.amount, right, MaterialListGUI.getYForAlignedCenter(top, bottom, 9), this.getTextColor());
            this.drawGuidingLine(right, top, bottom, itemNameX, this.widthItemName, this.widthAmount);
        }

        private void drawGuidingLine(int right, int top, int bottom, int itemNameX, int widthItemName, int widthAmount) {
            if (!this.isSelected()) {
                int lineXStart = itemNameX + widthItemName + 8;
                int lineXEnd = right - widthAmount - 8;
                int lineY = MaterialListGUI.getYForAlignedCenter(top, bottom - 1, 1);
                RenderSystem.enableBlend();
                RenderSystem.disableTexture();
                RenderSystem.blendFunc((int)770, (int)771);
                RenderSystem.setShaderColor((float)255.0f, (float)255.0f, (float)255.0f, (float)34.0f);
                RenderSystem.enableTexture();
            }
        }

        private void drawHoveringText(class_1799 item, int slotX, int slotY, int mouseX, int mouseY) {
            if (MaterialListGUI.isPointInBox(mouseX, mouseY, slotX, slotY, 18, 18)) {
                this.parent.gui.setTaskHoveringText(mouseX, mouseY, this.parent.gui.method_25408(item));
            }
        }

        private void drawIcon(class_4587 matrices, class_1799 item, int slotX, int slotY) {
            class_308.method_24210();
            class_310.method_1551().method_1480().method_4023(item, slotX, slotY);
            class_308.method_24211();
        }

        private boolean hasEnoughItems() {
            return this.required == this.available;
        }

        private int getTextColor() {
            return this.hasEnoughItems() ? Color.GREEN.getRGB() : Color.RED.getRGB();
        }

        public int getRequired() {
            return this.required;
        }

        public int getAvailable() {
            return this.available;
        }

        public int getMissing() {
            return this.required - this.available;
        }

        public class_1799 getStack() {
            return this.stack;
        }

        public String getItemName() {
            return this.itemName;
        }

        public String getFormattedRequired() {
            int maxSize = this.stack.method_7914();
            int stacks = this.required / maxSize;
            int leftover = this.required % maxSize;
            if (stacks == 0) {
                return String.valueOf(leftover);
            }
            return stacks + "\u00d7" + maxSize + "+" + leftover;
        }

        public boolean method_25402(double x, double y, int button) {
            return false;
        }

        public boolean isSelected() {
            return this.parent.method_25334() == this;
        }

        public class_2561 method_37006() {
            return null;
        }
    }
}

