/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.component.BGComponent;
import com.direwolf20.buildinggadgets.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.network.C2S.PacketTemplateManagerTemplateCreated;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateProvider;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateIO;
import com.direwolf20.buildinggadgets.common.tileentities.TemplateManagerTileEntity;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateParseException;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateReadException;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateWriteException;
import com.direwolf20.buildinggadgets.common.util.lang.GuiTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.world.MockDelegationWorld;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_746;
import net.minecraft.class_768;
import net.minecraft.class_776;
import net.minecraft.class_827;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class TemplateManagerGUI
extends class_465<TemplateManagerContainer> {
    private static final class_2960 background = new class_2960("buildinggadgets", "textures/gui/template_manager.png");
    private final class_768 panel = new class_768(8, 23, 136, 80);
    private boolean panelClicked;
    private int clickButton;
    private int clickX;
    private int clickY;
    private float initRotX;
    private float initRotY;
    private float initZoom;
    private float initPanX;
    private float initPanY;
    private float momentumX;
    private float momentumY;
    private float rotX = 0.0f;
    private float rotY = 0.0f;
    private float zoom = 1.0f;
    private float panX = 0.0f;
    private float panY = 0.0f;
    private class_342 nameField;
    private class_4185 buttonSave;
    private class_4185 buttonLoad;
    private class_4185 buttonCopy;
    private class_4185 buttonPaste;
    private final TemplateManagerTileEntity be;
    private final TemplateManagerContainer container;
    private final Optional<ITemplateProvider> templateProvider = BGComponent.TEMPLATE_PROVIDER_COMPONENT.maybeGet((Object)this.getWorld());
    private Template template;

    public TemplateManagerGUI(TemplateManagerContainer container, class_1661 playerInventory, class_2561 title) {
        super((class_1703)container, playerInventory, (class_2561)class_2561.method_43470((String)""));
        this.container = container;
        this.be = container.getTe();
        this.field_2792 = 250;
        this.field_2779 = 192;
    }

    public void method_25426() {
        super.method_25426();
        Objects.requireNonNull(this.field_22793);
        this.nameField = new class_342(this.field_22793, this.field_2776 + 8, this.field_2800 + 6, this.field_2792 - 90, 9 + 3, (class_2561)GuiTranslation.TEMPLATE_NAME_TIP.componentTranslation(new Object[0]));
        int x = this.field_2776 + 182;
        this.buttonSave = (class_4185)this.method_37063((class_364)new class_4185(x, this.field_2800 + 41, 60, 20, (class_2561)GuiTranslation.BUTTON_SAVE.componentTranslation(new Object[0]), b -> this.onSave()));
        this.buttonLoad = (class_4185)this.method_37063((class_364)new class_4185(x, this.field_2800 + 63, 60, 20, (class_2561)GuiTranslation.BUTTON_LOAD.componentTranslation(new Object[0]), b -> this.onLoad()));
        this.buttonCopy = (class_4185)this.method_37063((class_364)new class_4185(x, this.field_2800 + 90, 60, 20, (class_2561)GuiTranslation.BUTTON_COPY.componentTranslation(new Object[0]), b -> this.onCopy()));
        this.buttonPaste = (class_4185)this.method_37063((class_364)new class_4185(x, this.field_2800 + 112, 60, 20, (class_2561)GuiTranslation.BUTTON_PASTE.componentTranslation(new Object[0]), b -> this.onPaste()));
        this.nameField.method_1880(50);
        this.nameField.method_1862(true);
        this.method_37063((class_364)this.nameField);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(matrices, mouseX, mouseY, partialTicks);
        this.method_2380(matrices, mouseX, mouseY);
        TemplateManagerGUI.method_25303((class_4587)matrices, (class_327)this.field_22793, (String)"Preview disabled for now...", (int)(this.field_2776 + 10), (int)(this.field_2800 + 56), (int)0xFFFFFF);
        if (this.template != null) {
            this.renderRequirement(matrices, mouseX, mouseY);
        }
    }

    protected void method_2389(class_4587 matrices, float partialTicks, int mouseX, int mouseY) {
        this.method_25420(matrices);
        RenderSystem.setShaderTexture((int)0, (class_2960)background);
        this.method_25302(matrices, this.field_2776, this.field_2800, 0, 0, 176, 192);
        this.method_25302(matrices, this.field_2776 + 176, this.field_2800 + 29, 176, 28, 76, 113);
        if (!this.buttonCopy.method_25367() && !this.buttonPaste.method_25367()) {
            int x = this.field_2776 + this.field_2792 - 98;
            int y = this.field_2800 + 49;
            if (this.buttonLoad.method_25367()) {
                this.method_25302(matrices, x, y, 176, 0, 17, 24);
            } else {
                this.method_25302(matrices, x, y, 193, 0, 16, 24);
            }
        }
        this.nameField.method_25394(matrices, mouseX, mouseY, partialTicks);
        TemplateManagerGUI.method_25294((class_4587)matrices, (int)(this.field_2776 + this.panel.method_3321() - 1), (int)(this.field_2800 + this.panel.method_3322() - 1), (int)(this.field_2776 + this.panel.method_3321() + this.panel.method_3319() + 1), (int)(this.field_2800 + this.panel.method_3322() + this.panel.method_3320() + 1), (int)-7697782);
    }

    private void validateCache(float partialTicks) {
        if (this.templateProvider.isEmpty()) {
            return;
        }
        if (this.container.method_7611(0).method_7677().method_7960() && this.template != null) {
            this.template = null;
            this.resetViewport();
            return;
        }
        ITemplateKey key = (ITemplateKey)BGComponent.TEMPLATE_KEY_COMPONENT.getNullable((Object)this.container.method_7611(0).method_7677());
        if (key == null) {
            return;
        }
        Template template = this.templateProvider.get().getTemplateForKey(key);
        if (this.template == template) {
            return;
        }
        this.template = template;
    }

    private void renderStructure(IBuildView view, float partialTicks) {
        Random rand = new Random();
        class_776 dispatcher = this.getMinecraft().method_1541();
        class_287 bufferBuilder = new class_287(0x200000);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
        for (PlacementTarget target : view) {
            target.placeIn(view.getContext());
            class_2338 targetPos = target.getPos();
            class_2680 renderBlockState = view.getContext().getWorld().method_8320(targetPos);
            class_2586 be = view.getContext().getWorld().method_8321(targetPos);
            if (renderBlockState.method_26217() == class_2464.field_11458) {
                class_1087 class_10872 = dispatcher.method_3349(renderBlockState);
            }
            if (be == null) continue;
            try {
                class_827 renderer = class_310.method_1551().method_31975().method_3550(be);
                if (renderer != null) {
                    // empty if block
                }
                RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
            }
            catch (Exception e) {
                BuildingGadgets.LOG.error("Error rendering TileEntity", (Throwable)e);
            }
        }
        bufferBuilder.method_1326();
    }

    private void renderRequirement(class_4587 matrices, int mouseX, int mouseY) {
        MatchResult list;
        MaterialList requirements = this.template.getHeaderAndForceMaterials(BuildContext.builder().build((class_1936)this.getWorld())).getRequiredItems();
        if (requirements == null) {
            return;
        }
        class_308.method_24210();
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        modelViewStack.method_22904((double)(this.field_2776 - 30), (double)(this.field_2800 - 5), 200.0);
        modelViewStack.method_22905(0.8f, 0.8f, 0.8f);
        matrices.method_22903();
        matrices.method_22904((double)(this.field_2776 - 30), (double)(this.field_2800 - 5), 200.0);
        String title = "Requirements";
        TemplateManagerGUI.method_25303((class_4587)matrices, (class_327)this.getMinecraft().field_1772, (String)title, (int)(5 - this.field_22793.method_1727(title)), (int)0, (int)Color.WHITE.getRGB());
        matrices.method_22909();
        try (Transaction transaction = Transaction.openOuter();){
            list = InventoryHelper.CREATIVE_INDEX.match(requirements, (TransactionContext)transaction);
        }
        ImmutableMultiset<ItemVariant> foundItems = list.getFoundItems();
        ImmutableList sortedEntries = ImmutableList.sortedCopyOf(Comparator.comparing(Multiset.Entry::getCount).reversed(), (Iterable)list.getChosenOption().entrySet());
        int index = 0;
        int column = 0;
        for (Multiset.Entry e : sortedEntries) {
            class_1799 stack = ((ItemVariant)e.getElement()).toStack();
            int x = -20 - column * 25;
            int y = 20 + index * 25;
            this.field_22788.method_4023(stack, x + 4, y + 4);
            this.field_22788.method_4022(class_310.method_1551().field_1772, stack, x + 4, y + 4, GadgetUtils.withSuffix(foundItems.count(e.getElement())));
            int space = 20;
            int zoneX = this.field_2776 - 32 + (-15 - column * space);
            int zoneY = this.field_2800 - 9 + (20 + index * space);
            if (mouseX > zoneX && mouseX < zoneX + space && mouseY > zoneY && mouseY < zoneY + space) {
                this.method_25417(matrices, Lists.transform((List)stack.method_7950((class_1657)this.getMinecraft().field_1724, (class_1836)class_1836.class_1837.field_8934), class_2561::method_30937), x + 15, y + 25);
            }
            if (++index % 8 != 0) continue;
            ++column;
            index = 0;
        }
        class_308.method_24211();
        modelViewStack.method_22909();
    }

    private void pasteTemplateToStack(class_1937 world, class_1799 stack, Template newTemplate, boolean replaced) {
        BGComponent.TEMPLATE_PROVIDER_COMPONENT.maybeGet((Object)world).ifPresent(provider -> this.pasteTemplateToStack((ITemplateProvider)provider, stack, newTemplate, replaced && world.method_8608()));
    }

    private void pasteTemplateToStack(ITemplateProvider provider, class_1799 stack, Template newTemplate, boolean replaced) {
        BGComponent.TEMPLATE_KEY_COMPONENT.maybeGet((Object)stack).ifPresent(key -> {
            provider.setTemplate((ITemplateKey)key, newTemplate);
            if (replaced) {
                PacketTemplateManagerTemplateCreated.send(provider.getId((ITemplateKey)key), this.be.method_11016());
            } else {
                provider.requestRemoteUpdate((ITemplateKey)key, this.be.method_10997());
            }
        });
    }

    private boolean replaceStack() {
        class_1799 stack = this.container.method_7611(1).method_7677();
        if (stack.method_7960()) {
            return false;
        }
        if (BGComponent.TEMPLATE_KEY_COMPONENT.isProvidedBy((Object)stack)) {
            return false;
        }
        if (stack.method_31573(TemplateManagerTileEntity.TEMPLATE_CONVERTIBLES)) {
            this.container.method_7611(1).method_7673(new class_1799((class_1935)OurItems.TEMPLATE_ITEM));
            return true;
        }
        return false;
    }

    private void rename(class_1799 stack) {
        if (this.nameField.method_1882().isEmpty()) {
            return;
        }
        BGComponent.TEMPLATE_KEY_COMPONENT.maybeGet((Object)stack).ifPresent(key -> this.templateProvider.ifPresent(provider -> {
            Template template = provider.getTemplateForKey((ITemplateKey)key);
            template = template.withName(this.nameField.method_1882());
            provider.setTemplate((ITemplateKey)key, template);
            provider.requestRemoteUpdate((ITemplateKey)key, this.getWorld());
        }));
    }

    private void renderPanel(class_4587 pose, int partialTicks) {
        this.validateCache(partialTicks);
        if (this.template == null) {
            return;
        }
        double scale = this.getMinecraft().method_22683().method_4495();
        class_2338 startPos = this.template.getHeader().getBoundingBox().getMin();
        class_2338 endPos = this.template.getHeader().getBoundingBox().getMax();
        double lengthX = Math.abs(startPos.method_10263() - endPos.method_10263());
        double lengthY = Math.abs(startPos.method_10264() - endPos.method_10264());
        double lengthZ = Math.abs(startPos.method_10260() - endPos.method_10260());
        double maxW = 96.0;
        double maxH = 176.0;
        double overW = Math.max(lengthX * 16.0 - 96.0, lengthZ * 16.0 - 96.0);
        double overH = lengthY * 16.0 - 176.0;
        double sc = 1.0;
        double zoomScale = 1.0;
        if (overW > 0.0 && overW >= overH) {
            sc = 96.0 / (overW + 96.0);
            zoomScale = overW / 40.0;
        } else if (overH > 0.0 && overH >= overW) {
            sc = 176.0 / (overH + 176.0);
            zoomScale = overH / 40.0;
        }
        pose.method_22903();
        pose.method_22903();
        pose.method_34426();
        pose.method_34425(class_1159.method_4929((double)60.0, (float)((float)this.panel.method_3319() / (float)this.panel.method_3320()), (float)0.01f, (float)4000.0f));
        RenderSystem.viewport((int)((int)Math.round((double)(this.field_2776 + this.panel.method_3321()) * scale)), (int)((int)Math.round((double)this.getMinecraft().method_22683().method_4506() - (double)(this.field_2800 + this.panel.method_3322() + this.panel.method_3320()) * scale)), (int)((int)Math.round((double)this.panel.method_3319() * scale)), (int)((int)Math.round((double)this.panel.method_3320() * scale)));
        RenderSystem.clear((int)256, (boolean)true);
        sc = 293.0 * sc + (double)this.zoom / zoomScale;
        pose.method_22905((float)sc, (float)sc, (float)sc);
        int moveX = startPos.method_10263() - endPos.method_10263();
        pose.method_22907(class_1160.field_20705.method_23626(30.0f));
        if (startPos.method_10263() >= endPos.method_10263()) {
            --moveX;
        }
        pose.method_22904((double)moveX / 1.75, (double)(-Math.abs(startPos.method_10264() - endPos.method_10264())) / 1.75, 0.0);
        pose.method_22904((double)this.panX, (double)(-this.panY), 0.0);
        pose.method_22904((double)((float)(startPos.method_10263() - endPos.method_10263()) / 2.0f * -1.0f), (double)((float)(startPos.method_10264() - endPos.method_10264()) / 2.0f * -1.0f), (double)((float)(startPos.method_10260() - endPos.method_10260()) / 2.0f * -1.0f));
        pose.method_22907(class_1160.field_20703.method_23626(-this.rotX));
        pose.method_22907(class_1160.field_20705.method_23626(this.rotY));
        pose.method_22904((double)((float)(startPos.method_10263() - endPos.method_10263()) / 2.0f), (double)((float)(startPos.method_10264() - endPos.method_10264()) / 2.0f), (double)((float)(startPos.method_10260() - endPos.method_10260()) / 2.0f));
        RenderSystem.disableDepthTest();
        IBuildView view = this.template.createViewInContext(BuildContext.builder().player((class_1657)this.getMinecraft().field_1724).stack(this.container.method_7611(0).method_7677()).build(new MockDelegationWorld((class_1936)this.getMinecraft().field_1687)));
        this.renderStructure(view, partialTicks);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        pose.method_22909();
        pose.method_22909();
        RenderSystem.viewport((int)0, (int)0, (int)this.getMinecraft().method_22683().method_4489(), (int)this.getMinecraft().method_22683().method_4506());
    }

    private void resetViewport() {
        this.rotX = 0.0f;
        this.rotY = 0.0f;
        this.zoom = 1.0f;
        this.momentumX = 0.0f;
        this.momentumY = 0.0f;
        this.panX = 0.0f;
        this.panY = 0.0f;
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (this.panel.method_3318((int)mouseX - this.field_2776, (int)mouseY - this.field_2800)) {
            this.clickButton = mouseButton;
            this.panelClicked = true;
            this.clickX = (int)this.getMinecraft().field_1729.method_1603();
            this.clickY = (int)this.getMinecraft().field_1729.method_1604();
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25406(double mouseX, double mouseY, int state) {
        this.panelClicked = false;
        this.initRotX = this.rotX;
        this.initRotY = this.rotY;
        this.initPanX = this.panX;
        this.initPanY = this.panY;
        this.initZoom = this.zoom;
        return super.method_25406(mouseX, mouseY, state);
    }

    public boolean method_25404(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.method_25419();
            return true;
        }
        return this.nameField.method_25370() ? this.nameField.method_25404(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : super.method_25404(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
        if (this.panelClicked) {
            if (this.clickButton == 0) {
                float prevRotX = this.rotX;
                float prevRotY = this.rotY;
                this.rotX = this.initRotX - (float)((int)this.getMinecraft().field_1729.method_1604() - this.clickY);
                this.rotY = this.initRotY + (float)((int)this.getMinecraft().field_1729.method_1603() - this.clickX);
                this.momentumX = this.rotX - prevRotX;
                this.momentumY = this.rotY - prevRotY;
            } else if (this.clickButton == 1) {
                this.panX = this.initPanX + (float)((int)this.getMinecraft().field_1729.method_1603() - this.clickX) / 8.0f;
                this.panY = this.initPanY + (float)((int)this.getMinecraft().field_1729.method_1604() - this.clickY) / 8.0f;
            }
        }
        this.rotX += this.momentumX;
        this.rotY += this.momentumY;
        float momentumDampening = 0.98f;
        this.momentumX *= momentumDampening;
        this.momentumY *= momentumDampening;
        if (!this.nameField.method_25370() && this.nameField.method_1882().isEmpty()) {
            this.getMinecraft().field_1772.method_1729(matrices, GuiTranslation.TEMPLATE_PLACEHOLDER.format(new Object[0]), (float)(this.nameField.field_22760 - this.field_2776 + 4), (float)(this.nameField.field_22761 + 2 - this.field_2800), -10197916);
        }
        if (this.buttonSave.method_25367() || this.buttonLoad.method_25367() || this.buttonPaste.method_25367()) {
            this.drawSlotOverlay(matrices, this.buttonLoad.method_25367() ? this.container.method_7611(0) : this.container.method_7611(1));
        }
    }

    private void drawSlotOverlay(class_4587 matrices, class_1735 slot) {
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 1000.0);
        TemplateManagerGUI.method_25294((class_4587)matrices, (int)slot.field_7873, (int)slot.field_7872, (int)(slot.field_7873 + 16), (int)(slot.field_7872 + 16), (int)-1660903937);
        matrices.method_22909();
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollDelta) {
        this.zoom = this.initZoom + (float)scrollDelta * 20.0f;
        if (this.zoom < -200.0f) {
            this.zoom = -200.0f;
        }
        if (this.zoom > 5000.0f) {
            this.zoom = 5000.0f;
        }
        return super.method_25401(mouseX, mouseY, scrollDelta);
    }

    protected void method_37432() {
        super.method_37432();
        this.nameField.method_1865();
        if (!this.panelClicked) {
            this.initRotX = this.rotX;
            this.initRotY = this.rotY;
            this.initZoom = this.zoom;
            this.initPanX = this.panX;
            this.initPanY = this.panY;
        }
    }

    private class_1937 getWorld() {
        return this.getMinecraft().field_1687;
    }

    public class_310 getMinecraft() {
        return class_310.method_1551();
    }

    private void runAfterUpdate(int slot, Runnable runnable) {
        BGComponent.TEMPLATE_KEY_COMPONENT.maybeGet((Object)this.container.method_7611(slot).method_7677()).ifPresent(key -> this.templateProvider.ifPresent(provider -> {
            provider.registerUpdateListener(new ITemplateProvider.IUpdateListener(){
                final /* synthetic */ ITemplateKey val$key;
                final /* synthetic */ Runnable val$runnable;
                {
                    this.val$key = iTemplateKey;
                    this.val$runnable = runnable;
                }

                @Override
                public void onTemplateUpdate(ITemplateProvider provider, ITemplateKey updateKey, Template template) {
                    if (provider.getId(updateKey).equals(provider.getId(this.val$key))) {
                        this.val$runnable.run();
                        provider.removeUpdateListener(this);
                    }
                }
            });
            provider.requestUpdate((ITemplateKey)key);
        }));
    }

    private void onSave() {
        boolean replaced = this.replaceStack();
        class_1799 left = this.container.method_7611(0).method_7677();
        class_1799 right = this.container.method_7611(1).method_7677();
        if (left.method_7960()) {
            this.rename(right);
            return;
        }
        this.runAfterUpdate(0, () -> this.templateProvider.ifPresent(provider -> BGComponent.TEMPLATE_KEY_COMPONENT.maybeGet((Object)left).ifPresent(key -> {
            Template templateToSave = provider.getTemplateForKey((ITemplateKey)key).withName(this.nameField.method_1882());
            this.pasteTemplateToStack((ITemplateProvider)provider, right, templateToSave, replaced);
        })));
    }

    private void onLoad() {
        boolean replaced = this.replaceStack();
        class_1799 left = this.container.method_7611(0).method_7677();
        class_1799 right = this.container.method_7611(1).method_7677();
        if (left.method_7960()) {
            this.rename(right);
            return;
        }
        this.runAfterUpdate(1, () -> this.templateProvider.ifPresent(provider -> BGComponent.TEMPLATE_KEY_COMPONENT.maybeGet((Object)right).ifPresent(key -> {
            Template templateToSave = provider.getTemplateForKey((ITemplateKey)key);
            this.pasteTemplateToStack((ITemplateProvider)provider, left, templateToSave, replaced);
        })));
    }

    private void onCopy() {
        this.runAfterUpdate(0, () -> {
            class_1799 stack = this.container.method_7611(0).method_7677();
            this.templateProvider.ifPresent(provider -> BGComponent.TEMPLATE_KEY_COMPONENT.maybeGet((Object)stack).ifPresent(key -> {
                class_746 player = this.getMinecraft().field_1724;
                assert (player != null);
                BuildContext buildContext = BuildContext.builder().player((class_1657)player).stack(stack).build((class_1936)this.getWorld());
                try {
                    Template template = provider.getTemplateForKey((ITemplateKey)key);
                    if (!this.nameField.method_1882().isEmpty()) {
                        template = template.withName(this.nameField.method_1882());
                    }
                    String json = TemplateIO.writeTemplateJson(template, buildContext);
                    this.getMinecraft().field_1774.method_1455(json);
                    player.method_7353((class_2561)MessageTranslation.CLIPBOARD_COPY_SUCCESS.componentTranslation(new Object[0]).method_10862(Styles.DK_GREEN), false);
                }
                catch (TemplateWriteException.DataCannotBeWrittenException e) {
                    BuildingGadgets.LOG.error("Failed to write Template.", (Throwable)e);
                    player.method_7353((class_2561)MessageTranslation.CLIPBOARD_COPY_ERROR_TEMPLATE.componentTranslation(new Object[0]).method_10862(Styles.RED), false);
                }
                catch (Exception e) {
                    BuildingGadgets.LOG.error("Failed to copy Template to clipboard.", (Throwable)e);
                    player.method_7353((class_2561)MessageTranslation.CLIPBOARD_COPY_ERROR.componentTranslation(new Object[0]).method_10862(Styles.RED), false);
                }
            }));
        });
    }

    private void onPaste() {
        assert (this.getMinecraft().field_1724 != null);
        String CBString = this.getMinecraft().field_1774.method_1460();
        if (GadgetUtils.mightBeLink(CBString)) {
            this.getMinecraft().field_1724.method_7353((class_2561)MessageTranslation.PASTE_FAILED_LINK_COPIED.componentTranslation(new Object[0]).method_10862(Styles.RED), false);
            return;
        }
        try {
            class_2487 tagFromJson = class_2522.method_10718((String)CBString);
            if (!tagFromJson.method_10545("header")) {
                BuildingGadgets.LOG.error("Attempted to use a 1.12 compound on a newer MC version");
                this.getMinecraft().field_1724.method_7353((class_2561)MessageTranslation.PASTE_FAILED_WRONG_MC_VERSION.componentTranslation("(1.12.x)", "1.14.4", TemplateHeader.HIGHEST_MC_VERSION).method_10862(Styles.RED), false);
                return;
            }
            if (!tagFromJson.method_10545("body")) {
                BuildingGadgets.LOG.error("Attempted to paste Material List as a template");
                this.getMinecraft().field_1724.method_7353((class_2561)MessageTranslation.PASTE_FAILED_MATERIAL_LIST.componentTranslation(new Object[0]).method_10862(Styles.RED), false);
                return;
            }
        }
        catch (CommandSyntaxException tagFromJson) {
            // empty catch block
        }
        try {
            Template template = TemplateIO.readTemplateFromJson(CBString);
            Template readTemplate = template.clearMaterials();
            if (!this.nameField.method_1882().isEmpty()) {
                readTemplate = readTemplate.withName(this.nameField.method_1882());
            }
            boolean replaced = this.replaceStack();
            class_1799 stack = this.container.method_7611(1).method_7677();
            this.pasteTemplateToStack(this.getWorld(), stack, readTemplate, replaced);
            this.getMinecraft().field_1724.method_7353((class_2561)MessageTranslation.PASTE_SUCCESS.componentTranslation(new Object[0]).method_10862(Styles.DK_GREEN), false);
        }
        catch (TemplateReadException.CorruptJsonException e) {
            BuildingGadgets.LOG.error("Failed to parse json syntax.", (Throwable)e);
            this.getMinecraft().field_1724.method_7353((class_2561)MessageTranslation.PASTE_FAILED_CORRUPT_JSON.componentTranslation(new Object[0]).method_10862(Styles.RED), false);
        }
        catch (TemplateParseException.IllegalMinecraftVersionException e) {
            BuildingGadgets.LOG.error("Attempted to parse Template for Minecraft version {} but expected between {} and {}.", (Object)e.getMinecraftVersion(), (Object)"1.14.4", (Object)TemplateHeader.HIGHEST_MC_VERSION, (Object)e);
            this.getMinecraft().field_1724.method_7353((class_2561)MessageTranslation.PASTE_FAILED_WRONG_MC_VERSION.componentTranslation(e.getMinecraftVersion(), "1.14.4", TemplateHeader.HIGHEST_MC_VERSION).method_10862(Styles.RED), false);
        }
        catch (TemplateParseException.UnknownTemplateVersionException e) {
            BuildingGadgets.LOG.error("Attempted to parse Template version {} but newest is {}.", (Object)e.getTemplateVersion(), (Object)"2.1.0", (Object)e);
            this.getMinecraft().field_1724.method_7353((class_2561)MessageTranslation.PASTE_FAILED_TOO_RECENT_VERSION.componentTranslation(e.getTemplateVersion(), "2.1.0").method_10862(Styles.RED), false);
        }
        catch (JsonParseException e) {
            BuildingGadgets.LOG.error("Failed to parse Template json.", (Throwable)e);
            this.getMinecraft().field_1724.method_7353((class_2561)MessageTranslation.PASTE_FAILED_INVALID_JSON.componentTranslation(new Object[0]).method_10862(Styles.RED), false);
        }
        catch (TemplateReadException e) {
            BuildingGadgets.LOG.error("Failed to read Template body.", (Throwable)e);
            this.getMinecraft().field_1724.method_7353((class_2561)MessageTranslation.PASTE_FAILED_CORRUPT_BODY.componentTranslation(new Object[0]).method_10862(Styles.RED), false);
        }
        catch (Exception e) {
            BuildingGadgets.LOG.error("Failed to paste Template.", (Throwable)e);
            this.getMinecraft().field_1724.method_7353((class_2561)MessageTranslation.PASTE_FAILED.componentTranslation(new Object[0]).method_10862(Styles.RED), false);
        }
    }
}

