/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.client.screen.GuiMod;
import com.direwolf20.buildinggadgets.client.screen.tooltip.TemplateData;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.commands.ForceUnloadedCommand;
import com.direwolf20.buildinggadgets.common.commands.OverrideBuildSizeCommand;
import com.direwolf20.buildinggadgets.common.commands.OverrideCopySizeCommand;
import com.direwolf20.buildinggadgets.common.component.BGComponent;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.network.C2S.PacketBindTool;
import com.direwolf20.buildinggadgets.common.network.Target;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementChecker;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.tainted.building.view.WorldBuildView;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.CopyScheduler;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.PlacementScheduler;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.util.Additions;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.ITranslationProvider;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.ModeTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2598;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.class_5632;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class GadgetCopyPaste
extends AbstractGadget {
    private static final Joiner CHUNK_JOINER = Joiner.on((String)"; ");

    public GadgetCopyPaste(class_1792.class_1793 builder) {
        super(builder, Reference.TagReference.WHITELIST_COPY_PASTE, Reference.TagReference.BLACKLIST_COPY_PASTE);
    }

    @Override
    public long getEnergyCapacity() {
        return BuildingGadgets.getConfig().gadgets.gadgetCopyPaste.maxEnergy;
    }

    @Override
    public long getEnergyCost(class_1799 tool) {
        return BuildingGadgets.getConfig().gadgets.gadgetCopyPaste.energyCost;
    }

    @Override
    public long getEnergyMaxOutput() {
        return 10000L;
    }

    @Override
    public boolean performRotate(class_1799 stack, class_1657 player) {
        return BGComponent.TEMPLATE_PROVIDER_COMPONENT.maybeGet((Object)player.field_6002).flatMap(provider -> BGComponent.TEMPLATE_KEY_COMPONENT.maybeGet((Object)stack).map(key -> {
            Template template = provider.getTemplateForKey((ITemplateKey)key);
            provider.setTemplate((ITemplateKey)key, template.rotate(class_2470.field_11463));
            provider.requestRemoteUpdate((ITemplateKey)key, new Target(class_2598.field_11942, (class_3222)player));
            return true;
        })).orElse(false);
    }

    @Override
    public boolean performMirror(class_1799 stack, class_1657 player) {
        return BGComponent.TEMPLATE_PROVIDER_COMPONENT.maybeGet((Object)player.field_6002).flatMap(provider -> BGComponent.TEMPLATE_KEY_COMPONENT.maybeGet((Object)stack).map(key -> {
            Template template = provider.getTemplateForKey((ITemplateKey)key);
            provider.setTemplate((ITemplateKey)key, template.mirror(player.method_5735().method_10166()));
            provider.requestRemoteUpdate((ITemplateKey)key, new Target(class_2598.field_11942, (class_3222)player));
            return true;
        })).orElse(false);
    }

    public static void setRelativeVector(class_1799 stack, class_2338 vec) {
        class_2487 nbt = stack.method_7948();
        if (vec.equals((Object)class_2338.field_10980)) {
            nbt.method_10551("rel_pos");
        } else {
            nbt.method_10566("rel_pos", (class_2520)class_2512.method_10692((class_2338)vec));
        }
    }

    public static class_2338 getRelativeVector(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        return class_2512.method_10691((class_2487)nbt.method_10562("rel_pos"));
    }

    public static int getAndIncrementCopyCounter(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        int count = nbt.method_10550("copy_count");
        nbt.method_10569("copy_count", count + 1);
        return count;
    }

    public static Optional<class_2338> getActivePos(class_1657 playerEntity, class_1799 stack) {
        class_2338 pos = ((AbstractGadget)stack.method_7909()).getAnchor(stack);
        if (pos == null) {
            class_3965 res = VectorHelper.getLookingAt(playerEntity, stack);
            if (res == null || res.method_17783() == class_239.class_240.field_1333) {
                return Optional.empty();
            }
            pos = res.method_17777().method_10093(res.method_17780());
        }
        return Optional.of(pos).map(p -> p.method_10081((class_2382)GadgetCopyPaste.getRelativeVector(stack)));
    }

    public static Optional<Region> getSelectedRegion(class_1799 stack) {
        class_2338 lower = GadgetCopyPaste.getLowerRegionBound(stack);
        class_2338 upper = GadgetCopyPaste.getUpperRegionBound(stack);
        if (lower != null && upper != null) {
            return Optional.of(new Region((class_2382)lower, (class_2382)upper));
        }
        return Optional.empty();
    }

    public static void setSelectedRegion(class_1799 stack, @Nullable Region region) {
        if (region != null) {
            GadgetCopyPaste.setLowerRegionBound(stack, region.getMin());
            GadgetCopyPaste.setUpperRegionBound(stack, region.getMax());
        } else {
            GadgetCopyPaste.setLowerRegionBound(stack, null);
            GadgetCopyPaste.setUpperRegionBound(stack, null);
        }
    }

    public static void setUpperRegionBound(class_1799 stack, @Nullable class_2338 pos) {
        class_2487 nbt = stack.method_7948();
        if (pos != null) {
            nbt.method_10566("start_pos", (class_2520)class_2512.method_10692((class_2338)pos));
        } else {
            nbt.method_10551("start_pos");
        }
    }

    public static void setLowerRegionBound(class_1799 stack, @Nullable class_2338 pos) {
        class_2487 nbt = stack.method_7948();
        if (pos != null) {
            nbt.method_10566("end_pos", (class_2520)class_2512.method_10692((class_2338)pos));
        } else {
            nbt.method_10551("end_pos");
        }
    }

    @Nullable
    public static class_2338 getUpperRegionBound(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (nbt.method_10573("start_pos", 10)) {
            return class_2512.method_10691((class_2487)nbt.method_10562("start_pos"));
        }
        return null;
    }

    @Nullable
    public static class_2338 getLowerRegionBound(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (nbt.method_10573("end_pos", 10)) {
            return class_2512.method_10691((class_2487)nbt.method_10562("end_pos"));
        }
        return null;
    }

    private static void setToolMode(class_1799 stack, ToolMode mode) {
        class_2487 tagCompound = stack.method_7948();
        tagCompound.method_10569("mode", mode.ordinal());
        stack.method_7980(tagCompound);
    }

    public static ToolMode getToolMode(class_1799 stack) {
        class_2487 tagCompound = stack.method_7948();
        return ToolMode.values()[tagCompound.method_10571("mode")];
    }

    @Override
    protected void onAnchorSet(class_1799 stack, class_1657 player, class_3965 lookingAt) {
        super.onAnchorSet(stack, player, new class_3965(lookingAt.method_17784(), lookingAt.method_17780(), lookingAt.method_17777().method_10093(lookingAt.method_17780()), lookingAt.method_17781()));
    }

    public static class_1799 getGadget(class_1657 player) {
        class_1799 stack = AbstractGadget.getGadget(player);
        if (!(stack.method_7909() instanceof GadgetCopyPaste)) {
            return class_1799.field_8037;
        }
        return stack;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, world, tooltip, flag);
        this.addEnergyInformation(tooltip, stack);
        tooltip.add((class_2561)TooltipTranslation.GADGET_MODE.componentTranslation(GadgetCopyPaste.getToolMode((class_1799)stack).translation.format(new Object[0])).method_10862(Styles.AQUA));
        GadgetCopyPaste.addInformationRayTraceFluid(tooltip, stack);
        GadgetUtils.addTooltipNameAndAuthor(stack, world, tooltip);
    }

    public void setMode(class_1799 heldItem, int modeInt) {
        ToolMode mode = ToolMode.values()[modeInt];
        GadgetCopyPaste.setToolMode(heldItem, mode);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        boolean lookingAtInventory;
        class_1799 stack = player.method_5998(hand);
        player.method_6019(hand);
        class_3965 posLookingAt = VectorHelper.getLookingAt(player, stack);
        boolean bl = lookingAtInventory = ItemStorage.SIDED.find(world, posLookingAt.method_17777(), (Object)posLookingAt.method_17780()) != null;
        if (!world.method_8608()) {
            if (player.method_5715() && lookingAtInventory) {
                return class_1271.method_22430((Object)stack);
            }
            if (GadgetCopyPaste.getToolMode(stack) == ToolMode.COPY) {
                if (!world.method_8320(posLookingAt.method_17777()).method_26215()) {
                    this.setRegionAndCopy(stack, world, player, posLookingAt.method_17777());
                }
            } else if (GadgetCopyPaste.getToolMode(stack) == ToolMode.PASTE && !player.method_5715()) {
                GadgetCopyPaste.getActivePos(player, stack).ifPresent(pos -> this.build(stack, world, player, (class_2338)pos, hand));
            }
        } else {
            if (player.method_5715() && class_437.method_25441() && lookingAtInventory) {
                PacketBindTool.send();
                return class_1271.method_22430((Object)stack);
            }
            if (GadgetCopyPaste.getToolMode(stack) == ToolMode.COPY) {
                if (player.method_5715() && world.method_8320(posLookingAt.method_17777()) == class_2246.field_10124.method_9564()) {
                    GuiMod.COPY.openScreen(player);
                }
            } else if (player.method_5715()) {
                GuiMod.PASTE.openScreen(player);
            } else {
                BaseRenderer.updateInventoryCache();
            }
        }
        return class_1271.method_22427((Object)stack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setRegionAndCopy(class_1799 stack, class_1937 world, class_1657 player, class_2338 lookedAt) {
        if (player.method_5715()) {
            bound = GadgetCopyPaste.getLowerRegionBound(stack);
            if (bound != null && !this.checkCopy(world, player, new Region((class_2382)lookedAt, (class_2382)bound))) return;
            GadgetCopyPaste.setUpperRegionBound(stack, lookedAt);
        } else {
            bound = GadgetCopyPaste.getUpperRegionBound(stack);
            if (bound != null && !this.checkCopy(world, player, new Region((class_2382)lookedAt, (class_2382)bound))) return;
            GadgetCopyPaste.setLowerRegionBound(stack, lookedAt);
        }
        Optional<Region> regionOpt = GadgetCopyPaste.getSelectedRegion(stack);
        if (regionOpt.isEmpty()) {
            player.method_7353((class_2561)MessageTranslation.FIRST_COPY.componentTranslation(new Object[0]).method_10862(Styles.DK_GREEN), true);
            return;
        } else {
            this.tryCopy(stack, world, player, regionOpt.get());
        }
    }

    public void tryCopy(class_1799 stack, class_1937 world, class_1657 player, Region region) {
        BuildContext context = BuildContext.builder().player(player).stack(stack).build((class_1936)world);
        WorldBuildView buildView = WorldBuildView.create(context, region, (c, p) -> InventoryHelper.getSafeBlockData(player, p, player.method_6058()));
        this.performCopy(stack, buildView);
    }

    private boolean checkCopy(class_1937 world, class_1657 player, Region region) {
        ImmutableSortedSet<class_1923> unloaded;
        if (!ForceUnloadedCommand.mayForceUnloadedChunks(player) && !(unloaded = region.getUnloadedChunks((class_4538)world)).isEmpty()) {
            player.method_7353((class_2561)MessageTranslation.COPY_UNLOADED.componentTranslation(unloaded.size()).method_10862(Styles.RED), true);
            BuildingGadgets.LOG.debug("Prevented copy because {} chunks where detected as unloaded.", (Object)unloaded.size());
            BuildingGadgets.LOG.trace("The following chunks were detected as unloaded {}.", (Object)CHUNK_JOINER.join(unloaded));
            return false;
        }
        int maxDimension = BuildingGadgets.getConfig().gadgets.gadgetCopyPaste.maxCopySize;
        if (region.getXSize() > 65535 || region.getYSize() > 255 || region.getZSize() > 65535 || (region.getXSize() > maxDimension || region.getYSize() > maxDimension || region.getZSize() > maxDimension) && !OverrideCopySizeCommand.mayPerformLargeCopy(player)) {
            class_2338 sizeVec = region.getMax().method_10059((class_2382)region.getMin());
            player.method_7353((class_2561)MessageTranslation.COPY_TOO_LARGE.componentTranslation(sizeVec.method_10263(), sizeVec.method_10264(), sizeVec.method_10260(), Math.min(maxDimension, 65535), Math.min(maxDimension, 255), Math.min(maxDimension, 65535)).method_10862(Styles.RED), true);
            return false;
        }
        return true;
    }

    private void performCopy(class_1799 stack, WorldBuildView buildView) {
        BuildContext context = buildView.getContext();
        assert (context.getPlayer() != null);
        class_1657 player = context.getPlayer();
        CopyScheduler.scheduleCopy((map, region) -> {
            Template newTemplate = new Template((ImmutableMap<class_2338, BlockData>)map, TemplateHeader.builder(region).name("Copy " + GadgetCopyPaste.getAndIncrementCopyCounter(stack)).author(player.method_5477().getString()).build());
            this.onCopyFinished(newTemplate.normalize(), stack, player);
        }, buildView, BuildingGadgets.getConfig().gadgets.gadgetCopyPaste.copySteps);
    }

    private void onCopyFinished(Template newTemplate, class_1799 stack, class_1657 player) {
        if (!Additions.sizeInvalid(player, newTemplate.getHeader().getBoundingBox())) {
            this.sendMessage(stack, player, MessageTranslation.AREA_COPIED, Styles.DK_GREEN);
        }
        ITemplateKey key = (ITemplateKey)BGComponent.TEMPLATE_KEY_COMPONENT.get((Object)stack);
        BGComponent.TEMPLATE_PROVIDER_COMPONENT.maybeGet((Object)player.field_6002).ifPresent(provider -> {
            provider.setTemplate(key, newTemplate);
            provider.requestRemoteUpdate(key, new Target(class_2598.field_11942, (class_3222)player));
        });
    }

    private void build(class_1799 stack, class_1937 world, class_1657 player, class_2338 pos, class_1268 hand) {
        BGComponent.TEMPLATE_PROVIDER_COMPONENT.maybeGet((Object)world).ifPresent(provider -> BGComponent.TEMPLATE_KEY_COMPONENT.maybeGet((Object)stack).ifPresent(key -> {
            Template template = provider.getTemplateForKey((ITemplateKey)key);
            BuildContext buildContext = BuildContext.builder().stack(stack).player(player).build((class_1936)world);
            IBuildView view = template.createViewInContext(buildContext);
            view.translateTo(pos);
            if (!this.checkPlacement(world, player, view.getBoundingBox())) {
                return;
            }
            this.schedulePlacement(stack, view, player, hand);
        }));
    }

    private boolean checkPlacement(class_1937 world, class_1657 player, Region region) {
        ImmutableSortedSet<class_1923> unloaded;
        if (!ForceUnloadedCommand.mayForceUnloadedChunks(player) && !(unloaded = region.getUnloadedChunks((class_4538)world)).isEmpty()) {
            player.method_7353((class_2561)MessageTranslation.BUILD_UNLOADED.componentTranslation(unloaded.size()).method_10862(Styles.RED), true);
            BuildingGadgets.LOG.debug("Prevented build because {} chunks where detected as unloaded.", (Object)unloaded.size());
            BuildingGadgets.LOG.trace("The following chunks were detected as unloaded {}.", (Object)CHUNK_JOINER.join(unloaded));
            return false;
        }
        int maxDimension = BuildingGadgets.getConfig().gadgets.gadgetCopyPaste.maxBuildSize;
        if (!(region.getXSize() <= maxDimension && region.getYSize() <= maxDimension && region.getZSize() <= maxDimension || OverrideBuildSizeCommand.mayPerformLargeBuild(player))) {
            class_2338 sizeVec = region.getMax().method_10059((class_2382)region.getMin());
            player.method_7353((class_2561)MessageTranslation.BUILD_TOO_LARGE.componentTranslation(sizeVec.method_10263(), sizeVec.method_10264(), sizeVec.method_10260(), maxDimension, maxDimension, maxDimension).method_10862(Styles.RED), true);
            return false;
        }
        return true;
    }

    private void schedulePlacement(class_1799 stack, IBuildView view, class_1657 player, class_1268 hand) {
        class_3218 world = view.getContext().getServerWorld();
        IItemIndex index = InventoryHelper.index(stack, player);
        long energyCost = this.getEnergyCost(stack);
        boolean overwrite = BuildingGadgets.getConfig().general.allowOverwriteBlocks;
        class_1750 useContext = new class_1750(new class_1838(player, class_1268.field_5808, VectorHelper.getLookingAt(player, stack)));
        PlacementChecker checker = new PlacementChecker((EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand)), t -> energyCost, index, (c, t) -> overwrite ? world.method_8320(t.getPos()).method_26166(useContext) && GadgetCopyPaste.mayInteract((class_3222)player, t.getPos()) : world.method_22347(t.getPos()) && GadgetCopyPaste.mayInteract((class_3222)player, t.getPos()));
        PlacementScheduler.schedulePlacement(view, checker, BuildingGadgets.getConfig().gadgets.placeSteps).withFinisher(p -> {
            this.pushUndo(stack, p.getUndoBuilder().build((class_1937)world), (class_1937)world);
            this.onBuildFinished(stack, player, view.getBoundingBox());
        });
    }

    private void onBuildFinished(class_1799 stack, class_1657 player, Region bounds) {
        if (!Additions.sizeInvalid(player, bounds)) {
            this.sendMessage(stack, player, MessageTranslation.TEMPLATE_BUILD, Styles.DK_GREEN);
        }
    }

    private void sendMessage(class_1799 stack, class_1657 player, ITranslationProvider messageSource, class_2583 style) {
        player.method_7353((class_2561)messageSource.componentTranslation(new Object[0]).method_10862(style), true);
    }

    public Optional<class_5632> method_32346(class_1799 itemStack) {
        return Optional.of(new TemplateData(itemStack));
    }

    public static enum ToolMode {
        COPY(ModeTranslation.COPY),
        PASTE(ModeTranslation.PASTE);

        private final ITranslationProvider translation;

        private ToolMode(ITranslationProvider translation) {
            this.translation = translation;
        }

        public ITranslationProvider getTranslation() {
            return this.translation;
        }
    }
}

