/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.modes;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2510;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_3614;

public abstract class AbstractMode {
    private final boolean isExchanging;

    public AbstractMode(boolean isExchanging) {
        this.isExchanging = isExchanging;
    }

    abstract List<class_2338> collect(UseContext var1, class_1657 var2, class_2338 var3);

    public List<class_2338> getCollection(UseContext context, class_1657 player) {
        class_2338 startPos = this.withOffset(context.getStartPos(), context.getHitSide(), context.isPlaceOnTop());
        class_2680 lookingAtState = this.isExchanging() ? context.getWorldState(startPos) : null;
        return this.collect(context, player, startPos).stream().filter(e -> this.isExchanging ? this.exchangingValidator((class_2338)e, lookingAtState, context) : this.validator(player, (class_2338)e, context)).sorted(Comparator.comparing(pos -> player.method_24515().method_10262((class_2382)pos))).collect(Collectors.toList());
    }

    public boolean validator(class_1657 player, class_2338 pos, UseContext context) {
        if (!context.getWorldState(pos).method_26166(context.createBlockUseContext(player))) {
            return false;
        }
        if (context.world.method_31606(pos)) {
            return false;
        }
        return BuildingGadgets.getConfig().general.allowOverwriteBlocks ? context.getWorldState(pos).method_26207().method_15800() : context.getWorldState(pos).method_26207() != class_3614.field_15959;
    }

    private boolean exchangingValidator(class_2338 pos, class_2680 lookingAtState, UseContext context) {
        class_2680 worldBlockState = context.getWorldState(pos);
        class_2586 be = context.getWorld().method_8321(pos);
        if (worldBlockState.method_26207() == class_3614.field_15959 || worldBlockState.method_26207().method_15797()) {
            return false;
        }
        if (worldBlockState == OurBlocks.EFFECT_BLOCK.method_9564() || worldBlockState == context.getSetState()) {
            return false;
        }
        if (be != null && be.method_11010() == context.getSetState()) {
            return false;
        }
        if (worldBlockState.method_26214((class_1922)context.getWorld(), pos) < 0.0f) {
            return false;
        }
        if (worldBlockState.method_26204().method_9564() != lookingAtState.method_26204().method_9564() && !context.isFuzzy()) {
            return false;
        }
        boolean hasSingeValid = false;
        for (class_2350 direction : class_2350.values()) {
            class_2338 offset = pos.method_10093(direction);
            class_2680 state = context.getWorld().method_8320(offset);
            if (!state.method_26215() && (state.method_26218((class_1922)context.getWorld(), offset) == class_259.method_1077() || state.method_26204() instanceof class_2510)) continue;
            hasSingeValid = true;
            break;
        }
        return hasSingeValid;
    }

    public class_2338 withOffset(class_2338 pos, class_2350 side, boolean placeOnTop) {
        return placeOnTop ? pos.method_10079(side, 1) : pos;
    }

    public boolean isExchanging() {
        return this.isExchanging;
    }

    public static class UseContext {
        private final class_1937 world;
        private final class_2680 setState;
        private final class_2338 startPos;
        private final class_2350 hitSide;
        private final boolean isFuzzy;
        private final boolean placeOnTop;
        private final int range;
        private final boolean rayTraceFluid;
        private final boolean isConnected;

        public UseContext(class_1937 world, class_2680 setState, class_2338 startPos, class_1799 gadget, class_2350 hitSide, boolean placeOnTop, boolean isConnected) {
            this.world = world;
            this.setState = setState;
            this.startPos = startPos;
            this.range = GadgetUtils.getToolRange(gadget);
            this.isFuzzy = AbstractGadget.getFuzzy(gadget);
            this.rayTraceFluid = AbstractGadget.shouldRayTraceFluid(gadget);
            this.hitSide = hitSide;
            this.isConnected = isConnected;
            this.placeOnTop = placeOnTop;
        }

        public UseContext(class_1937 world, class_2680 setState, class_2338 startPos, class_1799 gadget, class_2350 hitSide, boolean isConnected) {
            this(world, setState, startPos, gadget, hitSide, false, isConnected);
        }

        public class_1750 createBlockUseContext(class_1657 player) {
            return new class_1750(new class_1838(player, class_1268.field_5808, VectorHelper.getLookingAt(player, this.rayTraceFluid)));
        }

        public boolean isConnected() {
            return this.isConnected;
        }

        public class_2680 getWorldState(class_2338 pos) {
            return this.world.method_8320(pos);
        }

        public class_1937 getWorld() {
            return this.world;
        }

        public class_2680 getSetState() {
            return this.setState;
        }

        public boolean isFuzzy() {
            return this.isFuzzy;
        }

        public boolean isRayTraceFluid() {
            return this.rayTraceFluid;
        }

        public boolean isPlaceOnTop() {
            return this.placeOnTop;
        }

        public int getRange() {
            return this.range;
        }

        public class_2338 getStartPos() {
            return this.startPos;
        }

        public class_2350 getHitSide() {
            return this.hitSide;
        }

        public String toString() {
            return "UseContext{world=" + this.world + ", setState=" + this.setState + ", startPos=" + this.startPos + ", hitSide=" + this.hitSide + ", isFuzzy=" + this.isFuzzy + ", placeOnTop=" + this.placeOnTop + ", range=" + this.range + ", rayTraceFluid=" + this.rayTraceFluid + "}";
        }
    }
}

