/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.building;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_4538;

public final class Region {
    private static final Region ZERO = new Region((class_2382)class_2338.field_10980);
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;

    public static Region singleZero() {
        return ZERO;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder enclosingBuilder() {
        return Region.enclosingBuilder(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public static Builder enclosingBuilder(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new Builder(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static Region deserializeFrom(class_2487 tag) {
        return new Region(tag.method_10550("minX"), tag.method_10550("minY"), tag.method_10550("minZ"), tag.method_10550("maxX"), tag.method_10550("maxY"), tag.method_10550("maxZ"));
    }

    public Region(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = Math.min(minX, maxX);
        this.minY = Math.min(minY, maxY);
        this.minZ = Math.min(minZ, maxZ);
        this.maxX = Math.max(minX, maxX);
        this.maxY = Math.max(minY, maxY);
        this.maxZ = Math.max(minZ, maxZ);
    }

    public Region(class_2382 vertex) {
        this(vertex, vertex);
    }

    public Region(class_2382 min, class_2382 max) {
        this(min.method_10263(), min.method_10264(), min.method_10260(), max.method_10263(), max.method_10264(), max.method_10260());
    }

    public Region translate(int x, int y, int z) {
        return new Region(this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public Region translate(class_2382 direction) {
        return this.translate(direction.method_10263(), direction.method_10264(), direction.method_10260());
    }

    public Region inverseTranslate(class_2382 direction) {
        return this.translate(-direction.method_10263(), -direction.method_10264(), -direction.method_10260());
    }

    public Region grow(int x, int y, int z) {
        return new Region(this.minX, this.minY, this.minZ, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public Region grow(int size) {
        return this.grow(size, size, size);
    }

    public Region shrink(int x, int y, int z) {
        return this.grow(-x, -y, -z);
    }

    public Region shrink(int size) {
        return this.grow(-size);
    }

    public Region expand(int x, int y, int z) {
        return new Region(this.minX - x, this.minY - y, this.minZ - z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public Region expand(class_2382 vec) {
        return this.expand(vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    public Region expand(int size) {
        return this.expand(size, size, size);
    }

    public Region collapse(int x, int y, int z) {
        return this.expand(-x, -y, -z);
    }

    public Region collapse(class_2382 vec) {
        return this.collapse(vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    public Region collapse(int size) {
        return this.expand(-size);
    }

    public Region intersect(Region other) {
        int minX = Math.max(this.minX, other.minX);
        int minY = Math.max(this.minY, other.minY);
        int minZ = Math.max(this.minZ, other.minZ);
        int maxX = Math.min(this.maxX, other.maxX);
        int maxY = Math.min(this.maxY, other.maxY);
        int maxZ = Math.min(this.maxZ, other.maxZ);
        return new Region(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public Region union(Region other) {
        int minX = Math.min(this.minX, other.minX);
        int minY = Math.min(this.minY, other.minY);
        int minZ = Math.min(this.minZ, other.minZ);
        int maxX = Math.max(this.maxX, other.maxX);
        int maxY = Math.max(this.maxY, other.maxY);
        int maxZ = Math.max(this.maxZ, other.maxZ);
        return new Region(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public class_2338 getMin() {
        return new class_2338(this.minX, this.minY, this.minZ);
    }

    public class_2338 getMax() {
        return new class_2338(this.maxX, this.maxY, this.maxZ);
    }

    public int getXSize() {
        return Math.abs(this.maxX - this.minX) + 1;
    }

    public int getYSize() {
        return Math.abs(this.maxY - this.minY) + 1;
    }

    public int getZSize() {
        return Math.abs(this.maxZ - this.minZ) + 1;
    }

    public int size() {
        return this.getXSize() * this.getYSize() * this.getZSize();
    }

    public boolean containsX(int x) {
        return x >= this.minX && x <= this.maxX;
    }

    public boolean containsY(int y) {
        return y >= this.minY && y <= this.maxY;
    }

    public boolean containsZ(int z) {
        return z >= this.minZ && z <= this.maxZ;
    }

    public boolean mayContain(int x, int y, int z) {
        return this.contains(x, y, z);
    }

    public boolean contains(int x, int y, int z) {
        return this.containsX(x) && this.containsY(y) && this.containsZ(z);
    }

    public boolean contains(class_2382 vec) {
        return this.mayContain(vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    public boolean intersectsWith(Region other) {
        return this.maxX >= other.minX && this.minX <= other.maxX && this.maxZ >= other.minZ && this.minZ <= other.maxZ && this.maxY >= other.minY && this.minY <= other.maxY;
    }

    public Stream<class_2338> stream() {
        return class_2338.method_17962((int)this.minX, (int)this.minY, (int)this.minZ, (int)this.maxX, (int)this.maxY, (int)this.maxZ).map(class_2338::method_10062);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("minX", this.minX).add("minY", this.minY).add("minZ", this.minZ).add("maxX", this.maxX).add("maxY", this.maxY).add("maxZ", this.maxZ).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region region = (Region)o;
        return this.minX == region.minX && this.minY == region.minY && this.minZ == region.minZ && this.maxX == region.maxX && this.maxY == region.maxY && this.maxZ == region.maxZ;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public ImmutableSortedSet<class_1923> getUnloadedChunks(class_4538 reader) {
        ImmutableSortedSet.Builder posBuilder = ImmutableSortedSet.orderedBy(Comparator.comparing(class_1923::method_8326).thenComparing(class_1923::method_8328));
        for (int i = this.minX; i <= this.maxX; i += 16) {
            for (int j = this.minZ; j <= this.maxZ; j += 16) {
                if (reader.method_8393(i >> 4, j >> 4)) continue;
                posBuilder.add((Object)new class_1923(i >> 4, j >> 4));
            }
        }
        for (int j = this.minZ; j <= this.maxZ; j += 16) {
            if (reader.method_8393(this.maxX >> 4, j >> 4)) continue;
            posBuilder.add((Object)new class_1923(this.maxX >> 4, j >> 4));
        }
        if (!reader.method_8393(this.maxX >> 4, this.maxZ >> 4)) {
            posBuilder.add((Object)new class_1923(this.maxX >> 4, this.maxZ >> 4));
        }
        return posBuilder.build();
    }

    public class_2487 serialize() {
        return this.serializeTo(new class_2487());
    }

    public class_2487 serializeTo(class_2487 tag) {
        tag.method_10569("minX", this.minX);
        tag.method_10569("minY", this.minY);
        tag.method_10569("minZ", this.minZ);
        tag.method_10569("maxX", this.maxX);
        tag.method_10569("maxY", this.maxY);
        tag.method_10569("maxZ", this.maxZ);
        return tag;
    }

    public static class Builder {
        private int minX;
        private int minY;
        private int minZ;
        private int maxX;
        private int maxY;
        private int maxZ;

        private Builder() {
            this(0, 0, 0, 0, 0, 0);
        }

        public Builder(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        public Builder encloseAll(Iterable<? extends class_2382> iterable) {
            for (class_2382 class_23822 : iterable) {
                this.enclose(class_23822);
            }
            return this;
        }

        public Builder enclose(Region region) {
            this.enclose((class_2382)region.getMin());
            this.enclose((class_2382)region.getMax());
            return this;
        }

        public Builder enclose(class_2382 vec) {
            return this.enclose(vec.method_10263(), vec.method_10264(), vec.method_10260());
        }

        public Builder enclose(int x, int y, int z) {
            this.encloseX(x);
            this.encloseY(y);
            this.encloseZ(z);
            return this;
        }

        public Builder encloseX(int x) {
            this.minX = Math.min(x, this.minX);
            this.maxX = Math.max(x, this.maxX);
            return this;
        }

        public Builder encloseY(int y) {
            this.minY = Math.min(y, this.minY);
            this.maxY = Math.max(y, this.maxY);
            return this;
        }

        public Builder encloseZ(int z) {
            this.minZ = Math.min(z, this.minZ);
            this.maxZ = Math.max(z, this.maxZ);
            return this;
        }

        public Region build() {
            return new Region(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
    }
}

