/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.inventory.materials;

import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialListEntry;
import com.direwolf20.buildinggadgets.common.util.ref.NBTKeys;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.PeekingIterator;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

record SimpleMaterialListEntry(ImmutableMultiset<ItemVariant> items) implements MaterialListEntry<SimpleMaterialListEntry>
{
    static final MaterialListEntry.Serializer<SimpleMaterialListEntry> SERIALIZER = new Serializer();

    SimpleMaterialListEntry(ImmutableMultiset<ItemVariant> items) {
        this.items = Objects.requireNonNull(items, "Cannot have a SimpleMaterialListEntry without any Materials!");
    }

    ImmutableMultiset<ItemVariant> getItems() {
        return this.items;
    }

    @Override
    @NotNull
    public PeekingIterator<ImmutableMultiset<ItemVariant>> iterator() {
        return Iterators.peekingIterator((Iterator)Iterators.singletonIterator(this.items));
    }

    @Override
    public MaterialListEntry.Serializer<SimpleMaterialListEntry> getSerializer() {
        return SERIALIZER;
    }

    public SimpleMaterialListEntry simplify() {
        return this;
    }

    private static class Serializer
    implements MaterialListEntry.Serializer<SimpleMaterialListEntry> {
        private static final Comparator<Multiset.Entry<ItemVariant>> COMPARATOR = Comparator.comparing(e -> class_2378.field_11142.method_10221((Object)((ItemVariant)e.getElement()).getItem())).thenComparingInt(Multiset.Entry::getCount);

        private Serializer() {
        }

        @Override
        public SimpleMaterialListEntry readFromNBT(class_2487 nbt, boolean persisted) {
            class_2499 nbtList = nbt.method_10554("data", 10);
            ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
            for (class_2520 nbtEntry : nbtList) {
                class_2487 compoundEntry = (class_2487)nbtEntry;
                builder.addCopies((Object)ItemVariant.fromNbt((class_2487)compoundEntry.method_10562("data")), compoundEntry.method_10550("count"));
            }
            return new SimpleMaterialListEntry((ImmutableMultiset<ItemVariant>)builder.build());
        }

        @Override
        public class_2487 writeToNBT(SimpleMaterialListEntry listEntry, boolean persisted) {
            class_2487 res = new class_2487();
            class_2499 nbtList = new class_2499();
            for (Multiset.Entry entry : listEntry.getItems().entrySet()) {
                class_2487 nbtEntry = new class_2487();
                nbtEntry.method_10566("data", (class_2520)((ItemVariant)entry.getElement()).toNbt());
                nbtEntry.method_10569("count", entry.getCount());
                nbtList.add((Object)nbtEntry);
            }
            res.method_10566("data", (class_2520)nbtList);
            return res;
        }

        @Override
        public JsonSerializer<SimpleMaterialListEntry> asJsonSerializer() {
            return (src, typeOfSrc, context) -> {
                ImmutableMultiset<ItemVariant> set = src.getItems();
                JsonArray jsonArray = new JsonArray();
                for (Multiset.Entry entry : ImmutableList.sortedCopyOf(COMPARATOR, (Iterable)set.entrySet())) {
                    JsonElement element = (JsonElement)Dynamic.convert((DynamicOps)class_2509.field_11560, (DynamicOps)JsonOps.INSTANCE, (Object)((ItemVariant)entry.getElement()).toNbt());
                    JsonObject obj = new JsonObject();
                    obj.addProperty("count", (Number)entry.getCount());
                    obj.add("item", element);
                    jsonArray.add((JsonElement)obj);
                }
                return jsonArray;
            };
        }

        @Override
        public JsonDeserializer<SimpleMaterialListEntry> asJsonDeserializer() {
            return (json, typeOfT, context) -> {
                JsonArray array = json.getAsJsonArray();
                ImmutableMultiset.Builder items = ImmutableMultiset.builder();
                for (JsonElement element : array) {
                    JsonObject object = element.getAsJsonObject();
                    int count = object.getAsJsonPrimitive("count").getAsInt();
                    ItemVariant item = ItemVariant.fromNbt((class_2487)((class_2487)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)class_2509.field_11560, (Object)object.get("item"))));
                    items.addCopies((Object)item, count);
                }
                return new SimpleMaterialListEntry((ImmutableMultiset<ItemVariant>)items.build());
            };
        }

        @Override
        public class_2960 getRegistryName() {
            return NBTKeys.SIMPLE_SERIALIZER_ID;
        }
    }
}

