/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util;

import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.component.BGComponent;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.network.C2S.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryLinker;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GadgetUtils {
    private static final ImmutableList<class_2248> DISALLOWED_BLOCKS = ImmutableList.of((Object)class_2246.field_10027, (Object)class_2246.field_10316, (Object)class_2246.field_10398, (Object)class_2246.field_9987, (Object)class_2246.field_10260);
    private static final ImmutableList<String> LINK_STARTS = ImmutableList.of((Object)"http", (Object)"www");

    public static boolean mightBeLink(String s) {
        return LINK_STARTS.stream().anyMatch(s::startsWith);
    }

    public static void addTooltipNameAndAuthor(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip) {
        BGComponent.TEMPLATE_PROVIDER_COMPONENT.maybeGet((Object)world).ifPresent(provider -> BGComponent.TEMPLATE_KEY_COMPONENT.maybeGet((Object)stack).ifPresent(key -> {
            Template template = provider.getTemplateForKey((ITemplateKey)key);
            TemplateHeader header = template.getHeader();
            if (header.getName() != null && !header.getName().isEmpty()) {
                tooltip.add((class_2561)TooltipTranslation.TEMPLATE_NAME.componentTranslation(header.getName()).method_10862(Styles.AQUA));
            }
            if (header.getAuthor() != null && !header.getAuthor().isEmpty()) {
                tooltip.add((class_2561)TooltipTranslation.TEMPLATE_AUTHOR.componentTranslation(header.getAuthor()).method_10862(Styles.AQUA));
            }
        }));
    }

    @Nullable
    public static ByteArrayOutputStream getPasteStream(@NotNull class_2487 compound, @Nullable String name) throws IOException {
        class_2487 withText;
        class_2487 class_24872 = withText = name != null && !name.isEmpty() ? compound.method_10553() : compound;
        if (name != null && !name.isEmpty()) {
            withText.method_10582("template_name", name);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        class_2507.method_10634((class_2487)withText, (OutputStream)baos);
        return baos.size() < 32567 ? baos : null;
    }

    public static void setAnchor(class_1799 stack) {
        GadgetUtils.setAnchor(stack, new ArrayList<class_2338>());
    }

    public static void setAnchor(class_1799 stack, List<class_2338> coordinates) {
        class_2487 tagCompound = stack.method_7948();
        tagCompound.method_10566("anchor_coords", (class_2520)coordinates.stream().map(class_2512::method_10692).collect(Collectors.toCollection(class_2499::new)));
        stack.method_7980(tagCompound);
    }

    public static Optional<List<class_2338>> getAnchor(class_1799 stack) {
        class_2487 tagCompound = stack.method_7969();
        if (tagCompound == null) {
            return Optional.empty();
        }
        class_2499 coordList = (class_2499)tagCompound.method_10580("anchor_coords");
        if (coordList == null || coordList.size() == 0) {
            return Optional.empty();
        }
        ArrayList<class_2338> coordinates = new ArrayList<class_2338>();
        for (int i = 0; i < coordList.size(); ++i) {
            coordinates.add(class_2512.method_10691((class_2487)coordList.method_10602(i)));
        }
        return Optional.of(coordinates);
    }

    public static void setToolRange(class_1799 stack, int range) {
        class_2487 tagCompound = stack.method_7948();
        tagCompound.method_10569("range", range);
    }

    public static int getToolRange(class_1799 stack) {
        class_2487 tagCompound = stack.method_7948();
        return class_3532.method_15340((int)tagCompound.method_10550("range"), (int)1, (int)15);
    }

    public static BlockData rotateOrMirrorBlock(class_1657 player, PacketRotateMirror.Operation operation, BlockData data) {
        if (operation == PacketRotateMirror.Operation.MIRROR) {
            return data.mirror(player.method_5735().method_10166() == class_2350.class_2351.field_11048 ? class_2415.field_11300 : class_2415.field_11301);
        }
        return data.rotate(class_2470.field_11463);
    }

    public static void rotateOrMirrorToolBlock(class_1799 stack, class_1657 player, PacketRotateMirror.Operation operation) {
        GadgetUtils.setToolBlock(stack, GadgetUtils.rotateOrMirrorBlock(player, operation, GadgetUtils.getToolBlock(stack)));
    }

    private static void setToolBlock(class_1799 stack, @Nullable BlockData data) {
        class_2487 tagCompound = stack.method_7948();
        if (data == null) {
            data = BlockData.AIR;
        }
        class_2487 stateTag = data.serialize(true);
        tagCompound.method_10566("state", (class_2520)stateTag);
        stack.method_7980(tagCompound);
    }

    @NotNull
    public static BlockData getToolBlock(class_1799 stack) {
        class_2487 tagCompound = stack.method_7948();
        BlockData res = BlockData.tryDeserialize(tagCompound.method_10562("state"), true);
        if (res == null) {
            GadgetUtils.setToolBlock(stack, BlockData.AIR);
            return BlockData.AIR;
        }
        return res;
    }

    public static void linkToInventory(class_1799 stack, class_1657 player) {
        class_1937 world = player.field_6002;
        class_3965 lookingAt = VectorHelper.getLookingAt(player, AbstractGadget.shouldRayTraceFluid(stack) ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348);
        if (world.method_8320(VectorHelper.getLookingAt(player, stack).method_17777()) == class_2246.field_10124.method_9564()) {
            return;
        }
        InventoryLinker.Result result = InventoryLinker.linkInventory(player.field_6002, stack, lookingAt);
        player.method_7353((class_2561)result.i18n().componentTranslation(new Object[0]), true);
    }

    public static class_1271<class_2248> selectBlock(class_1799 stack, class_1657 player) {
        class_1937 world = player.field_6002;
        class_3965 lookingAt = VectorHelper.getLookingAt(player, AbstractGadget.shouldRayTraceFluid(stack) ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348);
        if (world.method_22347(lookingAt.method_17777())) {
            return class_1271.method_22431((Object)class_2246.field_10124);
        }
        class_2680 state = world.method_8320(lookingAt.method_17777());
        if (!((AbstractGadget)stack.method_7909()).isAllowedBlock(state.method_26204()) || state.method_26204() instanceof EffectBlock) {
            return class_1271.method_22431((Object)state.method_26204());
        }
        if (DISALLOWED_BLOCKS.contains((Object)state.method_26204())) {
            return class_1271.method_22431((Object)state.method_26204());
        }
        if (state.method_26214((class_1922)world, lookingAt.method_17777()) < 0.0f) {
            return class_1271.method_22431((Object)state.method_26204());
        }
        Optional<BlockData> data = InventoryHelper.getSafeBlockData(player, lookingAt.method_17777(), player.method_6058());
        data.ifPresent(placeState -> {
            class_2680 actualState = placeState.getState();
            GadgetUtils.setToolBlock(stack, new BlockData(actualState, placeState.getTileData()));
        });
        return class_1271.method_22427((Object)state.method_26204());
    }

    public static class_1269 setRemoteInventory(class_1799 stack, class_1657 player, class_1937 world, class_2338 pos, boolean setTool) {
        class_2586 be = world.method_8321(pos);
        if (be == null) {
            return class_1269.field_5811;
        }
        return class_1269.field_5814;
    }

    public static boolean anchorBlocks(class_1657 player, class_1799 stack) {
        Optional<List<class_2338>> anchorCoords = GadgetUtils.getAnchor(stack);
        if (anchorCoords.isPresent()) {
            GadgetUtils.setAnchor(stack);
            player.method_7353((class_2561)MessageTranslation.ANCHOR_REMOVED.componentTranslation(new Object[0]).method_10862(Styles.AQUA), true);
            return true;
        }
        class_3965 lookingAt = VectorHelper.getLookingAt(player, stack);
        class_2338 startBlock = lookingAt.method_17777();
        class_2350 sideHit = lookingAt.method_17780();
        if (player.field_6002.method_22347(startBlock)) {
            return false;
        }
        BlockData blockData = GadgetUtils.getToolBlock(stack);
        AbstractMode.UseContext context = new AbstractMode.UseContext(player.field_6002, blockData.getState(), startBlock, stack, sideHit, stack.method_7909() instanceof GadgetBuilding && GadgetBuilding.shouldPlaceAtop(stack), GadgetBuilding.getConnectedArea(stack));
        List<class_2338> coords = stack.method_7909() instanceof GadgetBuilding ? GadgetBuilding.getToolMode(stack).getMode().getCollection(context, player) : GadgetExchanger.getToolMode(stack).getMode().getCollection(context, player);
        GadgetUtils.setAnchor(stack, coords);
        player.method_7353((class_2561)MessageTranslation.ANCHOR_SET.componentTranslation(new Object[0]).method_10862(Styles.AQUA), true);
        return true;
    }

    public static String withSuffix(int count) {
        if (count < 1000) {
            return "" + count;
        }
        int exp = (int)(Math.log(count) / Math.log(1000.0));
        return String.format("%.1f%c", (double)count / Math.pow(1000.0, exp), Character.valueOf("kMGTPE".charAt(exp - 1)));
    }

    public static void writePOSToNBT(class_1799 stack, @Nullable class_2338 pos, String tagName) {
        class_2487 tagCompound = stack.method_7948();
        if (pos == null) {
            if (tagCompound.method_10580(tagName) != null) {
                tagCompound.method_10551(tagName);
                stack.method_7980(tagCompound);
            }
            return;
        }
        tagCompound.method_10566(tagName, (class_2520)class_2512.method_10692((class_2338)pos));
        stack.method_7980(tagCompound);
    }

    @Nullable
    public static class_2338 getPOSFromNBT(class_1799 stack, String tagName) {
        class_2487 stackTag = stack.method_7948();
        if (!stackTag.method_10545(tagName)) {
            return null;
        }
        class_2487 posTag = stack.method_7948().method_10562(tagName);
        if (posTag.method_33133()) {
            return null;
        }
        return class_2512.method_10691((class_2487)posTag);
    }
}

