/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.tools;

import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;

public final class MathUtils {
    public static final int B1_BYTE_MASK = 255;
    public static final int B2_BYTE_MASK = 65535;
    public static final int B3_BYTE_MASK = 0xFFFFFF;
    public static final long B5_BYTE_MASK = -1L;

    private MathUtils() {
    }

    public static short additiveInverse(short num) {
        return -num;
    }

    public static long posToLong(class_2338 pos) {
        long res = (long)(pos.method_10263() & 0xFFFF) << 24;
        res |= (long)((pos.method_10264() & 0xFF) << 16);
        return res |= (long)(pos.method_10260() & 0xFFFF);
    }

    public static class_2338 posFromLong(long serialized) {
        int x = (int)(serialized >> 24 & 0xFFFFL);
        int y = (int)(serialized >> 16 & 0xFFL);
        int z = (int)(serialized & 0xFFFFL);
        return new class_2338(x, y, z);
    }

    public static long includeStateId(long serialized, int id) {
        return serialized | (long)(id & 0xFFFFFF) << 40;
    }

    public static int readStateId(long serialized) {
        return (int)(serialized >> 40 & 0xFFFFFFL);
    }

    public static long readSerializedPos(long serialized) {
        return serialized & 0xFFFFFFFFFFFFFFFFL;
    }

    public static int floorMultiple(int i, int factor) {
        return i - i % factor;
    }

    public static int ceilMultiple(int i, int factor) {
        return i + i % factor;
    }

    public static boolean isEven(int i) {
        return (i & 1) == 0;
    }

    public static boolean isOdd(int i) {
        return i % 2 == 1;
    }

    private static int addForNonEven(int i, int c) {
        return MathUtils.isEven(i) ? i : i + c;
    }

    private static int addForNonOdd(int i, int c) {
        return MathUtils.isOdd(i) ? i : i + c;
    }

    public static int floorToEven(int i) {
        return MathUtils.addForNonEven(i, -1);
    }

    public static int floorToOdd(int i) {
        return MathUtils.addForNonOdd(i, -1);
    }

    public static int ceilToEven(int i) {
        return MathUtils.addForNonEven(i, 1);
    }

    public static int ceilToOdd(int i) {
        return MathUtils.addForNonOdd(i, 1);
    }

    private static int sineForRotation(class_2470 rot) {
        return switch (rot) {
            case class_2470.field_11467, class_2470.field_11464 -> 0;
            case class_2470.field_11463 -> 1;
            case class_2470.field_11465 -> -1;
            default -> throw new AssertionError();
        };
    }

    private static int cosineForRotation(class_2470 rot) {
        return MathUtils.sineForRotation(rot.method_10501(class_2470.field_11463));
    }

    public static int[][] rotationMatrixFor(class_2350.class_2351 axis, class_2470 rotation) {
        int[][] matrix = new int[3][3];
        switch (axis) {
            case field_11048: {
                matrix[0][0] = 1;
                matrix[1][1] = MathUtils.cosineForRotation(rotation);
                matrix[1][2] = MathUtils.sineForRotation(rotation);
                matrix[2][1] = -MathUtils.sineForRotation(rotation);
                matrix[2][2] = MathUtils.cosineForRotation(rotation);
                break;
            }
            case field_11052: {
                matrix[1][1] = 1;
                matrix[0][0] = MathUtils.cosineForRotation(rotation);
                matrix[2][0] = MathUtils.sineForRotation(rotation);
                matrix[0][2] = -MathUtils.sineForRotation(rotation);
                matrix[2][2] = MathUtils.cosineForRotation(rotation);
                break;
            }
            case field_11051: {
                matrix[2][2] = 1;
                matrix[0][0] = MathUtils.cosineForRotation(rotation);
                matrix[0][1] = MathUtils.sineForRotation(rotation);
                matrix[1][0] = -MathUtils.sineForRotation(rotation);
                matrix[1][1] = MathUtils.cosineForRotation(rotation);
            }
        }
        return matrix;
    }

    public static class_2338 matrixMul(int[][] matrix, class_2338 pos) {
        int x = pos.method_10263() * matrix[0][0] + pos.method_10264() * matrix[0][1] + pos.method_10260() * matrix[0][2];
        int y = pos.method_10263() * matrix[1][0] + pos.method_10264() * matrix[1][1] + pos.method_10260() * matrix[1][2];
        int z = pos.method_10263() * matrix[2][0] + pos.method_10264() * matrix[2][1] + pos.method_10260() * matrix[2][2];
        return new class_2338(x, y, z);
    }
}

