/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.data.condition.AndResourceCondition;
import com.supermartijn642.core.data.condition.ModLoadedResourceCondition;
import com.supermartijn642.core.data.condition.NotResourceCondition;
import com.supermartijn642.core.data.condition.OrResourceCondition;
import com.supermartijn642.core.data.condition.TagPopulatedResourceCondition;
import com.supermartijn642.core.data.recipe.ConditionalRecipeSerializer;
import com.supermartijn642.core.data.tag.CustomTagEntries;
import com.supermartijn642.core.data.tag.entries.NamespaceTagEntry;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.standard.CoreLibAccessWidenerGenerator;
import com.supermartijn642.core.generator.standard.CoreLibMiningTagGenerator;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;

public class CoreLib
implements ModInitializer {
    public static final Logger LOGGER = CommonUtils.getLogger("supermartijn642corelib");
    public static boolean isArchitecturyLoaded = false;

    public void onInitialize() {
        isArchitecturyLoaded = CommonUtils.isModLoaded("architectury");
        CommonUtils.initialize();
        CustomTagEntries.init();
        RegistrationHandler handler = RegistrationHandler.get("supermartijn642corelib");
        handler.registerRecipeSerializer("conditional", ConditionalRecipeSerializer.INSTANCE);
        handler.registerResourceConditionSerializer("mod_loaded", ModLoadedResourceCondition.SERIALIZER);
        handler.registerResourceConditionSerializer("not", NotResourceCondition.SERIALIZER);
        handler.registerResourceConditionSerializer("or", OrResourceCondition.SERIALIZER);
        handler.registerResourceConditionSerializer("and", AndResourceCondition.SERIALIZER);
        handler.registerResourceConditionSerializer("tag_populated", TagPopulatedResourceCondition.SERIALIZER);
        handler.registerCustomTagEntrySerializer("namespace", NamespaceTagEntry.SERIALIZER);
        GeneratorRegistrationHandler.get("supermartijn642corelib").addGenerator(cache -> new CoreLibMiningTagGenerator("supermartijn642corelib", (ResourceCache)cache));
        GeneratorRegistrationHandler.get("supermartijn642corelib").addGenerator(cache -> new CoreLibAccessWidenerGenerator("supermartijn642corelib", (ResourceCache)cache));
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            ModInitializer testMod = null;
            try {
                Class<?> testModClass = Class.forName("com.supermartijn642.core.test.TestMod");
                testMod = (ModInitializer)testModClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (testMod != null) {
                testMod.onInitialize();
            }
        }
    }

    public static void beforeInitialize() {
        RegistryEntryAcceptor.Handler.gatherAnnotatedFields();
    }

    public static void afterInitialize() {
        RegistrationHandler.registerInternal();
        RegistryEntryAcceptor.Handler.reportMissing();
    }

    public static void afterInitializeClient() {
        ClientRegistrationHandler.registerRenderersInternal();
    }

    public static void afterInitializeAll() {
    }
}

