/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core;

import com.supermartijn642.core.ClientUtils;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.class_1076;

public class EnergyFormat {
    private static EnergyType type = EnergyType.RF;

    public static void cycleEnergyType(boolean forward) {
        type = EnergyType.values()[(type.ordinal() + (forward ? 1 : EnergyType.values().length - 1)) % EnergyType.values().length];
    }

    public static String formatEnergy(int energy) {
        return type.convertEnergy(energy);
    }

    public static String formatEnergyWithUnit(int energy) {
        return EnergyFormat.formatEnergy(energy) + " " + EnergyFormat.formatUnit();
    }

    public static String formatEnergyPerTick(int energy) {
        return EnergyFormat.formatEnergy(energy) + " " + EnergyFormat.formatUnitPerTick();
    }

    public static String formatCapacity(int energy, int capacity) {
        return EnergyFormat.formatEnergy(energy) + " / " + EnergyFormat.formatEnergy(capacity);
    }

    public static String formatCapacityWithUnit(int energy, int capacity) {
        return EnergyFormat.formatCapacity(energy, capacity) + " " + EnergyFormat.formatUnit();
    }

    public static String formatUnit() {
        return type.getUnit();
    }

    public static String formatUnitPerTick() {
        return EnergyFormat.type.unit + "/t";
    }

    private static enum EnergyType {
        FE("FE"),
        RF("RF");

        private final String unit;

        private EnergyType(String unit) {
            this.unit = unit;
        }

        public String getUnit() {
            return this.unit;
        }

        public String convertEnergy(int energy) {
            String[] languageCode;
            class_1076 manager = ClientUtils.getMinecraft().method_1526();
            String[] stringArray = languageCode = manager == null || manager.method_4669() == null ? null : manager.method_4669().getCode().split("_", 2);
            Locale locale = languageCode == null ? Locale.getDefault() : (languageCode.length == 1 ? new Locale(languageCode[0]) : new Locale(languageCode[0], languageCode[1]));
            return NumberFormat.getNumberInstance(locale).format(energy);
        }
    }
}

