/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.BlackboardManager;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;

public class BlackboardBakedModel
implements CustomBakedModel {
    private final Function<class_4730, class_1058> spriteGetter;
    private final class_3665 modelTransform;
    private final class_1087 back;
    private final class_793 owner;

    public BlackboardBakedModel(class_793 owner, class_1087 baked, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform) {
        this.back = baked;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.owner = owner;
    }

    public boolean method_4708() {
        return true;
    }

    public boolean method_4712() {
        return false;
    }

    public boolean method_24304() {
        return false;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 getBlockParticle(ExtraModelData data) {
        return this.back.method_4711();
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }

    public class_809 method_4709() {
        return class_809.field_4301;
    }

    public List<class_777> getBlockQuads(class_2680 state, class_2350 side, class_5819 rand, class_1921 renderType, ExtraModelData data) {
        ArrayList<class_777> quads = new ArrayList<class_777>(this.back.method_4707(state, side, rand));
        if (data != ExtraModelData.EMPTY && state != null && side == null) {
            class_2350 dir = (class_2350)state.method_11654((class_2769)BlackboardBlock.FACING);
            BlackboardManager.Key key = (BlackboardManager.Key)data.get(BlackboardBlockTile.BLACKBOARD_KEY);
            if (key != null) {
                BlackboardManager.Blackboard blackboard = BlackboardManager.getInstance(key);
                quads.addAll(blackboard.getOrCreateModel(dir, this::generateQuads));
            }
        }
        return quads;
    }

    private List<class_777> generateQuads(BlackboardManager.Blackboard blackboard, class_2350 dir) {
        ArrayList<class_777> quads;
        byte[][] pixels = blackboard.getPixels();
        boolean emissive = blackboard.isGlow();
        try (class_1058 black = this.spriteGetter.apply(this.owner.method_24077("black"));
             class_1058 white = this.spriteGetter.apply(this.owner.method_24077("white"));){
            quads = new ArrayList<class_777>();
            class_4590 rotation = this.modelTransform.method_3509();
            for (int x = 0; x < pixels.length; ++x) {
                int length = 0;
                int startY = 0;
                byte prevColor = pixels[0][x];
                for (int y = 0; y <= pixels[x].length; ++y) {
                    Byte current = null;
                    if (y < pixels[x].length) {
                        byte b = pixels[x][y];
                        if (prevColor == b) {
                            ++length;
                            continue;
                        }
                        current = b;
                    }
                    int tint = 0xFF000000 | BlackboardBlock.colorFromByte(prevColor);
                    class_1058 sprite = prevColor == 0 ? black : white;
                    quads.add(BlackboardBakedModel.createPixelQuad((float)(15 - x) / 16.0f, (float)(16 - length - startY) / 16.0f, 0.6875f, 0.0625f, (float)length / 16.0f, sprite, tint, rotation, prevColor != 0 && emissive, dir));
                    startY = y;
                    if (current != null) {
                        prevColor = current;
                    }
                    length = 1;
                }
            }
        }
        return quads;
    }

    public static class_777 createPixelQuad(float x, float y, float z, float width, float height, class_1058 sprite, int color, class_4590 transform, boolean litUp, class_2350 dd) {
        float tu = 1.0f - (1.0f + (float)sprite.method_4578() * width);
        float tv = 1.0f - (1.0f + (float)sprite.method_4595() * height);
        float u0 = (1.0f - x) * 16.0f;
        float v0 = (1.0f - y) * 16.0f;
        BakedQuadBuilder builder = BakedQuadBuilder.create((class_1058)sprite);
        builder.setDirection(dd);
        class_1160 normal = new class_1160((float)dd.method_10148(), (float)dd.method_10164(), (float)dd.method_10165());
        BlackboardBakedModel.putVertex(builder, normal, x + width, y + height, z, u0 + tu, v0 + tv, sprite, color, transform, litUp);
        BlackboardBakedModel.putVertex(builder, normal, x + width, y, z, u0 + tu, v0, sprite, color, transform, litUp);
        BlackboardBakedModel.putVertex(builder, normal, x, y, z, u0, v0, sprite, color, transform, litUp);
        BlackboardBakedModel.putVertex(builder, normal, x, y + height, z, u0, v0 + tv, sprite, color, transform, litUp);
        return builder.build();
    }

    private static void putVertex(BakedQuadBuilder builder, class_1160 normal, float x, float y, float z, float u, float v, class_1058 sprite, int color, class_4590 transformation, boolean emissive) {
        class_1160 posV = RotHlpr.rotateVertexOnCenterBy((float)x, (float)y, (float)z, (class_1159)transformation.method_22936());
        posV.method_4949((float)Math.round(posV.method_4943() * 16.0f) / 16.0f, (float)Math.round(posV.method_4945() * 16.0f) / 16.0f, (float)Math.round(posV.method_4947() * 16.0f) / 16.0f);
        builder.method_22912((double)posV.method_4943(), (double)posV.method_4945(), (double)posV.method_4947());
        builder.method_39415(color);
        builder.method_22913(sprite.method_4580((double)u), sprite.method_4570((double)v));
        builder.method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947());
        if (emissive) {
            builder.lightEmission(15);
        }
        builder.method_1344();
    }
}

