/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.api.IAntiqueTextProvider;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_327;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class TextHolder
implements IAntiqueTextProvider {
    private final int lines;
    private final class_2561[] textLines;
    private final class_5481[] renderText;
    private final int maxWidth;
    private class_1767 color = class_1767.field_7963;
    private boolean hasGlowingText = false;
    private boolean hasAntiqueInk = false;

    public TextHolder(int size, int maxWidth) {
        this.lines = size;
        this.maxWidth = maxWidth;
        this.renderText = new class_5481[size];
        this.textLines = new class_2561[size];
        Arrays.fill(this.textLines, class_5244.field_39003);
    }

    public int getMaxLineCharacters() {
        return (int)((float)this.getMaxLineVisualWidth() / 6.0f);
    }

    public int getMaxLineVisualWidth() {
        return this.maxWidth;
    }

    public void load(class_2487 compound) {
        if (compound.method_10545("TextHolder")) {
            class_2487 com = compound.method_10562("TextHolder");
            this.color = class_1767.method_7793((String)com.method_10558("Color"), (class_1767)class_1767.field_7963);
            this.hasGlowingText = com.method_10577("GlowingText");
            this.hasAntiqueInk = com.method_10577("AntiqueInk");
            for (int i = 0; i < this.lines; ++i) {
                class_2561 mutableComponent;
                String s = com.method_10558("Text" + (i + 1));
                this.textLines[i] = mutableComponent = s.isEmpty() ? class_5244.field_39003 : class_2561.class_2562.method_10877((String)s);
                this.renderText[i] = null;
            }
        }
    }

    public class_2487 save(class_2487 compound) {
        class_2487 com = new class_2487();
        com.method_10582("Color", this.color.method_7792());
        com.method_10556("GlowingText", this.hasGlowingText);
        com.method_10556("AntiqueInk", this.hasAntiqueInk);
        for (int i = 0; i < this.lines; ++i) {
            String s = class_2561.class_2562.method_10867((class_2561)this.textLines[i]);
            com.method_10582("Text" + (i + 1), s);
        }
        compound.method_10566("TextHolder", (class_2520)com);
        return compound;
    }

    public int size() {
        return this.lines;
    }

    public class_2561 getLine(int line) {
        return this.textLines[line];
    }

    public void setLine(int line, class_2561 text) {
        class_5250 t = text.method_27661();
        if (this.hasAntiqueInk) {
            t.method_10862(text.method_10866().method_27704(ModTextures.ANTIQUABLE_FONT));
        }
        this.textLines[line] = t;
        this.renderText[line] = null;
    }

    @Deprecated
    public void setLine(int line, class_2561 text, class_2583 style) {
        this.setLine(line, text);
    }

    public class_2561[] getTextLines() {
        return this.textLines;
    }

    public class_1767 getColor() {
        return this.color;
    }

    public boolean setTextColor(class_1767 newColor) {
        if (newColor != this.color) {
            this.color = newColor;
            return true;
        }
        return false;
    }

    public boolean hasGlowingText() {
        return this.hasGlowingText;
    }

    public void setGlowingText(boolean glowing) {
        this.hasGlowingText = glowing;
    }

    public class_1269 playerInteract(class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_2586 tile) {
        if (Utils.mayBuild((class_1657)player, (class_2338)pos)) {
            class_1799 stack = player.method_5998(hand);
            class_1792 item = stack.method_7909();
            boolean success = false;
            if (item == class_1802.field_8794) {
                if (this.hasGlowingText || this.hasAntiqueInk) {
                    level.method_8396(null, pos, class_3417.field_28397, class_3419.field_15245, 1.0f, 1.0f);
                    this.setAntiqueInk(false);
                    this.hasGlowingText = false;
                    success = true;
                }
            } else if (item == ModRegistry.ANTIQUE_INK.get()) {
                if (!this.hasAntiqueInk) {
                    level.method_8396(null, pos, class_3417.field_28392, class_3419.field_15245, 1.0f, 1.0f);
                    this.setAntiqueInk(true);
                    success = true;
                }
            } else if (item == class_1802.field_28410) {
                if (!this.hasGlowingText) {
                    level.method_8396(null, pos, class_3417.field_28392, class_3419.field_15245, 1.0f, 1.0f);
                    this.hasGlowingText = true;
                    success = true;
                }
            } else {
                class_1767 dyeColor = ForgeHelper.getColor((class_1799)stack);
                if (dyeColor != null && this.setTextColor(dyeColor)) {
                    level.method_8396(null, pos, class_3417.field_28391, class_3419.field_15245, 1.0f, 1.0f);
                    success = true;
                }
            }
            if (success) {
                if (!player.method_7337()) {
                    stack.method_7934(1);
                }
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_174.field_24478.method_23889(serverPlayer, pos, stack);
                    tile.method_5431();
                    level.method_8413(pos, tile.method_11010(), tile.method_11010(), 3);
                }
                return class_1269.method_29236((boolean)level.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    @Override
    public boolean hasAntiqueInk() {
        return this.hasAntiqueInk;
    }

    @Override
    public void setAntiqueInk(boolean hasInk) {
        this.hasAntiqueInk = hasInk;
        for (int i = 0; i < this.textLines.length; ++i) {
            this.setLine(i, this.textLines[i]);
        }
    }

    public void clearEffects() {
        this.setTextColor(class_1767.field_7963);
        this.setAntiqueInk(false);
        this.setGlowingText(false);
    }

    public boolean isEmpty() {
        return Arrays.stream(this.textLines).allMatch(s -> s.getString().isEmpty());
    }

    public void clear() {
        Arrays.fill(this.textLines, class_5244.field_39003);
        this.clearEffects();
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public class_5481 getAndPrepareTextForRenderer(class_327 font, int line) {
        if (this.renderText[line] == null && this.textLines[line] != class_5244.field_39003) {
            List list = font.method_1728((class_5348)this.textLines[line], this.getMaxLineVisualWidth());
            this.renderText[line] = list.isEmpty() ? class_5481.field_26385 : (class_5481)list.get(0);
        }
        return this.renderText[line];
    }

    @Environment(value=EnvType.CLIENT)
    public TextUtil.RenderTextProperties getRenderTextProperties(int combinedLight, Supplier<Boolean> shouldShowGlow) {
        return new TextUtil.RenderTextProperties(this.getColor(), this.hasGlowingText(), combinedLight, this.hasAntiqueInk() ? class_2583.field_24360.method_27704(ModTextures.ANTIQUABLE_FONT) : class_2583.field_24360, shouldShowGlow);
    }

    @Environment(value=EnvType.CLIENT)
    public TextUtil.RenderTextProperties getGUIRenderTextProperties() {
        return this.getRenderTextProperties(0xF000F0, () -> true);
    }
}

