/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.GlobeBlock;
import net.mehvahdjukaar.supplementaries.common.utils.Credits;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1275;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class GlobeBlockTile
extends class_2586
implements class_1275 {
    private final boolean sepia;
    private boolean sheared = false;
    private int face = 0;
    private class_2561 customName;
    private float yaw = 0.0f;
    private float prevYaw = 0.0f;
    private Pair<GlobeModel, @Nullable class_2960> renderData = Pair.of((Object)((Object)GlobeModel.GLOBE), null);

    public GlobeBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.GLOBE_TILE.get(), pos, state);
        this.sepia = state.method_27852(ModRegistry.GLOBE_SEPIA.get());
    }

    public int getFace() {
        return this.face;
    }

    public float getRotation(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)(this.prevYaw + (float)this.face), (float)(this.yaw + (float)this.face));
    }

    public Pair<GlobeModel, class_2960> getRenderData() {
        return this.renderData;
    }

    public boolean isSepia() {
        return this.sepia;
    }

    public void setCustomName(class_2561 name) {
        this.customName = name;
        this.updateRenderData();
    }

    public void toggleShearing() {
        this.sheared = !this.sheared;
        this.updateRenderData();
    }

    private void updateRenderData() {
        this.renderData = this.sheared ? Pair.of((Object)((Object)GlobeModel.SHEARED), (Object)(this.sepia ? ModTextures.GLOBE_SHEARED_SEPIA_TEXTURE : ModTextures.GLOBE_SHEARED_TEXTURE)) : (this.method_16914() ? GlobeType.getModelAndTexture(this.method_5797().getString()) : Pair.of((Object)((Object)GlobeModel.GLOBE), null));
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public class_2561 method_5797() {
        return this.customName;
    }

    public class_2561 getDefaultName() {
        return class_2561.method_43471((String)"block.supplementaries.globe");
    }

    public void method_11014(class_2487 compound) {
        if (compound.method_10573("CustomName", 8)) {
            this.setCustomName((class_2561)class_2561.class_2562.method_10877((String)compound.method_10558("CustomName")));
        }
        this.face = compound.method_10550("Face");
        this.yaw = compound.method_10583("Yaw");
        this.sheared = compound.method_10577("Sheared");
        super.method_11014(compound);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.customName != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        tag.method_10569("Face", this.face);
        tag.method_10548("Yaw", this.yaw);
        tag.method_10556("Sheared", this.sheared);
    }

    public void spin() {
        int spin = 360;
        int inc = 90;
        this.face = (this.face - inc) % 360;
        this.yaw = this.yaw + (float)spin + (float)inc;
        this.prevYaw = this.prevYaw + (float)spin + (float)inc;
        this.method_5431();
    }

    public boolean method_11004(int id, int type) {
        if (id == 1) {
            this.spin();
            this.field_11863.method_8396(null, this.field_11867, ModSounds.GLOBE_SPIN.get(), class_3419.field_15245, 0.65f, MthUtils.nextWeighted((class_5819)this.field_11863.field_9229, (float)0.2f) + 0.9f);
            return true;
        }
        return super.method_11004(id, type);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public static void tick(class_1937 pLevel, class_2338 pPos, class_2680 pState, GlobeBlockTile tile) {
        tile.prevYaw = tile.yaw;
        if (tile.yaw != 0.0f) {
            if (tile.yaw < 0.0f) {
                tile.yaw = 0.0f;
                pLevel.method_8455(pPos, pState.method_26204());
            } else {
                tile.yaw = tile.yaw * 0.94f - 0.7f;
            }
        }
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)GlobeBlock.FACING);
    }

    public boolean isSpinningVeryFast() {
        return this.yaw > 1500.0f;
    }

    public int getSignalPower() {
        if (this.yaw != 0.0f) {
            return 15;
        }
        return this.face / -90 + 1;
    }

    public static enum GlobeModel {
        GLOBE,
        FLAT,
        SNOW,
        SHEARED;

    }

    public static enum GlobeType {
        FLAT(new String[]{"flat", "flat earth"}, (class_2561)class_2561.method_43471((String)"globe.supplementaries.flat"), ModTextures.GLOBE_FLAT_TEXTURE),
        MOON(new String[]{"moon", "luna", "selene", "cynthia"}, (class_2561)class_2561.method_43471((String)"globe.supplementaries.moon"), ModTextures.GLOBE_MOON_TEXTURE),
        EARTH(new String[]{"earth", "terra", "gaia", "gaea", "tierra", "tellus", "terre"}, (class_2561)class_2561.method_43471((String)"globe.supplementaries.earth"), ModTextures.GLOBE_TEXTURE),
        SUN(new String[]{"sun", "sol", "helios"}, (class_2561)class_2561.method_43471((String)"globe.supplementaries.sun"), ModTextures.GLOBE_SUN_TEXTURE);

        private final String[] keyWords;
        public final class_2561 transKeyWord;
        public final class_2960 texture;
        private static final Map<String, Pair<GlobeModel, class_2960>> nameCache;
        private static final Map<String, Integer> idMap;
        public static final List<class_2960> textures;

        private GlobeType(String[] key, class_2561 tr, class_2960 res) {
            this.keyWords = key;
            this.transKeyWord = tr;
            this.texture = res;
        }

        public static void recomputeCache() {
            nameCache.clear();
            for (GlobeType type : GlobeType.values()) {
                GlobeModel model = type == FLAT ? GlobeModel.FLAT : GlobeModel.GLOBE;
                Pair pair = Pair.of((Object)((Object)model), (Object)type.texture);
                if (type.transKeyWord != null && !type.transKeyWord.getString().equals("")) {
                    nameCache.put(type.transKeyWord.getString().toLowerCase(Locale.ROOT), (Pair<GlobeModel, class_2960>)pair);
                }
                for (String s : type.keyWords) {
                    if (s.equals("")) continue;
                    nameCache.put(s, (Pair<GlobeModel, class_2960>)pair);
                }
            }
            for (Map.Entry entry : Credits.INSTANCE.globes().entrySet()) {
                class_2960 path = (class_2960)entry.getValue();
                GlobeModel model = GlobeModel.GLOBE;
                if (path.method_12832().contains("globe_wais")) {
                    model = GlobeModel.SNOW;
                }
                nameCache.put((String)entry.getKey(), (Pair<GlobeModel, class_2960>)Pair.of((Object)((Object)model), (Object)path));
            }
            textures.clear();
            nameCache.values().forEach(o -> {
                if (!textures.contains(o.getSecond())) {
                    textures.add((class_2960)o.getSecond());
                }
            });
            Collections.sort(textures);
            idMap.clear();
            nameCache.forEach((key, value) -> idMap.put((String)key, textures.indexOf(value.getSecond())));
        }

        @Nullable
        public static Pair<GlobeModel, class_2960> getModelAndTexture(String text) {
            return nameCache.get(text.toLowerCase(Locale.ROOT));
        }

        @Nullable
        public static Integer getTextureID(String text) {
            return idMap.get(text.toLowerCase(Locale.ROOT));
        }

        static {
            nameCache = new HashMap<String, Pair<GlobeModel, class_2960>>();
            idMap = new Object2IntArrayMap();
            textures = new ArrayList<class_2960>();
        }
    }
}

