/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LABColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1011;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2541;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3620;
import net.minecraft.class_5321;
import net.minecraft.class_6539;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class ColoredMapHandler {
    protected static int DITHERING = 1;
    public static final CustomMapData.Type<ColorData> COLOR_DATA = MapDecorationRegistry.registerCustomMapSavedData((class_2960)Supplementaries.res("color_data"), ColorData::new);

    public static void init() {
    }

    public static ColorData getColorData(class_22 data) {
        return (ColorData)COLOR_DATA.get(data);
    }

    @Nullable
    public static class_2248 getCustomColor(class_2248 state) {
        if (state instanceof class_2541) {
            return class_2246.field_10503;
        }
        class_6880.class_6883 blockReference = state.method_40142();
        if (blockReference.method_40220(ModTags.NOT_TINTED_ON_MAPS)) {
            return null;
        }
        if (blockReference.method_40220(ModTags.TINTED_ON_MAPS_GC)) {
            if (state instanceof class_2261) {
                return class_2246.field_10479;
            }
            return class_2246.field_10219;
        }
        if (blockReference.method_40220(ModTags.TINTED_ON_MAPS_FC)) {
            return class_2246.field_10503;
        }
        if (blockReference.method_40220(ModTags.TINTED_ON_MAPS_WC)) {
            return class_2246.field_10382;
        }
        if (blockReference.method_40220(ModTags.TINTED_ON_MAPS_GENERIC)) {
            return state;
        }
        return null;
    }

    public static int swapFormat(int argb) {
        return argb & 0xFF00FF00 | argb >> 16 & 0xFF | argb << 16 & 0xFF0000;
    }

    public static class ColorData
    implements CustomMapData<Counter>,
    class_1920 {
        public static final int BIOME_SIZE = 4;
        public static final String MIN_X = "min_x";
        public static final String MAX_X = "max_x";
        public static final String MIN_Z = "min_z";
        private static final Map<Pair<Pair<class_2248, class_2960>, Integer>, Integer> GLOBAL_COLOR_CACHE = new Object2IntOpenHashMap();
        private static final int[] IND2COLOR_BUFFER = new int[1024];
        private byte[][] data = null;
        private final List<class_2960> biomesIndexes = new ArrayList<class_2960>();
        private final List<class_2248> blockIndexes = new ArrayList<class_2248>();
        private int lastMinDirtyX = 0;
        private int lastMinDirtyZ = 0;
        private int lastMaxDirtyX = 0;
        private int lastMaxDirtyZ = 0;
        private Pair<class_2248, class_2960> lastEntryHack;

        @Nullable
        private Pair<class_2248, class_2960> getEntry(int x, int z) {
            if (this.data == null) {
                return null;
            }
            if (x < 0 || x >= 128 || z < 0 || z >= 128) {
                return null;
            }
            if (this.data[x] != null) {
                int packed = Byte.toUnsignedInt(this.data[x][z]);
                if (packed == 0) {
                    return null;
                }
                int bi = --packed & 0xF;
                int bli = packed >> 4;
                if (bi >= this.blockIndexes.size() || bli >= this.biomesIndexes.size()) {
                    return null;
                }
                return Pair.of((Object)this.blockIndexes.get(bi), (Object)this.biomesIndexes.get(bli));
            }
            return null;
        }

        private int getIndex(int x, int z) {
            if (this.data == null || this.data[x] == null) {
                return 0;
            }
            return Byte.toUnsignedInt(this.data[x][z]);
        }

        private void addEntry(class_22 md, int x, int z, Pair<class_2248, class_2960> res) {
            boolean changedBiome;
            boolean changedBlock;
            class_2248 block = (class_2248)res.getFirst();
            if (!this.blockIndexes.contains(block)) {
                if (this.blockIndexes.size() >= 16) {
                    return;
                }
                this.blockIndexes.add(block);
                changedBlock = true;
            } else {
                changedBlock = false;
            }
            int blockIndex = this.blockIndexes.indexOf(block);
            class_2960 biome = (class_2960)res.getSecond();
            if (!this.biomesIndexes.contains(biome)) {
                if (this.biomesIndexes.size() >= 16) {
                    return;
                }
                this.biomesIndexes.add(biome);
                changedBiome = true;
            } else {
                changedBiome = false;
            }
            int biomeIndex = this.biomesIndexes.indexOf(biome);
            if (this.data == null) {
                this.data = new byte[128][];
            }
            if (this.data[x] == null) {
                this.data[x] = new byte[128];
            }
            this.data[x][z] = (byte)((blockIndex & 0xF | biomeIndex << 4) + 1);
            this.setDirty(md, counter -> counter.markDirty(x, z, changedBiome, changedBlock));
        }

        public void load(class_2487 tag) {
            byte i;
            int j;
            this.lastMinDirtyX = 0;
            this.lastMinDirtyZ = 0;
            this.lastMaxDirtyX = 0;
            this.lastMaxDirtyZ = 0;
            if (tag.method_10545("positions")) {
                class_2487 t = tag.method_10562("positions");
                int minX = 0;
                if (t.method_10545(MIN_X)) {
                    minX = t.method_10550(MIN_X);
                }
                this.lastMinDirtyX = minX;
                int maxX = 127;
                if (t.method_10545(MAX_X)) {
                    maxX = t.method_10550(MAX_X);
                }
                this.lastMaxDirtyX = maxX;
                int minZ = 0;
                if (t.method_10545(MIN_Z)) {
                    minZ = t.method_10550(MIN_Z);
                }
                this.lastMinDirtyZ = minZ;
                for (int x = minX; x <= maxX; ++x) {
                    byte[] rowData = t.method_10547("pos_" + x);
                    this.lastMaxDirtyZ = minZ + rowData.length;
                    if (this.data == null) {
                        this.data = new byte[128][];
                    }
                    if (this.data[x] == null) {
                        this.data[x] = new byte[128];
                    }
                    System.arraycopy(rowData, 0, this.data[x], minZ, rowData.length);
                }
            }
            if (tag.method_10545("biomes")) {
                this.biomesIndexes.clear();
                class_2499 biomes = tag.method_10554("biomes", 10);
                for (j = 0; j < biomes.size(); ++j) {
                    class_2487 c = biomes.method_10602(j);
                    i = c.method_10571("index");
                    String id = c.method_10558("id");
                    this.biomesIndexes.add(i, new class_2960(id));
                }
            }
            if (tag.method_10545("blocks")) {
                this.blockIndexes.clear();
                class_2499 blocks = tag.method_10554("blocks", 10);
                for (j = 0; j < blocks.size(); ++j) {
                    class_2487 c = blocks.method_10602(j);
                    i = c.method_10571("index");
                    String id = c.method_10558("id");
                    this.blockIndexes.add(i, (class_2248)class_2378.field_11146.method_10223(new class_2960(id)));
                }
            }
        }

        private void savePatch(class_2487 tag, int minX, int maxX, int minZ, int maxZ, boolean pos, boolean block, boolean biome) {
            int i;
            if (pos && this.data != null) {
                class_2487 t = new class_2487();
                if (minX != 0) {
                    t.method_10569(MIN_X, minX);
                }
                if (maxX != 127) {
                    t.method_10569(MAX_X, maxX);
                }
                if (minZ != 0) {
                    t.method_10569(MIN_Z, minZ);
                }
                for (int x = minX; x <= maxX; ++x) {
                    if (this.data[x] == null) continue;
                    byte[] rowData = new byte[maxZ - minZ + 1];
                    System.arraycopy(this.data[x], minZ, rowData, 0, rowData.length);
                    t.method_10570("pos_" + x, rowData);
                }
                tag.method_10566("positions", (class_2520)t);
            }
            if (biome && !this.biomesIndexes.isEmpty()) {
                class_2499 biomesList = new class_2499();
                for (i = 0; i < this.biomesIndexes.size(); ++i) {
                    class_2487 biomeTag = new class_2487();
                    biomeTag.method_10567("index", (byte)i);
                    biomeTag.method_10582("id", this.biomesIndexes.get(i).toString());
                    biomesList.add((Object)biomeTag);
                }
                tag.method_10566("biomes", (class_2520)biomesList);
            }
            if (block && !this.blockIndexes.isEmpty()) {
                class_2499 blocksList = new class_2499();
                for (i = 0; i < this.blockIndexes.size(); ++i) {
                    class_2487 blockTag = new class_2487();
                    blockTag.method_10567("index", (byte)i);
                    blockTag.method_10582("id", Utils.getID((class_2248)this.blockIndexes.get(i)).toString());
                    blocksList.add((Object)blockTag);
                }
                tag.method_10566("blocks", (class_2520)blocksList);
            }
        }

        public void save(class_2487 tag) {
            this.savePatch(tag, 0, 127, 0, 127, true, true, true);
        }

        public void saveToUpdateTag(class_2487 tag, Counter dc) {
            this.savePatch(tag, dc.minDirtyX, dc.maxDirtyX, dc.minDirtyZ, dc.maxDirtyZ, dc.posDirty, dc.blockDirty, dc.biomesDirty);
        }

        public void loadUpdateTag(class_2487 tag) {
            this.load(tag);
        }

        public boolean persistOnCopyOrLock() {
            return false;
        }

        public CustomMapData.Type<?> getType() {
            return COLOR_DATA;
        }

        public Counter createDirtyCounter() {
            return new Counter();
        }

        public void markColored(int x, int z, class_2248 block, class_1937 level, class_2338 pos, class_22 data) {
            class_2248 customColor = ColoredMapHandler.getCustomColor(block);
            if (customColor != null) {
                boolean odd = x % 2 == 0 ^ z % 2 == 1;
                pos = pos.method_10069(odd ? DITHERING : -DITHERING, 0, odd ? DITHERING : -DITHERING);
                class_5321 biome = (class_5321)level.method_23753(pos).method_40230().get();
                Pair pair = Pair.of((Object)customColor, (Object)biome.method_29177());
                if (!Objects.equals(this.getEntry(x, z), pair)) {
                    this.addEntry(data, x, z, (Pair<class_2248, class_2960>)pair);
                }
            } else if (this.data != null && this.data[x] != null && this.data[x][z] != 0) {
                this.data[x][z] = 0;
                this.setDirty(data, counter -> counter.markDirty(x, z, false, false));
                for (byte b : this.data[x]) {
                    if (b == 0) continue;
                    return;
                }
                this.data[x] = null;
            }
        }

        @Nullable
        public class_2586 method_8321(class_2338 pos) {
            return null;
        }

        public class_2680 method_8320(class_2338 pos) {
            Pair<class_2248, class_2960> entry = this.getEntry(pos.method_10263(), pos.method_10260());
            return entry == null ? class_2246.field_10124.method_9564() : ((class_2248)entry.getFirst()).method_9564();
        }

        public class_3610 method_8316(class_2338 pos) {
            return this.method_8320(pos).method_26227();
        }

        public int method_31605() {
            return 0;
        }

        public int method_31607() {
            return 0;
        }

        @Environment(value=EnvType.CLIENT)
        public void processTexture(class_1011 texture, int startX, int startY, byte[] colors) {
            if (!ClientConfigs.Tweaks.COLORED_MAPS.get().booleanValue() || this.data == null) {
                return;
            }
            boolean tallGrass = ClientConfigs.Tweaks.TALL_GRASS_COLOR_CHANGE.get();
            boolean accurateConfig = ClientConfigs.Tweaks.ACCURATE_COLORED_MAPS.get();
            if (!accurateConfig) {
                Arrays.fill(IND2COLOR_BUFFER, 0);
            }
            class_324 blockColors = class_310.method_1551().method_1505();
            for (int x = 0; x < 128; ++x) {
                for (int z = 0; z < 128; ++z) {
                    int alreadyKnownColor;
                    int index = this.getIndex(x, z);
                    if (index == 0) continue;
                    int newTint = -1;
                    int k = x + z * 128;
                    byte packedId = colors[k];
                    int brightnessInd = packedId & 3;
                    if (!accurateConfig && (alreadyKnownColor = IND2COLOR_BUFFER[index + brightnessInd * 256]) != 0) {
                        newTint = alreadyKnownColor;
                    }
                    if (newTint == -1) {
                        Pair<class_2248, class_2960> e = this.getEntry(x, z);
                        this.lastEntryHack = e;
                        if (e == null) continue;
                        class_2248 block = (class_2248)e.getFirst();
                        if (accurateConfig) {
                            class_2338 pos = new class_2338(x, 64, z);
                            int tint = blockColors.method_1697(block.method_9564(), (class_1920)this, pos, 0);
                            if (tint != -1) {
                                newTint = ColorData.postProcessTint(tallGrass, packedId, block, tint);
                            }
                        } else {
                            ColorData.IND2COLOR_BUFFER[index + brightnessInd * 256] = newTint = GLOBAL_COLOR_CACHE.computeIfAbsent((Pair<Pair<class_2248, class_2960>, Integer>)Pair.of(e, (Object)brightnessInd), n -> {
                                class_2338 pos = new class_2338(0, 64, 0);
                                int tint = blockColors.method_1697(block.method_9564(), (class_1920)this, pos, 0);
                                return ColorData.postProcessTint(tallGrass, packedId, block, tint);
                            }).intValue();
                        }
                    }
                    if (newTint == -1) continue;
                    texture.method_4305(startX + x, startY + z, newTint);
                }
            }
        }

        private static int postProcessTint(boolean tg, byte packedId, class_2248 block, int tint) {
            float lumIncrease = 1.3f;
            class_3620 mapColor = class_3620.method_38479((int)((packedId & 0xFF) >> 2));
            if (mapColor == class_3620.field_16019) {
                lumIncrease = 2.0f;
            } else if (mapColor == class_3620.field_16004 && block instanceof class_2261 && tg) {
                packedId = class_3620.field_15999.method_38481(class_3620.class_6594.method_38484((int)(packedId & 3)));
            }
            int color = class_3620.method_38480((int)packedId);
            tint = ColoredMapHandler.swapFormat(tint);
            RGBColor tintColor = new RGBColor(tint);
            LABColor c = new RGBColor(color).asLAB();
            RGBColor gray = c.multiply(null, lumIncrease, 0.0f, 0.0f, 1.0f).asRGB();
            int grayscaled = gray.multiply(null, tintColor.red(), tintColor.green(), tintColor.blue(), 1.0f).asHSL().multiply(null, 1.0f, 1.3f, 1.0f, 1.0f).asRGB().toInt();
            return grayscaled;
        }

        public float method_24852(class_2350 direction, boolean shade) {
            return 0.0f;
        }

        public class_3568 method_22336() {
            return ClientRegistry.getLightEngine();
        }

        public int method_23752(class_2338 pos, class_6539 colorResolver) {
            int x = pos.method_10263();
            int z = pos.method_10260();
            if (this.lastEntryHack != null) {
                class_1959 b = (class_1959)((class_2378)Utils.hackyGetRegistryAccess().method_33310(class_2378.field_25114).get()).method_10223((class_2960)this.lastEntryHack.getSecond());
                boolean odd = x % 2 == 0 ^ z % 2 == 1;
                pos = pos.method_10069(odd ? DITHERING : -DITHERING, 0, odd ? DITHERING : -DITHERING);
                return colorResolver.getColor(b, (double)pos.method_10263() + 0.5, (double)pos.method_10260() + 0.5);
            }
            return 0;
        }

        public void clear() {
            this.data = null;
            this.biomesIndexes.clear();
            this.blockIndexes.clear();
        }
    }

    private static class Counter
    implements CustomMapData.DirtyCounter {
        private int minDirtyX = 0;
        private int maxDirtyX = 127;
        private int minDirtyZ = 0;
        private int maxDirtyZ = 127;
        private boolean posDirty = true;
        private boolean blockDirty = true;
        private boolean biomesDirty = true;

        private Counter() {
        }

        public void markDirty(int x, int z, boolean changedBiome, boolean changedBlock) {
            if (changedBiome) {
                this.biomesDirty = true;
            }
            if (changedBlock) {
                this.blockDirty = true;
            }
            if (this.posDirty) {
                this.minDirtyX = Math.min(this.minDirtyX, x);
                this.minDirtyZ = Math.min(this.minDirtyZ, z);
                this.maxDirtyX = Math.max(this.maxDirtyX, x);
                this.maxDirtyZ = Math.max(this.maxDirtyZ, z);
            } else {
                this.posDirty = true;
                this.minDirtyX = x;
                this.minDirtyZ = z;
                this.maxDirtyX = x;
                this.maxDirtyZ = z;
            }
        }

        public boolean isDirty() {
            return this.posDirty || this.biomesDirty || this.blockDirty;
        }

        public void clearDirty() {
            this.biomesDirty = false;
            this.blockDirty = false;
            this.posDirty = false;
            this.minDirtyX = 0;
            this.minDirtyZ = 0;
            this.maxDirtyX = 0;
            this.maxDirtyZ = 0;
        }
    }
}

