/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.mehvahdjukaar.supplementaries.reg.ModWorldgenRegistry;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_4966;
import net.minecraft.class_5539;
import net.minecraft.class_6880;
import net.minecraft.class_7059;
import net.minecraft.class_7138;
import net.minecraft.class_7151;

public class WaySignStructure
extends class_3195 {
    public static final Codec<WaySignStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WaySignStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.INT.fieldOf("min_y").forGetter(structure -> structure.minY), (App)Codec.INT.fieldOf("max_y").forGetter(structure -> structure.maxY)).apply((Applicative)instance, WaySignStructure::new)).codec();
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int minY;
    private final int maxY;

    public WaySignStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int minY, int maxY) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.minY = minY;
        this.maxY = maxY;
    }

    public class_7151<?> method_41618() {
        return ModWorldgenRegistry.WAY_SIGN.get();
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        Optional<class_2338> suitablePosition = WaySignStructure.getSuitablePosition(context, this);
        if (suitablePosition.isEmpty()) {
            return Optional.empty();
        }
        class_2338 blockPos = suitablePosition.get();
        return class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)3, (class_2338)blockPos, (boolean)false, Optional.empty(), (int)32);
    }

    private static Optional<class_2338> getSuitablePosition(class_3195.class_7149 context, WaySignStructure structure) {
        int z;
        class_1923 chunkPos = context.comp_568();
        class_2794 generator = context.comp_562();
        class_5539 heightLimitView = context.comp_569();
        class_7138 randomState = context.comp_564();
        boolean hasVillages = generator.method_41039().anyMatch(f -> {
            for (class_7059.class_7060 s : ((class_7059)f.comp_349()).comp_510()) {
                if (!s.comp_512().method_40220(ModTags.WAY_SIGN_DESTINATIONS)) continue;
                return true;
            }
            return false;
        });
        if (!hasVillages) {
            return Optional.empty();
        }
        int x = chunkPos.method_33940();
        int y = generator.method_18028(x, z = chunkPos.method_33942(), class_2902.class_2903.field_13194, heightLimitView, randomState);
        if (y < structure.minY || y > structure.maxY) {
            return Optional.empty();
        }
        if (y > 105 || y < generator.method_16398()) {
            return Optional.empty();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(y);
        if (WaySignStructure.isPosNotValid(generator, x + 2, z + 2, list, heightLimitView, randomState)) {
            return Optional.empty();
        }
        if (WaySignStructure.isPosNotValid(generator, x + 2, z - 2, list, heightLimitView, randomState)) {
            return Optional.empty();
        }
        if (WaySignStructure.isPosNotValid(generator, x - 2, z + 2, list, heightLimitView, randomState)) {
            return Optional.empty();
        }
        if (WaySignStructure.isPosNotValid(generator, x - 2, z - 2, list, heightLimitView, randomState)) {
            return Optional.empty();
        }
        TreeSet<Integer> set = new TreeSet<Integer>(list);
        if (set.last() - set.first() > 1) {
            return Optional.empty();
        }
        int sum = 0;
        for (Integer v : list) {
            sum += v.intValue();
        }
        return Optional.of(new class_2338(x, Math.round((float)sum / 5.0f) + 1, z));
    }

    private static boolean isPosNotValid(class_2794 gen, int x, int z, List<Integer> heightMap, class_5539 heightLimitView, class_7138 randomState) {
        int y = gen.method_18028(x, z, class_2902.class_2903.field_13194, heightLimitView, randomState);
        class_4966 noisecolumn = gen.method_26261(x, z, heightLimitView, randomState);
        class_2680 state = noisecolumn.method_32892(y);
        try {
            if (state.method_26227().method_15769()) {
                heightMap.add(y);
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public static class Type
    implements class_7151<WaySignStructure> {
        public Codec<WaySignStructure> codec() {
            return CODEC;
        }
    }
}

