/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.util.math.Vec2i;
import net.mehvahdjukaar.supplementaries.common.items.SliceMapItem;
import net.mehvahdjukaar.supplementaries.common.misc.ColoredMapHandler;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.class_1297;
import net.minecraft.class_1806;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3620;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1806.class})
public abstract class MapItemMixin {
    @ModifyExpressionValue(method={"update"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/dimension/DimensionType;hasCeiling()Z")})
    public boolean removeCeiling(boolean original, @Share(value="heightLock") LocalIntRef height) {
        if (original && height.get() != Integer.MAX_VALUE && CommonConfigs.Tools.SLICE_MAP_ENABLED.get().booleanValue()) {
            return false;
        }
        return original;
    }

    @Inject(method={"update"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/dimension/DimensionType;hasCeiling()Z", shift=At.Shift.BEFORE, ordinal=0)}, require=1, cancellable=true)
    public void checkHeightLock(class_1937 level, class_1297 viewer, class_22 data, CallbackInfo ci, @Local(ordinal=5) LocalIntRef range, @Share(value="customColorMap") LocalRef<Map<Vec2i, Pair<class_2338, Multiset<class_2248>>>> colorMap, @Share(value="heightLock") LocalIntRef height) {
        int mapHeight = SliceMapItem.getMapHeight(data);
        height.set(mapHeight);
        colorMap.set((Object)(CommonConfigs.Tweaks.TINTED_MAP.get() != false ? new HashMap() : null));
        if (mapHeight != Integer.MAX_VALUE) {
            if (!SliceMapItem.canPlayerSee(mapHeight, viewer)) {
                ci.cancel();
            }
            range.set((int)((double)range.get() * SliceMapItem.getRangeMultiplier()));
        }
    }

    @ModifyExpressionValue(method={"update"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/LevelChunk;getHeight(Lnet/minecraft/world/level/levelgen/Heightmap$Types;II)I")})
    public int modifySampleHeight(int original, @Share(value="heightLock") LocalIntRef height) {
        int h = height.get();
        if (h != Integer.MAX_VALUE) {
            return Math.min(original, h);
        }
        return original;
    }

    @WrapOperation(method={"update"}, at={@At(value="INVOKE", ordinal=3, target="Lnet/minecraft/world/level/block/state/BlockState;getMapColor(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/MaterialColor;")})
    public class_3620 removeXrayAndAddAccurateColor(class_2680 instance, class_1922 level, class_2338 pos, Operation<class_3620> operation, @Local class_2818 chunk, @Local(ordinal=17) int w, @Local(ordinal=0) class_2680 state, @Local(ordinal=6) int k1, @Local(ordinal=7) int l1, @Share(value="customColorMap") LocalRef<Map<Vec2i, Pair<class_2338, Multiset<class_2248>>>> colorMap, @Share(value="heightLock") LocalIntRef height) {
        if (height.get() != Integer.MAX_VALUE && height.get() <= w) {
            return SliceMapItem.getCutoffColor(pos, (class_1922)chunk);
        }
        if (colorMap.get() != null) {
            ((Multiset)((Map)colorMap.get()).computeIfAbsent(new Vec2i(k1, l1), p -> Pair.of((Object)pos, (Object)LinkedHashMultiset.create())).getSecond()).add((Object)state.method_26204());
        }
        return (class_3620)operation.call(new Object[]{instance, level, pos});
    }

    @ModifyExpressionValue(method={"update"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/saveddata/maps/MapItemSavedData;updateColor(IIB)Z")})
    public boolean updateCustomColor(boolean original, class_1937 level, class_1297 viewer, class_22 data, @Local(ordinal=6) int x, @Local(ordinal=7) int z, @Share(value="customColorMap") LocalRef<Map<Vec2i, Pair<class_2338, Multiset<class_2248>>>> colorMap) {
        if (colorMap.get() == null) {
            return original;
        }
        Pair l = (Pair)((Map)colorMap.get()).get(new Vec2i(x, z));
        if (l != null) {
            class_2248 block = (class_2248)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)((Multiset)l.getSecond())), (Object)class_2246.field_10124);
            ColoredMapHandler.ColorData c = ColoredMapHandler.getColorData(data);
            if (c != null) {
                c.markColored(x, z, block, level, (class_2338)l.getFirst(), data);
            }
        }
        return original;
    }
}

