/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_55;
import net.minecraft.class_79;
import net.minecraft.class_83;

public class LootTablesInjects {
    private static final List<BiConsumer<Consumer<class_55.class_56>, TableType>> LOOT_INJECTS = new ArrayList<BiConsumer<Consumer<class_55.class_56>, TableType>>();

    public static void setup() {
        if (CommonConfigs.Building.GLOBE_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectGlobe);
        }
        if (CommonConfigs.Tools.QUIVER_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectQuiver);
        }
        if (CommonConfigs.Functional.ROPE_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectRope);
        }
        if (CommonConfigs.Functional.FLAX_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectFlax);
        }
        if (CommonConfigs.Tools.BOMB_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectBlueBomb);
        }
        if (CommonConfigs.Tools.BOMB_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectBomb);
        }
        if (CommonConfigs.stasisEnabled()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectStasis);
        }
        if (CommonConfigs.Functional.BAMBOO_SPIKES_ENABLED.get().booleanValue() && CommonConfigs.Functional.TIPPED_SPIKES_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectSpikes);
        }
    }

    public static void injectLootTables(class_2960 name, Consumer<class_55.class_56> builder) {
        TableType type;
        String nameSpace = name.method_12836();
        if ((nameSpace.equals("minecraft") || nameSpace.equals("repurposed_structures")) && (type = LootHelper.getType(name.toString())) != TableType.OTHER) {
            LOOT_INJECTS.forEach(i -> i.accept(builder, type));
        }
    }

    private static void injectLootPool(Consumer<class_55.class_56> consumer, TableType type, String name) {
        String id = type.toString().toLowerCase(Locale.ROOT) + "_" + name;
        class_55.class_56 pool = class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)Supplementaries.res("inject/" + id)));
        ForgeHelper.setPoolName((class_55.class_56)pool, (String)("supp_" + name));
        consumer.accept(pool);
    }

    public static void tryInjectGlobe(Consumer<class_55.class_56> e, TableType type) {
        if (type == TableType.SHIPWRECK_TREASURE) {
            LootTablesInjects.injectLootPool(e, type, "globe");
        }
    }

    private static void tryInjectQuiver(Consumer<class_55.class_56> e, TableType type) {
        if (type == TableType.DUNGEON || type == TableType.MANSION) {
            LootTablesInjects.injectLootPool(e, type, "quiver");
        }
    }

    public static void tryInjectRope(Consumer<class_55.class_56> e, TableType type) {
        if (type == TableType.MINESHAFT) {
            LootTablesInjects.injectLootPool(e, type, "rope");
        }
    }

    public static void tryInjectFlax(Consumer<class_55.class_56> e, TableType type) {
        if (type == TableType.MINESHAFT || type == TableType.DUNGEON || type == TableType.SHIPWRECK_STORAGE || type == TableType.PILLAGER) {
            LootTablesInjects.injectLootPool(e, type, "flax");
        }
    }

    public static void tryInjectBlueBomb(Consumer<class_55.class_56> e, TableType type) {
        if (type == TableType.STRONGHOLD || type == TableType.MINESHAFT || type == TableType.TEMPLE || type == TableType.FORTRESS || type == TableType.DUNGEON) {
            LootTablesInjects.injectLootPool(e, type, "blue_bomb");
        }
    }

    public static void tryInjectBomb(Consumer<class_55.class_56> e, TableType type) {
        if (type == TableType.STRONGHOLD || type == TableType.MINESHAFT || type == TableType.TEMPLE || type == TableType.FORTRESS) {
            LootTablesInjects.injectLootPool(e, type, "bomb");
        }
    }

    public static void tryInjectSpikes(Consumer<class_55.class_56> e, TableType type) {
        if (type == TableType.TEMPLE) {
            LootTablesInjects.injectLootPool(e, type, "spikes");
        }
    }

    public static void tryInjectStasis(Consumer<class_55.class_56> e, TableType type) {
        if (type == TableType.END_CITY) {
            LootTablesInjects.injectLootPool(e, type, "stasis");
        }
    }

    private static class LootHelper {
        private static final boolean RS = CompatHandler.REPURPOSED_STRUCTURES;
        private static final Pattern RS_SHIPWRECK = Pattern.compile("repurposed_structures:chests/shipwreck/\\w*/treasure_chest");
        private static final Pattern RS_SHIPWRECK_STORAGE = Pattern.compile("repurposed_structures:chests/shipwreck/\\w*/supply_chest");
        private static final Pattern RS_TEMPLE = Pattern.compile("repurposed_structures:chests/temple/\\w*_chest");
        private static final Pattern RS_TEMPLE_DISPENSER = Pattern.compile("repurposed_structures:chests/temple/\\w*_dispenser");

        private LootHelper() {
        }

        public static TableType getType(String name) {
            if (LootHelper.isShipwreck(name)) {
                return TableType.SHIPWRECK_TREASURE;
            }
            if (LootHelper.isShipwreckStorage(name)) {
                return TableType.SHIPWRECK_STORAGE;
            }
            if (LootHelper.isMineshaft(name)) {
                return TableType.MINESHAFT;
            }
            if (LootHelper.isDungeon(name)) {
                return TableType.DUNGEON;
            }
            if (LootHelper.isTemple(name)) {
                return TableType.TEMPLE;
            }
            if (LootHelper.isTempleDispenser(name)) {
                return TableType.TEMPLE_DISPENSER;
            }
            if (LootHelper.isOutpost(name)) {
                return TableType.PILLAGER;
            }
            if (LootHelper.isStronghold(name)) {
                return TableType.STRONGHOLD;
            }
            if (LootHelper.isFortress(name)) {
                return TableType.FORTRESS;
            }
            if (LootHelper.isEndCity(name)) {
                return TableType.END_CITY;
            }
            if (LootHelper.isMansion(name)) {
                return TableType.MANSION;
            }
            if (LootHelper.isFishTreasure(name)) {
                return TableType.FISHING_TREASURE;
            }
            return TableType.OTHER;
        }

        private static boolean isFishTreasure(String name) {
            return name.equals(class_39.field_854.toString());
        }

        private static boolean isMansion(String name) {
            return name.equals(class_39.field_484.toString()) || RS && name.contains("repurposed_structures:chests/mansion");
        }

        private static boolean isShipwreck(String s) {
            return s.equals(class_39.field_665.toString()) || RS && RS_SHIPWRECK.matcher(s).matches();
        }

        private static boolean isShipwreckStorage(String s) {
            return s.equals(class_39.field_880.toString()) || RS && RS_SHIPWRECK_STORAGE.matcher(s).matches();
        }

        private static boolean isMineshaft(String s) {
            return s.equals(class_39.field_472.toString()) || RS && s.contains("repurposed_structures:chests/mineshaft");
        }

        private static boolean isOutpost(String s) {
            return s.equals(class_39.field_16593.toString()) || RS && s.contains("repurposed_structures:chests/outpost");
        }

        private static boolean isDungeon(String s) {
            return s.equals(class_39.field_356.toString()) || RS && s.contains("repurposed_structures:chests/dungeon");
        }

        private static boolean isTemple(String s) {
            return s.equals(class_39.field_803.toString()) || RS && RS_TEMPLE.matcher(s).matches();
        }

        private static boolean isTempleDispenser(String s) {
            return s.equals(class_39.field_803.toString()) || RS && RS_TEMPLE_DISPENSER.matcher(s).matches();
        }

        private static boolean isStronghold(String s) {
            return s.equals(class_39.field_800.toString()) || RS && s.contains("repurposed_structures:chests/stronghold/nether_storage_room");
        }

        private static boolean isFortress(String s) {
            return s.equals(class_39.field_615.toString()) || RS && s.contains("repurposed_structures:chests/fortress");
        }

        private static boolean isEndCity(String s) {
            return s.equals(class_39.field_274.toString());
        }
    }

    public static enum TableType {
        OTHER,
        MINESHAFT,
        SHIPWRECK_TREASURE,
        PILLAGER,
        DUNGEON,
        PYRAMID,
        STRONGHOLD,
        TEMPLE,
        TEMPLE_DISPENSER,
        IGLOO,
        MANSION,
        FORTRESS,
        BASTION,
        RUIN,
        SHIPWRECK_STORAGE,
        END_CITY,
        FISHING_TREASURE;

    }
}

