/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.tristankechlo.toolleveling.config.CommandConfig;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2194;
import net.minecraft.class_2561;

public final class SuperEnchantCommand {
    private static final DynamicCommandExceptionType NONLIVING_ENTITY_EXCEPTION = new DynamicCommandExceptionType(entityName -> class_2561.method_43469((String)"commands.enchant.failed.entity", (Object[])new Object[]{entityName}));
    private static final DynamicCommandExceptionType INCOMPATIBLE_ENCHANTS_EXCEPTION = new DynamicCommandExceptionType(itemName -> class_2561.method_43469((String)"commands.superenchant.failed.incompatible", (Object[])new Object[]{itemName}));
    private static final DynamicCommandExceptionType WRONG_ENCHANTS_EXCEPTION = new DynamicCommandExceptionType(itemName -> class_2561.method_43469((String)"commands.superenchant.failed.wrong", (Object[])new Object[]{itemName}));
    private static final DynamicCommandExceptionType ITEMLESS_EXCEPTION = new DynamicCommandExceptionType(entityName -> class_2561.method_43469((String)"commands.enchant.failed.itemless", (Object[])new Object[]{entityName}));
    private static final SimpleCommandExceptionType FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.enchant.failed"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"superenchant").requires(player -> player.method_9259(3))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enchantment", (ArgumentType)class_2194.method_9336()).executes(context -> SuperEnchantCommand.enchant((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"targets"), class_2194.method_9334((CommandContext)context, (String)"enchantment"), 1))).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Short.MAX_VALUE)).executes(context -> SuperEnchantCommand.enchant((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"targets"), class_2194.method_9334((CommandContext)context, (String)"enchantment"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))));
    }

    private static int enchant(class_2168 source, Collection<? extends class_1297> targets, class_1887 enchantmentIn, int level) throws CommandSyntaxException {
        int i = 0;
        for (class_1297 class_12972 : targets) {
            if (class_12972 instanceof class_1309) {
                class_1309 livingentity = (class_1309)class_12972;
                class_1799 stack = livingentity.method_6047();
                if (!stack.method_7960()) {
                    if (enchantmentIn.method_8192(stack) || CommandConfig.allowWrongEnchantments.getValue().booleanValue()) {
                        if (class_1890.method_8201(class_1890.method_8222((class_1799)stack).keySet(), (class_1887)enchantmentIn) || CommandConfig.allowIncompatibleEnchantments.getValue().booleanValue()) {
                            Map enchantments = class_1890.method_8222((class_1799)stack);
                            if (enchantments.containsKey(enchantmentIn) && level == 0) {
                                enchantments.remove(enchantmentIn);
                            } else {
                                enchantments.put(enchantmentIn, level);
                            }
                            class_1890.method_8214((Map)enchantments, (class_1799)stack);
                            ++i;
                            continue;
                        }
                        if (targets.size() != 1) continue;
                        throw INCOMPATIBLE_ENCHANTS_EXCEPTION.create((Object)stack.method_7909().method_7864(stack).getString());
                    }
                    if (targets.size() != 1) continue;
                    throw WRONG_ENCHANTS_EXCEPTION.create((Object)stack.method_7909().method_7864(stack).getString());
                }
                if (targets.size() != 1) continue;
                throw ITEMLESS_EXCEPTION.create((Object)livingentity.method_5477().getString());
            }
            if (targets.size() != 1) continue;
            throw NONLIVING_ENTITY_EXCEPTION.create((Object)class_12972.method_5477().getString());
        }
        if (i == 0) {
            throw FAILED_EXCEPTION.create();
        }
        if (targets.size() == 1) {
            source.method_9226((class_2561)class_2561.method_43469((String)"commands.enchant.success.single", (Object[])new Object[]{enchantmentIn.method_8179(level), targets.iterator().next().method_5476()}), true);
        } else {
            source.method_9226((class_2561)class_2561.method_43469((String)"commands.enchant.success.multiple", (Object[])new Object[]{enchantmentIn.method_8179(level), targets.size()}), true);
        }
        return i;
    }
}

