/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.config.primitives;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tristankechlo.toolleveling.ToolLeveling;
import com.tristankechlo.toolleveling.config.util.AbstractConfigValue;

public abstract class NumberValue<T extends Number>
extends AbstractConfigValue<T> {
    protected T value;
    protected final T defaultValue;
    protected final T minValue;
    protected final T maxValue;

    public NumberValue(String identifier, T defaultValue, T min, T max) {
        super(identifier);
        if (((Comparable)min).compareTo(max) > 0) {
            throw new IllegalArgumentException("ConfigValue " + identifier + ": min value needs to be lower than the max value");
        }
        if (!this.checkInRange(defaultValue, min, max)) {
            throw new IllegalArgumentException("ConfigValue " + identifier + ": defaultValue needs to be in range[min|max]");
        }
        this.value = defaultValue;
        this.defaultValue = defaultValue;
        this.minValue = min;
        this.maxValue = max;
    }

    @Override
    public void setToDefault() {
        this.value = this.defaultValue;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void serialize(JsonObject jsonObject) {
        jsonObject.addProperty(this.getIdentifier(), (Number)this.getValue());
    }

    abstract T getAsType(JsonElement var1);

    boolean checkInRange(T checkMe, T min, T max) {
        return ((Comparable)checkMe).compareTo(min) >= 0 && ((Comparable)checkMe).compareTo(max) <= 0;
    }

    @Override
    public void deserialize(JsonObject jsonObject) {
        try {
            JsonElement jsonElement = jsonObject.get(this.getIdentifier());
            if (jsonElement == null) {
                this.value = this.defaultValue;
                ToolLeveling.LOGGER.warn("Error while loading the config value " + this.getIdentifier() + ", using defaultvalue instead");
                return;
            }
            T checkMe = this.getAsType(jsonElement);
            if (this.checkInRange(checkMe, this.minValue, this.maxValue)) {
                this.value = checkMe;
                return;
            }
        }
        catch (Exception e) {
            ToolLeveling.LOGGER.warn("Error while loading the config value " + this.getIdentifier() + ", using defaultvalue instead");
        }
        this.value = this.defaultValue;
    }
}

