/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.config.util;

import com.google.gson.JsonObject;
import com.tristankechlo.toolleveling.ToolLeveling;
import com.tristankechlo.toolleveling.config.util.ConfigIdentifier;
import com.tristankechlo.toolleveling.network.ServerNetworkHandler;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class ConfigSyncing {
    public static void syncAllConfigsToOneClient(class_3222 player) {
        for (ConfigIdentifier config : ConfigIdentifier.values()) {
            JsonObject json = config.serialize(new JsonObject());
            ToolLeveling.LOGGER.info("Sending config to client: '{}'", (Object)config.withModID());
            ServerNetworkHandler.sendSyncConfig(player, config, json);
        }
    }

    public static void syncOneConfigToAllClients(MinecraftServer server, ConfigIdentifier config) {
        JsonObject json = config.serialize(new JsonObject());
        for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
            ToolLeveling.LOGGER.info("Sending config to client: '{}'", (Object)config.withModID());
            ServerNetworkHandler.sendSyncConfig(player, config, json);
        }
    }

    public static boolean deserializeConfig(String identifier, JsonObject json) {
        for (ConfigIdentifier config : ConfigIdentifier.values()) {
            if (!config.withModID().equals(identifier)) continue;
            config.deserialize(json);
            return true;
        }
        return false;
    }
}

