/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.config.values;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.tristankechlo.toolleveling.ToolLeveling;
import com.tristankechlo.toolleveling.config.util.AbstractConfigValue;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class RegistryListConfig<T>
extends AbstractConfigValue<ImmutableList<T>> {
    private ImmutableList<T> values;
    private final ImmutableList<T> defaultValues;
    private List<String> rawValues = new ArrayList<String>();
    private final Type type = new TypeToken<List<String>>(){}.getType();
    private final class_2378<T> registry;
    private static final Gson GSON = new Gson();

    public RegistryListConfig(String identifier, class_2378<T> registry, List<T> defaultValues) {
        super(identifier);
        if (registry == null) {
            throw new NullPointerException("registry of the config value can't be null");
        }
        if (defaultValues == null) {
            throw new NullPointerException("defaultValues of the config value can't be null");
        }
        this.registry = registry;
        this.defaultValues = ImmutableList.copyOf(defaultValues);
        for (T arg : defaultValues) {
            this.rawValues.add(registry.method_10221(arg).toString());
        }
        this.values = ImmutableList.copyOf(defaultValues);
    }

    @Override
    public void setToDefault() {
        this.values = ImmutableList.copyOf(this.defaultValues);
    }

    @Override
    public ImmutableList<T> getValue() {
        return this.values;
    }

    @Override
    public void serialize(JsonObject jsonObject) {
        List tempValues = this.getValue().stream().map(element -> this.registry.method_10221(element).toString()).collect(Collectors.toList());
        JsonElement jsonElement = GSON.toJsonTree(tempValues, this.type);
        jsonObject.add(this.getIdentifier(), jsonElement);
    }

    @Override
    public void deserialize(JsonObject jsonObject) {
        try {
            JsonElement jsonElement = jsonObject.get(this.getIdentifier());
            if (jsonElement == null) {
                this.setToDefault();
                ToolLeveling.LOGGER.warn("Error while loading the config value for " + this.getIdentifier() + ", using defaultvalues instead");
                return;
            }
            this.rawValues = (List)GSON.fromJson(jsonElement, this.type);
            if (this.rawValues == null) {
                this.setToDefault();
                ToolLeveling.LOGGER.warn("Error while parsing the config value for " + this.getIdentifier() + ", using defaultvalues instead");
                return;
            }
            ArrayList<Object> tempValues = new ArrayList<Object>();
            ArrayList<String> modids = new ArrayList<String>();
            for (String element : this.rawValues) {
                class_2960 loc = class_2960.method_12829((String)element);
                if (loc != null && this.registry.method_10250(loc)) {
                    tempValues.add(this.registry.method_10223(loc));
                    continue;
                }
                String modid = RegistryListConfig.getModidFromWildcard(element);
                if (modid == null) continue;
                ToolLeveling.LOGGER.info("Found wildcard for mod: '" + modid + "' in '" + this.getIdentifier() + "'");
                modids.add(modid);
            }
            RegistryListConfig.addAllWildcards(tempValues, modids, this.registry);
            this.values = ImmutableList.copyOf(tempValues);
        }
        catch (Exception e) {
            this.values = ImmutableList.copyOf(this.defaultValues);
            ToolLeveling.LOGGER.warn("Error while loading the config value " + this.getIdentifier() + ", using defaultvalue instead");
        }
    }

    private static <T> void addAllWildcards(List<T> tempValues, List<String> modids, class_2378<T> registry) {
        if (modids.isEmpty()) {
            return;
        }
        registry.method_10220().filter(element -> modids.contains(registry.method_10221(element).method_12836())).forEach(element -> tempValues.add(element));
    }

    private static String getModidFromWildcard(String element) {
        String[] splitted;
        if (element.contains(":") && (splitted = element.split(":"))[1].equals("*") && FabricLoader.getInstance().isModLoaded(splitted[0])) {
            return splitted[0];
        }
        return null;
    }
}

