/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.config.values;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tristankechlo.toolleveling.ToolLeveling;
import com.tristankechlo.toolleveling.config.util.AbstractConfigValue;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public abstract class RegistryMapConfig<X, Y>
extends AbstractConfigValue<ImmutableMap<X, Y>> {
    private ImmutableMap<X, Y> values;
    private final ImmutableMap<X, Y> defaultValues;
    private final class_2378<X> registry;
    private static final Gson GSON = new Gson();

    public RegistryMapConfig(String identifier, class_2378<X> registry, Map<X, Y> defaultValues) {
        super(identifier);
        this.registry = registry;
        this.defaultValues = ImmutableMap.copyOf(defaultValues);
    }

    @Override
    public void setToDefault() {
        this.values = ImmutableMap.copyOf(this.defaultValues);
    }

    @Override
    public ImmutableMap<X, Y> getValue() {
        return this.values;
    }

    @Override
    public void serialize(JsonObject jsonObject) {
        HashMap tempValues = new HashMap();
        for (Map.Entry entry : this.getValue().entrySet()) {
            Object key = entry.getKey();
            String keyString = Objects.requireNonNull(this.registry.method_10221(key)).toString();
            Object value = entry.getValue();
            tempValues.put(keyString, value);
        }
        JsonElement jsonElement = GSON.toJsonTree(tempValues, this.getType());
        jsonObject.add(this.getIdentifier(), jsonElement);
    }

    @Override
    public void deserialize(JsonObject jsonObject) {
        JsonElement jsonElement = jsonObject.get(this.getIdentifier());
        if (jsonElement == null) {
            this.setToDefault();
            ToolLeveling.LOGGER.warn("Error while loading the config value {}, using default values instead", (Object)this.getIdentifier());
            return;
        }
        Map rawValues = (Map)GSON.fromJson(jsonElement, this.getType());
        if (rawValues == null) {
            this.setToDefault();
            ToolLeveling.LOGGER.warn("Error while parsing the config value {}, using default values instead", (Object)this.getIdentifier());
            return;
        }
        HashMap tempValues = new HashMap();
        for (Map.Entry entry : rawValues.entrySet()) {
            class_2960 identifier = class_2960.method_12829((String)((String)entry.getKey()));
            if (identifier == null) {
                ToolLeveling.LOGGER.warn("Ignoring unknown element {} from {}", entry.getKey(), (Object)this.getIdentifier());
                continue;
            }
            Object value = entry.getValue();
            if (!this.isValueValid(value)) {
                ToolLeveling.LOGGER.warn("Ignoring value {} from {} because it is out of range", (Object)value.toString(), (Object)identifier);
                continue;
            }
            if (this.registry.method_10250(identifier)) {
                Object key = this.registry.method_10223(identifier);
                if (!this.isKeyValid(key, identifier)) {
                    ToolLeveling.LOGGER.warn("Ignoring value {} from {} because it is not allowed", (Object)identifier, (Object)this.getIdentifier());
                    continue;
                }
                tempValues.put(key, value);
                continue;
            }
            ToolLeveling.LOGGER.warn("Ignoring unknown element {} from {}", entry.getKey(), (Object)this.getIdentifier());
        }
        this.values = ImmutableMap.copyOf(tempValues);
    }

    protected abstract Type getType();

    protected abstract boolean isValueValid(Y var1);

    protected abstract boolean isKeyValid(X var1, class_2960 var2);
}

