/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.network;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tristankechlo.toolleveling.ToolLeveling;
import com.tristankechlo.toolleveling.blockentity.ToolLevelingTableBlockEntity;
import com.tristankechlo.toolleveling.config.util.ConfigIdentifier;
import com.tristankechlo.toolleveling.config.util.ConfigManager;
import com.tristankechlo.toolleveling.utils.Names;
import com.tristankechlo.toolleveling.utils.Utils;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public final class ServerNetworkHandler {
    public static void sendOpenItemValues(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)Names.NetworkChannels.OPEN_ITEMVALUES, (class_2540)PacketByteBufs.empty());
    }

    public static void recieveSetEnchantmentLevel(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        class_2338 pos = buf.method_10811();
        class_1887 enchantment = (class_1887)class_2378.field_11160.method_10223(buf.method_10810());
        int level = buf.readInt();
        server.execute(() -> {
            ToolLevelingTableBlockEntity table;
            class_1799 enchantedItem;
            Map enchantmentsMap;
            class_2586 entity;
            if (player == null) {
                ToolLeveling.LOGGER.warn("Error while handling the request. Invalid sender.");
                return;
            }
            class_3218 world = player.method_14220();
            if (world == null || !world.method_22340(pos) || world.field_9236) {
                ToolLeveling.LOGGER.warn("Error while handling the request. Invalid level.");
            }
            if ((entity = world.method_8321(pos)) != null && entity instanceof ToolLevelingTableBlockEntity && (enchantmentsMap = class_1890.method_8222((class_1799)(enchantedItem = (table = (ToolLevelingTableBlockEntity)entity).getStackToEnchant().method_7972()))).containsKey(enchantment)) {
                long upgradeCost = Utils.getEnchantmentUpgradeCost(enchantment, level);
                boolean upgradeSuccess = false;
                upgradeSuccess = Utils.freeCreativeUpgrades((class_1657)player) ? true : table.decreaseInventoryWorth(upgradeCost);
                if (upgradeSuccess) {
                    enchantmentsMap.put(enchantment, level);
                    class_1890.method_8214((Map)enchantmentsMap, (class_1799)enchantedItem);
                    table.method_5447(0, enchantedItem);
                    table.method_5431();
                }
            }
        });
    }

    public static void sendSyncConfig(class_3222 player, ConfigIdentifier config, JsonObject json) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(config.withModID());
        buf.method_10814(ConfigManager.GSON.toJson((JsonElement)json));
        ServerPlayNetworking.send((class_3222)player, (class_2960)Names.NetworkChannels.SYNC_CONFIG, (class_2540)buf);
    }
}

