/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.computercraft.operations;

import com.google.common.math.IntMath;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.turtlematic.computercraft.operations.SphereOperationContext;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B)\b\u0002\u0012\u0006\u0010\u0019\u001a\u00020\u0012\u0012\u0006\u0010\u001f\u001a\u00020\u0012\u0012\u0006\u0010\u001e\u001a\u00020\u0012\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0014R\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001aR\u0014\u0010\u001f\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001aR\u0018\u0010!\u001a\u0004\u0018\u00010 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010%\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010'\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b&\u0010$R\u0011\u0010)\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b(\u0010$R\u0018\u0010*\u001a\u0004\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010\u0018R\u0018\u0010+\u001a\u0004\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010\u0018j\u0002\b.j\u0002\b/\u00a8\u00060"}, d2={"Lsite/siredvin/turtlematic/computercraft/operations/SphereOperation;", "", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;", "Lsite/siredvin/turtlematic/computercraft/operations/SphereOperationContext;", "Lnet/minecraftforge/common/ForgeConfigSpec$Builder;", "builder", "", "addToConfig", "(Lnet/minecraftforge/common/ForgeConfigSpec$Builder;)V", "", "", "", "computerDescription", "()Ljava/util/Map;", "cost", "()Lsite/siredvin/turtlematic/computercraft/operations/SphereOperationContext;", "free", "context", "", "getCooldown", "(Lsite/siredvin/turtlematic/computercraft/operations/SphereOperationContext;)I", "getCost", "Lnet/minecraftforge/common/ForgeConfigSpec$IntValue;", "cooldown", "Lnet/minecraftforge/common/ForgeConfigSpec$IntValue;", "defaultCooldown", "I", "", "defaultExtraBlockCost", "D", "defaultMaxCostRadius", "defaultMaxFreeRadius", "Lnet/minecraftforge/common/ForgeConfigSpec$DoubleValue;", "extra_block_cost", "Lnet/minecraftforge/common/ForgeConfigSpec$DoubleValue;", "getInitialCooldown", "()I", "initialCooldown", "getMaxCostRadius", "maxCostRadius", "getMaxFreeRadius", "maxFreeRadius", "max_cost_radius", "max_free_radius", "<init>", "(Ljava/lang/String;IIIID)V", "SCAN_BLOCKS", "SCAN_ENTITIES", "turtlematic"})
public final class SphereOperation
extends Enum<SphereOperation>
implements IPeripheralOperation<SphereOperationContext> {
    private final int defaultCooldown;
    private final int defaultMaxFreeRadius;
    private final int defaultMaxCostRadius;
    private final double defaultExtraBlockCost;
    @Nullable
    private ForgeConfigSpec.IntValue cooldown;
    @Nullable
    private ForgeConfigSpec.IntValue max_free_radius;
    @Nullable
    private ForgeConfigSpec.IntValue max_cost_radius;
    @Nullable
    private ForgeConfigSpec.DoubleValue extra_block_cost;
    public static final /* enum */ SphereOperation SCAN_BLOCKS = new SphereOperation(2000, 8, 16, 0.17);
    public static final /* enum */ SphereOperation SCAN_ENTITIES = new SphereOperation(2000, 8, 16, 0.17);
    private static final /* synthetic */ SphereOperation[] $VALUES;

    private SphereOperation(int defaultCooldown, int defaultMaxFreeRadius, int defaultMaxCostRadius, double defaultExtraBlockCost) {
        this.defaultCooldown = defaultCooldown;
        this.defaultMaxFreeRadius = defaultMaxFreeRadius;
        this.defaultMaxCostRadius = defaultMaxCostRadius;
        this.defaultExtraBlockCost = defaultExtraBlockCost;
    }

    public void addToConfig(@NotNull ForgeConfigSpec.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.cooldown = builder.defineInRange(this.settingsName() + "Cooldown", this.defaultCooldown, 1000, Integer.MAX_VALUE);
        this.max_free_radius = builder.defineInRange(this.settingsName() + "MaxFreeRadius", this.defaultMaxFreeRadius, 1, 64);
        this.max_cost_radius = builder.defineInRange(this.settingsName() + "MaxCostRadius", this.defaultMaxCostRadius, 1, 64);
        this.extra_block_cost = builder.defineInRange(this.settingsName() + "ExtraBlockCost", this.defaultExtraBlockCost, 0.1, Double.MAX_VALUE);
    }

    public int getInitialCooldown() {
        ForgeConfigSpec.IntValue intValue = this.cooldown;
        Intrinsics.checkNotNull((Object)intValue);
        Object object = intValue.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cooldown!!.get()");
        return ((Number)object).intValue();
    }

    public int getCooldown(@NotNull SphereOperationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ForgeConfigSpec.IntValue intValue = this.cooldown;
        Intrinsics.checkNotNull((Object)intValue);
        Object object = intValue.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cooldown!!.get()");
        return ((Number)object).intValue();
    }

    public int getCost(@NotNull SphereOperationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int n = context.getRadius();
        ForgeConfigSpec.IntValue intValue = this.max_free_radius;
        Intrinsics.checkNotNull((Object)intValue);
        Object object = intValue.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"max_free_radius!!.get()");
        if (n <= ((Number)object).intValue()) {
            return 0;
        }
        ForgeConfigSpec.IntValue intValue2 = this.max_free_radius;
        Intrinsics.checkNotNull((Object)intValue2);
        Object object2 = intValue2.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"max_free_radius!!.get()");
        int freeBlockCount = IntMath.pow((int)(2 * ((Number)object2).intValue() + 1), (int)3);
        int allBlockCount = IntMath.pow((int)(2 * context.getRadius() + 1), (int)3);
        double d = allBlockCount - freeBlockCount;
        ForgeConfigSpec.DoubleValue doubleValue = this.extra_block_cost;
        Intrinsics.checkNotNull((Object)doubleValue);
        Object object3 = doubleValue.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"extra_block_cost!!.get()");
        return (int)Math.floor(d * ((Number)object3).doubleValue());
    }

    public final int getMaxFreeRadius() {
        ForgeConfigSpec.IntValue intValue = this.max_free_radius;
        Intrinsics.checkNotNull((Object)intValue);
        Object object = intValue.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"max_free_radius!!.get()");
        return ((Number)object).intValue();
    }

    public final int getMaxCostRadius() {
        ForgeConfigSpec.IntValue intValue = this.max_cost_radius;
        Intrinsics.checkNotNull((Object)intValue);
        Object object = intValue.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"max_cost_radius!!.get()");
        return ((Number)object).intValue();
    }

    @NotNull
    public Map<String, Object> computerDescription() {
        Map data = new HashMap();
        data.put("name", this.settingsName());
        Map map = data;
        String string = "type";
        String string2 = ((Object)((Object)this)).getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaClass.name");
        Object object = string2;
        map.put(string, object);
        map = data;
        string = "cooldown";
        ForgeConfigSpec.IntValue intValue = this.cooldown;
        Intrinsics.checkNotNull((Object)intValue);
        Object object2 = intValue.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"cooldown!!.get()");
        object = object2;
        map.put(string, object);
        map = data;
        string = "maxFreeRadius";
        ForgeConfigSpec.IntValue intValue2 = this.max_free_radius;
        Intrinsics.checkNotNull((Object)intValue2);
        Object object3 = intValue2.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"max_free_radius!!.get()");
        object = object3;
        map.put(string, object);
        map = data;
        string = "maxCostRadius";
        ForgeConfigSpec.IntValue intValue3 = this.max_cost_radius;
        Intrinsics.checkNotNull((Object)intValue3);
        Object object4 = intValue3.get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"max_cost_radius!!.get()");
        object = object4;
        map.put(string, object);
        map = data;
        string = "extraBlockCost";
        ForgeConfigSpec.DoubleValue doubleValue = this.extra_block_cost;
        Intrinsics.checkNotNull((Object)doubleValue);
        Object object5 = doubleValue.get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"extra_block_cost!!.get()");
        object = object5;
        map.put(string, object);
        return data;
    }

    @NotNull
    public final SphereOperationContext free() {
        return new SphereOperationContext(this.getMaxFreeRadius());
    }

    @NotNull
    public final SphereOperationContext cost() {
        return new SphereOperationContext(this.getMaxCostRadius());
    }

    @NotNull
    public String getSettingsPostfix() {
        return IPeripheralOperation.DefaultImpls.getSettingsPostfix((IPeripheralOperation)this);
    }

    @NotNull
    public String settingsName() {
        return IPeripheralOperation.DefaultImpls.settingsName((IPeripheralOperation)this);
    }

    public static SphereOperation[] values() {
        return (SphereOperation[])$VALUES.clone();
    }

    public static SphereOperation valueOf(String value) {
        return Enum.valueOf(SphereOperation.class, value);
    }

    static {
        $VALUES = sphereOperationArray = new SphereOperation[]{SphereOperation.SCAN_BLOCKS, SphereOperation.SCAN_ENTITIES};
    }
}

