/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraftforge.common.ForgeConfigSpec;
import twilightforest.TwilightForestMod;
import twilightforest.util.PlayerHelper;

public class TFConfig {
    public static Common COMMON_CONFIG;
    public static Client CLIENT_CONFIG;
    private static final String config = "twilightforest.config.";

    @Nullable
    public static class_2960 getPortalLockingAdvancement(class_1657 player) {
        if (!((String)TFConfig.COMMON_CONFIG.portalAdvancementLock.get()).isEmpty() && TFConfig.COMMON_CONFIG.portalLockingAdvancement == null) {
            if (!class_2960.method_20207((String)((String)TFConfig.COMMON_CONFIG.portalAdvancementLock.get())) || PlayerHelper.getAdvancement(player, class_2960.method_12829((String)((String)TFConfig.COMMON_CONFIG.portalAdvancementLock.get()))) == null) {
                TwilightForestMod.LOGGER.fatal("The portal locking advancement is not a valid advancement! Setting to null!");
                TFConfig.COMMON_CONFIG.portalAdvancementLock.set((Object)"");
            } else {
                TFConfig.COMMON_CONFIG.portalLockingAdvancement = class_2960.method_12829((String)((String)TFConfig.COMMON_CONFIG.portalAdvancementLock.get()));
                TwilightForestMod.LOGGER.debug("Portal Locking Advancement reloaded.");
            }
        }
        return TFConfig.COMMON_CONFIG.portalLockingAdvancement;
    }

    private static Optional<class_2248> parseBlock(String string) {
        class_2960 id = class_2960.method_12829((String)string);
        if (id == null || !class_2378.field_11146.method_10250(id)) {
            return Optional.empty();
        }
        return Optional.ofNullable((class_2248)class_2378.field_11146.method_10223(id));
    }

    public static class Common {
        public Dimension DIMENSION = new Dimension();
        public ForgeConfigSpec.ConfigValue<String> originDimension;
        public ForgeConfigSpec.BooleanValue allowPortalsInOtherDimensions;
        public ForgeConfigSpec.BooleanValue adminOnlyPortals;
        public ForgeConfigSpec.BooleanValue disablePortalCreation;
        public ForgeConfigSpec.BooleanValue checkPortalDestination;
        public ForgeConfigSpec.BooleanValue portalLightning;
        public ForgeConfigSpec.BooleanValue shouldReturnPortalBeUsable;
        public ForgeConfigSpec.ConfigValue<String> portalAdvancementLock;
        public ForgeConfigSpec.IntValue maxPortalSize;
        public ForgeConfigSpec.BooleanValue casketUUIDLocking;
        public ForgeConfigSpec.BooleanValue disableSkullCandles;
        public MagicTrees MAGIC_TREES = new MagicTrees();
        public UncraftingStuff UNCRAFTING_STUFFS = new UncraftingStuff();
        public ShieldInteractions SHIELD_INTERACTIONS = new ShieldInteractions();
        @Nullable
        public class_2960 portalLockingAdvancement;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings that are not reversible without consequences.").push("Dimension Settings");
            this.DIMENSION.newPlayersSpawnInTF = builder.translation("twilightforest.config.spawn_in_tf").comment("If true, players spawning for the first time will spawn in the Twilight Forest.").define("newPlayersSpawnInTF", false);
            this.DIMENSION.portalForNewPlayerSpawn = builder.translation("twilightforest.config.portal_for_new_player").comment("If true, the return portal will spawn for new players that were sent to the TF if `spawn_in_tf` is true.").define("portalForNewPlayer", false);
            builder.pop();
            this.originDimension = builder.translation("twilightforest.config.origin_dimension").comment("The dimension you can always travel to the Twilight Forest from, as well as the dimension you will return to. Defaults to the overworld. (domain:regname).").define("originDimension", (Object)"minecraft:overworld");
            this.allowPortalsInOtherDimensions = builder.translation("twilightforest.config.portals_in_other_dimensions").comment("Allow portals to the Twilight Forest to be made outside of the 'origin' dimension. May be considered an exploit.").define("allowPortalsInOtherDimensions", false);
            this.adminOnlyPortals = builder.translation("twilightforest.config.admin_portals").comment("Allow portals only for admins (Operators). This severely reduces the range in which the mod usually scans for valid portal conditions, and it scans near ops only.").define("adminOnlyPortals", false);
            this.disablePortalCreation = builder.translation("twilightforest.config.portals").comment("Disable Twilight Forest portal creation entirely. Provided for server operators looking to restrict action to the dimension.").define("disablePortalCreation", false);
            this.checkPortalDestination = builder.translation("twilightforest.config.check_portal_destination").comment("Determines if new portals should be pre-checked for safety. If enabled, portals will fail to form rather than redirect to a safe alternate destination.\nNote that enabling this also reduces the rate at which portal formation checks are performed.").define("checkPortalDestination", false);
            this.portalLightning = builder.translation("twilightforest.config.portal_lighting").comment("Set this true if you want the lightning that zaps the portal to not set things on fire. For those who don't like fun.").define("portalLightning", false);
            this.shouldReturnPortalBeUsable = builder.translation("twilightforest.config.portal_return").comment("If false, the return portal will require the activation item.").define("shouldReturnPortalBeUsable", true);
            this.portalAdvancementLock = builder.translation("twilightforest.config.portal_unlocked_by_advancement").comment("Use a valid advancement resource location as a string. For example, using the string \"minecraft:story/mine_diamond\" will lock the portal behind the \"Diamonds!\" advancement. Invalid/Empty Advancement resource IDs will leave the portal entirely unlocked.").define("portalUnlockedByAdvancement", (Object)"");
            this.maxPortalSize = builder.translation("twilightforest.config.max_portal_size").comment("The max amount of water spaces the mod will check for when creating a portal. Very high numbers may cause issues.").defineInRange("maxPortalSize", 64, 4, Integer.MAX_VALUE);
            this.casketUUIDLocking = builder.worldRestart().translation("twilightforest.config.casket_uuid_locking").comment("If true, Keepsake Caskets that are spawned when a player dies will not be accessible by other players. Use this if you dont want people taking from other people's death caskets. NOTE: server operators will still be able to open locked caskets.").define("uuid_locking", false);
            this.disableSkullCandles = builder.translation("twilightforest.config.disable_skull_candles").comment("If true, disables the ability to make Skull Candles by right clicking a vanilla skull with a candle. Turn this on if you're having mod conflict issues for some reason.").define("skull_candles", false);
            builder.comment("Settings for all things related to the uncrafting table.").push("Uncrafting Table");
            this.UNCRAFTING_STUFFS.disableUncraftingXpCost = builder.worldRestart().translation("twilightforest.config.uncrafting_xp_cost").comment("Setting this to true will make it so you dont have to pay XP to uncraft stuff. This will only affect uncrafting.\nIf you want to disable the xp cost for repairing and recrafting, see the below option.").define("disableUncraftingXpCost", false);
            this.UNCRAFTING_STUFFS.disableRepairingXpCost = builder.worldRestart().translation("twilightforest.config.repairing_xp_cost").comment("Setting this to true will make it so you dont have to pay XP to repair and recraft stuff in the uncrafting table. This wont affect uncrafting cost.\nIf you're confused about what repairing and recrafting are, you can read about them here: http://benimatic.com/tfwiki/index.php?title=Uncrafting_Table\nIf you want to disable the xp cost for uncrafting, see the above option.").define("disableRepairingXpCost", false);
            this.UNCRAFTING_STUFFS.disableUncraftingRecipes = builder.worldRestart().translation("twilightforest.config.uncrafting_recipes").comment("If you don't want to disable uncrafting altogether, and would rather disable certain recipes, this is for you.\nTo add a recipe, add the mod id followed by the name of the recipe. You can check this in things like JEI.\nExample: \"twilightforest:firefly_particle_spawner\" will disable uncrafting the particle spawner into a firefly jar, firefly, and poppy.\nIf an item has multiple crafting recipes and you wish to disable them all, add the item to the \"twilightforest:banned_uncraftables\" item tag.\nIf you have a problematic ingredient, like infested towerwood for example, add the item to the \"twilightforest:banned_uncrafting_ingredients\" item tag.").defineList("disableUncraftingRecipes", List.of("twilightforest:giant_log_to_oak_planks"), s -> s instanceof String);
            this.UNCRAFTING_STUFFS.reverseRecipeBlacklist = builder.worldRestart().translation("twilightforest.config.uncrafting_recipes_flip").comment("If true, this will invert the above uncrafting recipe list from a blacklist to a whitelist.").define("flipRecipeList", false);
            this.UNCRAFTING_STUFFS.blacklistedUncraftingModIds = builder.worldRestart().translation("twilightforest.config.uncrafting_mod_ids").comment("Here, you can disable all items from certain mods from being uncrafted.\nInput a valid mod id to disable all uncrafting recipes from that mod.\nExample: \"twilightforest\" will disable all uncrafting recipes from this mod.").defineList("blacklistedUncraftingModIds", new ArrayList(), s -> s instanceof String);
            this.UNCRAFTING_STUFFS.flipUncraftingModIdList = builder.worldRestart().translation("twilightforest.config.uncrafting_mod_id_flip").comment("If true, this will invert the above option from a blacklist to a whitelist.").define("flipIdList", false);
            this.UNCRAFTING_STUFFS.disableUncrafting = builder.worldRestart().translation("twilightforest.config.uncrafting").comment("Disable the uncrafting function of the uncrafting table. Recommended as a last resort if there's too many things to change about its behavior.").define("disableUncrafting", false);
            builder.pop();
            builder.comment("Settings for all things related to the magic trees.").push("Magic Trees");
            this.MAGIC_TREES.disableTime = builder.worldRestart().translation("twilightforest.config.disable_time").comment("If true, prevents the Timewood Core from functioning.").define("disableTimeCore", false);
            this.MAGIC_TREES.timeRange = builder.worldRestart().translation("twilightforest.config.time_range").comment("Defines the radius at which the Timewood Core works. Can be a number anywhere between 1 and 128.").defineInRange("timeCoreRange", 16, 1, 128);
            this.MAGIC_TREES.disableTransformation = builder.worldRestart().translation("twilightforest.config.disable_transformation").comment("If true, prevents the Transformation Core from functioning.").define("disableTransformationCore", false);
            this.MAGIC_TREES.transformationRange = builder.worldRestart().translation("twilightforest.config.transformation_range").comment("Defines the radius at which the Transformation Core works. Can be a number anywhere between 1 and 128.").defineInRange("transformationCoreRange", 16, 1, 128);
            this.MAGIC_TREES.disableMining = builder.worldRestart().translation("twilightforest.config.disable_mining").comment("If true, prevents the Minewood Core from functioning.").define("disableMiningCore", false);
            this.MAGIC_TREES.miningRange = builder.worldRestart().translation("twilightforest.config.mining_range").comment("Defines the radius at which the Minewood Core works. Can be a number anywhere between 1 and 128.").defineInRange("miningCoreRange", 16, 1, 128);
            this.MAGIC_TREES.disableSorting = builder.worldRestart().translation("twilightforest.config.disable_sorting").comment("If true, prevents the Sortingwood Core from functioning.").define("disableSortingCore", false);
            this.MAGIC_TREES.sortingRange = builder.worldRestart().translation("twilightforest.config.sorting_range").comment("Defines the radius at which the Sortingwood Core works. Can be a number anywhere between 1 and 128.").defineInRange("sortingCoreRange", 16, 1, 128);
            builder.pop();
            builder.comment("We recommend downloading the Shield Parry mod for parrying, but these controls remain for without.").push("Shield Parrying");
            this.SHIELD_INTERACTIONS.parryNonTwilightAttacks = builder.translation("twilightforest.config.parry_non_twilight").comment("Set to true to parry non-Twilight projectiles.").define("parryNonTwilightAttacks", false);
            this.SHIELD_INTERACTIONS.shieldParryTicks = builder.translation("twilightforest.config.parry_window").comment("The amount of ticks after raising a shield that makes it OK to parry a projectile.").defineInRange("shieldParryTicksArrow", 40, 0, Integer.MAX_VALUE);
            builder.pop();
        }

        public static class Dimension {
            public ForgeConfigSpec.BooleanValue newPlayersSpawnInTF;
            public ForgeConfigSpec.BooleanValue portalForNewPlayerSpawn;
        }

        public static class MagicTrees {
            public ForgeConfigSpec.BooleanValue disableTime;
            public ForgeConfigSpec.IntValue timeRange;
            public ForgeConfigSpec.BooleanValue disableTransformation;
            public ForgeConfigSpec.IntValue transformationRange;
            public ForgeConfigSpec.BooleanValue disableMining;
            public ForgeConfigSpec.IntValue miningRange;
            public ForgeConfigSpec.BooleanValue disableSorting;
            public ForgeConfigSpec.IntValue sortingRange;
        }

        public static class UncraftingStuff {
            public ForgeConfigSpec.BooleanValue disableUncraftingXpCost;
            public ForgeConfigSpec.BooleanValue disableRepairingXpCost;
            public ForgeConfigSpec.BooleanValue disableUncrafting;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> disableUncraftingRecipes;
            public ForgeConfigSpec.BooleanValue reverseRecipeBlacklist;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedUncraftingModIds;
            public ForgeConfigSpec.BooleanValue flipUncraftingModIdList;
        }

        public static class ShieldInteractions {
            public ForgeConfigSpec.BooleanValue parryNonTwilightAttacks;
            public ForgeConfigSpec.IntValue shieldParryTicks;
        }
    }

    public static class Client {
        public ForgeConfigSpec.BooleanValue silentCicadas;
        public ForgeConfigSpec.BooleanValue silentCicadasOnHead;
        public ForgeConfigSpec.BooleanValue firstPersonEffects;
        public ForgeConfigSpec.BooleanValue rotateTrophyHeadsGui;
        public ForgeConfigSpec.BooleanValue disableOptifineNagScreen;
        public ForgeConfigSpec.BooleanValue disableLockedBiomeToasts;
        public ForgeConfigSpec.BooleanValue showQuestRamCrosshairIndicator;

        public Client(ForgeConfigSpec.Builder builder) {
            this.silentCicadas = builder.translation("twilightforest.config.silent_cicadas").comment("Make cicadas silent for those having sound library problems, or otherwise finding them annoying.").define("silentCicadas", false);
            this.silentCicadasOnHead = builder.translation("twilightforest.config.silent_cicadas_on_head").comment("Make cicadas silent when sitting on your head. If the above option is already true, this won't have any effect.").define("silentCicadasOnHead", false);
            this.firstPersonEffects = builder.translation("twilightforest.config.first_person_effects").comment("Controls whether various effects from the mod are rendered while in first-person view. Turn this off if you find them distracting.").define("firstPersonEffects", true);
            this.rotateTrophyHeadsGui = builder.translation("twilightforest.config.animate_trophyitem").comment("Rotate trophy heads on item model. Has no performance impact at all. For those who don't like fun.").define("rotateTrophyHeadsGui", true);
            this.disableOptifineNagScreen = builder.translation("twilightforest.config.optifine").comment("Disable the nag screen when Optifine is installed.").define("disableOptifineNagScreen", false);
            this.disableLockedBiomeToasts = builder.translation("twilightforest.config.locked_toasts").comment("Disables the toasts that appear when a biome is locked. Not recommended if you're not familiar with progression.").define("disableLockedBiomeToasts", false);
            this.showQuestRamCrosshairIndicator = builder.translation("twilightforest.config.ram_indicator").comment("Renders a little check mark or x above your crosshair depending on if fed the Quest Ram that color of wool. Turn this off if you find it intrusive.").define("questRamWoolIndicator", true);
        }
    }
}

