/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import io.github.fabricators_of_create.porting_lib.block.EntityDestroyBlock;
import io.github.fabricators_of_create.porting_lib.block.ExplosionResistanceBlock;
import java.util.ArrayDeque;
import java.util.HashSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import twilightforest.block.LockedVanishingBlock;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFSounds;

public class VanishingBlock
extends class_2248
implements EntityDestroyBlock,
ExplosionResistanceBlock {
    public static final class_2746 ACTIVE = class_2746.method_11825((String)"active");
    public static final class_2746 VANISHED = class_2746.method_11825((String)"vanished");
    private static final class_265 VANISHED_SHAPE = VanishingBlock.method_9541((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);

    public VanishingBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{ACTIVE});
    }

    private boolean isVanished(class_2680 state) {
        return state.method_28498((class_2769)VANISHED) && (Boolean)state.method_11654((class_2769)VANISHED) != false;
    }

    public class_265 method_9530(class_2680 state, class_1922 getter, class_2338 pos, class_3726 ctx) {
        return this.isVanished(state) ? VANISHED_SHAPE : super.method_9530(state, getter, pos, ctx);
    }

    public class_265 method_9549(class_2680 state, class_1922 getter, class_2338 pos, class_3726 ctx) {
        return this.isVanished(state) ? class_259.method_1073() : super.method_9549(state, getter, pos, ctx);
    }

    @Deprecated
    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!this.isVanished(state) && !((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) {
            if (VanishingBlock.areBlocksLocked((class_1922)level, pos)) {
                level.method_8396(null, pos, (class_3414)TFSounds.LOCKED_VANISHING_BLOCK.get(), class_3419.field_15245, 1.0f, 0.3f);
            } else {
                this.activate(level, pos);
            }
            return class_1269.method_29236((boolean)level.method_8608());
        }
        return class_1269.field_5811;
    }

    public float getExplosionResistance(class_2680 state, class_1922 getter, class_2338 pos, class_1927 explosion) {
        return (Boolean)state.method_11654((class_2769)ACTIVE) == false ? 6000.0f : super.getExplosionResistance(state, getter, pos, explosion);
    }

    public boolean canEntityDestroy(class_2680 state, class_1922 getter, class_2338 pos, class_1297 entity) {
        return !((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue() ? !VanishingBlock.areBlocksLocked(getter, pos) : super.canEntityDestroy(state, getter, pos, entity);
    }

    private static boolean areBlocksLocked(class_1922 getter, class_2338 start) {
        int limit = 512;
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        HashSet<class_2338> checked = new HashSet<class_2338>();
        queue.offer(start);
        for (int iter = 0; !queue.isEmpty() && iter < limit; ++iter) {
            class_2338 cur = (class_2338)queue.pop();
            class_2680 state = getter.method_8320(cur);
            if (state.method_26204() == TFBlocks.LOCKED_VANISHING_BLOCK.get() && ((Boolean)state.method_11654((class_2769)LockedVanishingBlock.LOCKED)).booleanValue()) {
                return true;
            }
            checked.add(cur);
            if (!(state.method_26204() instanceof VanishingBlock)) continue;
            for (class_2350 facing : class_2350.values()) {
                class_2338 neighbor = cur.method_10093(facing);
                if (checked.contains(neighbor)) continue;
                queue.offer(neighbor);
            }
        }
        return false;
    }

    @Deprecated
    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        if (level.method_8608()) {
            return;
        }
        if (!this.isVanished(state) && !((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue() && level.method_8479(pos) && !VanishingBlock.areBlocksLocked((class_1922)level, pos)) {
            this.activate(level, pos);
        }
    }

    @Deprecated
    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (level.method_8608()) {
            return;
        }
        if (this.isVanished(state)) {
            if (((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) {
                level.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)VANISHED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false)));
            } else {
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(true)));
                level.method_39279(pos, (class_2248)this, 15);
            }
            level.method_8396(null, pos, (class_3414)TFSounds.REAPPEAR_BLOCK.get(), class_3419.field_15245, 0.3f, 0.6f);
        } else if (((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) {
            if (state.method_28498((class_2769)VANISHED)) {
                level.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)VANISHED, (Comparable)Boolean.valueOf(true)));
                level.method_39279(pos, (class_2248)this, 80);
            } else {
                level.method_8650(pos, false);
            }
            level.method_8396(null, pos, state.method_26204() == TFBlocks.REAPPEARING_BLOCK.get() ? (class_3414)TFSounds.REAPPEAR_POOF.get() : (class_3414)TFSounds.VANISHING_BLOCK.get(), class_3419.field_15245, 0.3f, 0.5f);
            for (class_2350 e : class_2350.values()) {
                this.activate((class_1937)level, pos.method_10093(e));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) {
            this.sparkle(level, pos);
        }
    }

    public void sparkle(class_1937 level, class_2338 pos) {
        class_5819 random = level.method_8409();
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.method_10263() + random.method_43057();
            double d2 = (float)pos.method_10264() + random.method_43057();
            double d3 = (float)pos.method_10260() + random.method_43057();
            if (i == 0 && !level.method_8320(pos.method_10084()).method_26216((class_1922)level, pos)) {
                d2 = (double)pos.method_10264() + d0 + 1.0;
            }
            if (i == 1 && !level.method_8320(pos.method_10074()).method_26216((class_1922)level, pos)) {
                d2 = (double)pos.method_10264() - d0;
            }
            if (i == 2 && !level.method_8320(pos.method_10072()).method_26216((class_1922)level, pos)) {
                d3 = (double)pos.method_10260() + d0 + 1.0;
            }
            if (i == 3 && !level.method_8320(pos.method_10095()).method_26216((class_1922)level, pos)) {
                d3 = (double)pos.method_10260() - d0;
            }
            if (i == 4 && !level.method_8320(pos.method_10078()).method_26216((class_1922)level, pos)) {
                d1 = (double)pos.method_10263() + d0 + 1.0;
            }
            if (i == 5 && !level.method_8320(pos.method_10067()).method_26216((class_1922)level, pos)) {
                d1 = (double)pos.method_10263() - d0;
            }
            float f1 = 1.0f;
            float f2 = Math.max(0.0f, 0.19999999f);
            float f3 = Math.max(0.0f, -0.099999964f);
            if (!(d1 < (double)pos.method_10263() || d1 > (double)(pos.method_10263() + 1) || d2 < 0.0 || d2 > (double)(pos.method_10264() + 1) || d3 < (double)pos.method_10260()) && !(d3 > (double)(pos.method_10260() + 1))) continue;
            level.method_8406((class_2394)new class_2390(new class_1160(f1, f2, f3), 1.0f), d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    private void activate(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        if (state.method_26204() instanceof VanishingBlock && !this.isVanished(state) && !((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(true)));
            level.method_39279(pos, state.method_26204(), 2 + level.method_8409().method_43048(5));
        }
    }
}

